<?php

class GroupsController extends LearningAccountAppController {

	var $modelParams = array(
		'name' => 'Group',
		'contain' => array('Classes'=>'School')
	);
	var $components = array('Filter');
	var $uses = array(
		'LearningAccount.Group', 'Learning.Classes', 'Account.User', 'Learning.Grade'
			
	);

	function teacher_index() {
		$this->paginate['Group']['contain'] = $this->modelParams['contain'];
		$this->NewFilter->filter($this->Group->filterData, 'Group');

		$this->paginate['Group']['order']['Group.created'] = 'DESC';

		$this->paginate['Group']['conditions'][] = array('Group.class_id'=> $this->getClassesId());
		$records = $this->paginate('Group');
		$this->set('records', $records);
		$this->set('title_for_layout', 'Lista grup');
	}

	function teacher_edit($id = null) {
		if (!empty($this->data)) {
			if ($this->Group->saveAll($this->data)) {
				$this->message('Rekord został zapisany!', 'index');
			} else
				$this->alert('Rekord nie zostal zapisany!');
		} elseif ($id) {
			$this->set('title_for_layout', 'Edycja rekordu');
			$this->data = $this->Group->get($id);
		} else {
			$this->set('title_for_layout', 'Dodaj rekord');
		}
		$this->set('classes', $this->Classes->getList($this->getClassesId()));
	}

	function teacher_delete($id = null) {
		if ($this->Group->delete($id)) {
			$this->message('Rekord został usunięty!');
		} else
			$this->alert('Rekord nie został usunięty!');

		$this->redirect($this->referer());
	}

	function admin_view($id) {
		$group = $this->Group->get($id,array(),array('Classes'=> 'School'));
		$title_for_layout = $group['Group']['name'].' - szczegóły grupy';
		
		//liczba ocen grupy
		
		//średnia ocen grupy
		
		$students = $this->User->find('all', array(
			'conditions'=> array('Profile.group_id'=> $id),
			'contain'=> array('Profile' => array('Group','Team','Classes'))
		));
		
		$gradesCount = 0;
		$gradesAvg = 0.00;
		
		if($students) {
			$students_id 	= Set::combine($students, '{n}.User.id','{n}.User.id');
			
			$grades 		= $this->Grade->find('all', array('fields'=> array('id','grade'),'conditions'=> array('student_id'=> $students_id)));
			$gradesCount 	= count($grades);
			
			$gradesAvg = round(  Set::apply('{n}.Grade.grade', $grades, 'array_sum') / $gradesCount, 2);
		}
		
		$this->set(compact('group','title_for_layout','students','gradesCount','gradesAvg'));
	}
	
	function admin_index() {
		
		$this->NewFilter->filter($this->Group->filterData, 'Group');
		$this->paginate['Group']['contain'] = $this->modelParams['contain'];

		$this->paginate['Group']['order']['Group.created'] = 'DESC';
//		$this->paginate['Group']['conditions'][]['Group.class_id'] = $this->getClassesId();
		$records = $this->paginate('Group');
		$this->set('records', $records);
		$this->set('title_for_layout', 'Lista grup');
	}

	function admin_edit($id = null) {
		if (!empty($this->data)) {
			if ($this->Group->saveAll($this->data)) {
				$this->message('Rekord został zapisany!', 'index');
			} else
				$this->alert('Rekord nie zostal zapisany!');
		} elseif ($id) {
			$this->set('title_for_layout', 'Edycja rekordu');
			$this->data = $this->Group->get($id);
		} else {
			$this->set('title_for_layout', 'Dodaj rekord');
		}
		$this->set('classes', $this->Classes->getList($this->getClassesId()));
	}

	function admin_delete($id = null) {
		if ($this->Group->delete($id)) {
			$this->message('Rekord został usunięty!');
		} else
			$this->alert('Rekord nie został usunięty!');

		$this->redirect($this->referer());
	}

	function beforeFilter() {
		parent::beforeFilter();
		$this->set('modelParams', $this->modelParams);
		$this->Auth->allow('index', 'view');
	}

}