<?php

class LoginHistoryController extends LearningAccountAppController {

	var $name = 'LoginHistory';
	var $components = array('Email', 'Auth', 'Session', 'SavePaginate');
	var $uses = array('Account.LoginHistory');

	function teacher_index() {
		$this->Config->selectMenu('login_history');
		
		$this->NewFilter->filter($this->LoginHistory->filterDataTeacher, 'LoginHistory');
		
		$conditions = array();
		if (!empty($this->params['named']['user_id'])) {
			$user = $this->LoginHistory->User->find('first', array('recursive' => -1, 'conditions' => array('User.id' => $this->params['named']['user_id'])));
			$conditions = array('LoginHistory.user_id' => $this->params['named']['user_id']);
			if (!empty($user))
				$this->set('user', $user);
		}


		$this->paginate['LoginHistory']['contain'] = array('User');
		$this->paginate['LoginHistory']['order'] = 'LoginHistory.created desc';
		$this->paginate['LoginHistory']['conditions'][] = array('User.admin' => 0);
		$this->paginate['LoginHistory']['conditions'][] = array('User.teacher'=> 0);

		$this->paginate['LoginHistory']['conditions'][] = array('User.id' => $this->LoginHistory->User->Profile->find('list', array('fields'=>array('user_id','user_id'),'conditions'=> array('Profile.class_id'=> $this->getClassesId() ))));
		$login_history = $this->paginate('LoginHistory');
		$this->set('registersCount', $this->LoginHistory->User->find('count', array('conditions' => array('User.admin' => 0, 'User.teacher' => 0))));

		$this->set('login_history', $login_history);
	}

	function beforeFilter() {
		parent::beforeFilter();
		$this->set('title_for_layout', 'Historia logowań');
	}

}

