<?php

class UsersController extends LearningAccountAppController {

	var $name = 'Users';
	var $uses = array('Account.User', 'Learning.Classes', 'LearningAccount.Group', 'Learning.Team');
	var $components = array('Email', 'Auth', 'Session', 'SavePaginate', 'Account.History');
	var $helpers = array('Js');
	



	function beforeFilter(){
		parent::beforeFilter();
		$this->Config->selectMenu('students');
	}

	function setFilterConditions($fieldFilerName, $fieldBaseName) {
		if (isSet($this->data['Filter'][$fieldFilerName])) {
			if ($this->data['Filter'][$fieldFilerName] === '')
				unset($this->paginate['conditions'][$fieldBaseName]);
			else {
				$this->paginate['conditions'][$fieldBaseName] = $this->data['Filter'][$fieldFilerName];
			}
		}
	}

	function admin_delete($id = null) {
		if ($id) {
			if ($this->User->delete($id)) {
				$this->message('Użytkownik został usunięty');
			} else {
				$this->alert('Wystąpił błąd podczas usuwania użytkownika');
			}
		}
		$this->redirect($this->referer());
	}

	function admin_edit($id = null) {
		if (!empty($this->data)) {
			if (!empty($this->data['Profile']['class_id'])) {
				$this->data['Profile']['school_id'] = $this->Classes->field('school_id', array('id' => $this->data['Profile']['class_id']));
			}
			if ($this->User->saveAll($this->data)) {
				$this->message('Zmiany zostały zapisane');
				$this->redirect(array('action' => 'index'));
			} else {
				$this->alert('Wystąpiły błędy w formularzu. Spróbuj ponownie');
			}
		} else {
			$this->data = $this->User->find('first', array('conditions' => array('User.id' => $id), 'contain' => 'Profile'));
		}

		$this->set('title_for_layout', 'Edycja ucznia');
		$this->_dataForEdit($id);
	}
	
	function admin_index() {
		$this->NewFilter->filter($this->User->filterDataStudent, 'User');
		$this->paginate['User']['fields'] = array('User.id', 'User.username', 'User.created', 'User.admin', 'User.email', 'User.avatar','User.active',);
		$this->paginate['User']['conditions'][] = array('admin' => 0, 'teacher' => 0);
		$this->paginate['User']['conditions']['Profile.class_id'] = $this->getClassesId();
		$this->paginate['User']['contain'] = array('Profile' => array('Group','Team','Classes'));

	
		$users = $this->paginate('User');
		$this->set(compact('users'));

		$this->set('title_for_layout', 'Lista uczniów');
	}

	function admin_activate($profile_id) {
		$profile = $this->User->Profile->get($profile_id, array(), array('User' => array('email')));
		if (!$profile) {
			$this->alert('Brak profilu ucznia!', $this->referer());
		}

		$this->User->Profile->id = $profile_id;

		if ($profile['Profile']['group_id'] && $profile['Profile']['team_id']) {
			// poprostu aktywuj i wróć do listy
			if ($this->User->Profile->saveField('active', 1)) {
				$this->__sendConfirmationEmail($profile);
				$this->message('Konto zostało aktywowane!');
			} else
				$this->alert('Konto nie zostało aktywowane!');

			$this->redirect($this->referer());
		}

		$this->_dataForEdit($profile['Profile']['user_id']);
		if (!empty($this->data)) {
			$this->User->Profile->set($this->data);
			if ($this->User->Profile->validates()) {
				if ($this->User->Profile->save($this->data)) {
					$sent = $this->__sendConfirmationEmail($profile);
					if ($sent) {
						$this->message('Konto zostało aktywowane!', 'index');
					} else
						$this->alert('Konto zostało aktywowane! Jednak wiadomość potwierdzająca nie została wysłana!', 'index');
				} else
					$this->alert('Konto nie zostało aktywowane!');
			}
		} else {
			$this->data = $this->User->Profile->get($profile_id);
		}

		$this->alert('Przed aktywacją ucznia, musisz przypisać go do grupy i zespołu!');
		$this->set('profile_id', $profile_id);
		$this->set('title_for_layout', sprintf('%s %s - Aktywacja konta', $profile['Profile']['fname'], $profile['Profile']['lname']));
	}
	
	function teacher_index() {

		$this->NewFilter->filter($this->User->filterDataStudentTeacher, 'User');

		$this->paginate['User']['fields'] = array('User.id', 'User.username', 'User.created', 'User.admin', 'User.email', 'User.avatar');
		$this->paginate['User']['conditions'][] = array('admin' => 0, 'teacher' => 0);
		$this->paginate['User']['conditions']['Profile.class_id'] = $this->getClassesId();
		$this->paginate['User']['contain'] = array('Profile' => array('Group','Team','Classes'));

		$users = $this->paginate('User');
		$this->set(compact('users'));

		
		$this->set('title_for_layout', 'Lista uczniów');
	}


	function _dataForEdit($id) {
		$classes_ids = $this->getClassesId();
		$this->set('classes', $this->Classes->getList( $classes_ids ));
		$data = array();

		$groups = $this->Group->find('all', array('conditions'=> array('Group.class_id'=> $classes_ids)));
		$data['groups'] = Set::combine($groups, '{n}.Group.id', '{n}.Group.name', '{n}.Group.class_id');

		$teams = $this->Team->find('all', array('conditions'=> array('Group.class_id'=> $classes_ids), 'contain'=> 'Group'));
		$data['teams'] = Set::combine($teams, '{n}.Team.id', '{n}.Team.name', '{n}.Team.group_id');

		$this->set('data', $data);

		$this->set('avatar', $this->User->field('avatar', array('id' => $id)));
	}

	function teacher_edit($id = null) {
		if (!empty($this->data)) {
			if (!empty($this->data['Profile']['class_id'])) {
				$this->data['Profile']['school_id'] = $this->Classes->field('school_id', array('id' => $this->data['Profile']['class_id']));
			}
			if ($this->User->saveAll($this->data)) {
				$this->message('Zmiany zostały zapisane');
				$this->redirect(array('action' => 'index'));
			} else {
				$this->alert('Wystąpiły błędy w formularzu. Spróbuj ponownie');
			}
		} else {
			$this->data = $this->User->find('first', array('conditions' => array('User.id' => $id), 'contain' => 'Profile'));
		}

		$this->set('title_for_layout', 'Edycja ucznia');
		$this->_dataForEdit($id);
	}

	function teacher_activate($profile_id) {
		$profile = $this->User->Profile->get($profile_id, array(), array('User' => array('email')));
		if (!$profile) {
			$this->alert('Brak profilu ucznia!', $this->referer());
		}

		$this->User->Profile->id = $profile_id;

		if ($profile['Profile']['group_id'] && $profile['Profile']['team_id']) {
			// poprostu aktywuj i wróć do listy
			if ($this->User->Profile->saveField('active', 1)) {
				$this->__sendConfirmationEmail($profile);
				$this->message('Konto zostało aktywowane!');
			} else
				$this->alert('Konto nie zostało aktywowane!');

			$this->redirect($this->referer());
		}

		$this->_dataForEdit($profile['Profile']['user_id']);
		if (!empty($this->data)) {
			$this->User->Profile->set($this->data);
			if ($this->User->Profile->validates()) {
				if ($this->User->Profile->save($this->data)) {
					$sent = $this->__sendConfirmationEmail($profile);
					if ($sent) {
						$this->message('Konto zostało aktywowane!', 'index');
					} else
						$this->alert('Konto zostało aktywowane! Jednak wiadomość potwierdzająca nie została wysłana!', 'index');
				} else
					$this->alert('Konto nie zostało aktywowane!');
			}
		} else {
			$this->data = $this->User->Profile->get($profile_id);
		}

		$this->alert('Przed aktywacją ucznia, musisz przypisać go do grupy i zespołu!');
		$this->set('profile_id', $profile_id);
		$this->set('title_for_layout', sprintf('%s %s - Aktywacja konta', $profile['Profile']['fname'], $profile['Profile']['lname']));
	}

	function __sendConfirmationEmail($profile) {
		$sent = $this->Config->emailSend(array(
				'to' => $profile['User']['email'],
				'subject' => 'Twoje konto zostało potwierdzone przez nauczyciela',
				'template' => 'profile_confirmed',
				'data' => array('profile' => $profile)
			));
		return $sent;
	}

	function teacher_change_password() {
		if (!empty($this->data)) {
			$this->User->create();
			$this->data['User']['id'] = $this->Auth->user('id');
			$this->data['User']['password'] = $this->Auth->password($this->data['User']['new_password']);
			if ($this->User->save($this->data, true, array('old_password', 'new_password', 'rep_password', 'password'))) {
				$this->message('Hasło zostało zmienione');
				$this->redirect('/teacher');
			} else {
				$this->alert('W formularzu wystąpiły błędy. Poniżej są one dokładnie opisane przy każdym z pól.');
			}
		}
	}

	function teacher_delete($id = null) {
		if ($id) {
			if ($this->User->delete($id)) {
				$this->message('Użytkownik został usunięty');
			} else {
				$this->alert('Wystąpił błąd podczas usuwania użytkownika');
			}
		}
		$this->redirect($this->referer());
	}

}
