<?php

class Group extends LearningAccountAppModel {

	var $name = 'Group';
	var $useTable = 'learning_groups';
	var $validate = array(
		'class_id' => array(
			'rule' => 'notEmpty',
			'message' => 'Pole nie może być puste'
		),
		'name' => array(
			'rule' => 'notEmpty',
			'message' => 'Pole nie może być puste'
		)
	);

	var $filterData = array(
		'basic'=> array(

			'name'=> array('type'=> 'like'),
			'class'=> array('type'=> 'like', 'model'=>'Classes','field'=> 'name'),
			'school'=> array('cond'=> array('Group.id IN ( SELECT id FROM learning_groups WHERE school_id IN (SELECT id FROM learning_schools WHERE name LIKE "%#replace#%"))'), 'model'=>'School','field'=> 'name'),
			'created'=> array('type'=> 'date_between'),	
		)

	);	
	
	var $belongsTo = array(
		'Classes' => array(
			'className' => 'Learning.Classes',
			'foreignKey' => 'class_id'
		)
	);

	var $hasMany = array(
		'Team'=> array(
			'className'=> 'LearningAccount.Team',
			'foreignKey' => 'group_id',
			'dependent'=> true
		)
	);

	function getList($classes_id = array()){
		$classes = $this->Classes->find('all', array('contain'=> array('School', 'Group'), 'order'=> 'Classes.name' , 'conditions'=> array('Classes.id'=> $classes_id) ));
		return $this->generateList( $classes );
	}

	function generateList($list){
		$options = array();
		foreach ($list as $class) {
			foreach ($class['Group'] as $group) {
				$options[$group['id']] = sprintf('%s -> %s -> %s', $class['School']['name'], $class['Classes']['name'], $group['name']);
			}
		}
		return $options;
	}

}