<?php

class CommentsController extends LearningContentAppController {

	var $modelParams = array(
		'name' => 'Comment',
		'contain' => array('User','News')
	);

	function admin_index() {
		$this->set('title_for_layout', 'Lista komentarzy');
		
		$this->NewFilter->filter($this->Comment->filterData, 'Comment');
		
		$this->paginate['Comment']['contain'] = $this->modelParams['contain'];
		$records = $this->paginate($this->modelParams['name']);
		$this->set('records', $records);
	}

	function admin_edit($id = null) {
		if (!empty($this->data)) {
			if ($this->{ $this->modelParams['name'] }->save($this->data)) {
				$this->message('Rekord został zapisany!', 'index');
			} else
				$this->alert('Rekord nie zostal zapisany!');
		} elseif ($id) {
			$this->set('title_for_layout', 'Edycja rekordu');
			$this->data = $this->{ $this->modelParams['name'] }->get($id);
		} else {
			$this->set('title_for_layout', 'Dodaj rekord');
		}
	}

	function admin_delete($id = null) {
		if ($this->{ $this->modelParams['name'] }->delete($id)) {
			$this->message('Rekord został usunięty!');
		} else
			$this->alert('Rekord nie został usunięty!');

		$this->redirect($this->referer());
	}

	function teacher_index() {
		$this->set('title_for_layout', 'Lista komentarzy');
		$this->NewFilter->filter($this->Comment->filterData, 'Comment');
		$this->paginate['Comment']['contain'] = $this->modelParams['contain'];
		$this->paginate['Comment']['conditions']['News.user_id'] = $this->Auth->user('id');
		$records = $this->paginate($this->modelParams['name']);
		$this->set('records', $records);
	}

	function teacher_edit($id = null) {
		if (!empty($this->data)) {
			if ($this->{ $this->modelParams['name'] }->save($this->data)) {
				$this->message('Rekord został zapisany!', 'index');
			} else
				$this->alert('Rekord nie zostal zapisany!');
		} elseif ($id) {
			$this->set('title_for_layout', 'Edycja rekordu');
			$this->data = $this->{ $this->modelParams['name'] }->get($id);
		} else {
			$this->set('title_for_layout', 'Dodaj rekord');
		}
	}

	function teacher_delete($id = null) {
		if ($this->{ $this->modelParams['name'] }->delete($id)) {
			$this->message('Rekord został usunięty!');
		} else
			$this->alert('Rekord nie został usunięty!');

		$this->redirect($this->referer());
	}

	function user_edit($id) {
		if (!$id)
			$this->alert('Brak numeru id rekordu!', '/');

		$comment = $this->Comment->get($id);
		if($comment['Comment']['user_id'] != $this->Auth->user('id') && !$this->Auth->user('admin') && !$this->Auth->user('teacher'))
			$this->alert('Brak dostępu', '/');

		$news_id = $this->Comment->field('news_id', array('id' => $id));
		$new = $this->Comment->News->get($news_id);
		$this->set('new', $new);

		if (!empty($this->data)) {
			if ($this->{ $this->modelParams['name'] }->save($this->data)) {
				$this->message('Komentarz został zapisany!', array('user' => false, 'controller' => 'news', 'action' => 'view', 'news_id' => $new['News']['id'], 'slug' => slug($new['News']['title'])));
			} else
				$this->alert('Komentarz nie zostal zapisany!');
		} elseif ($id) {
			$this->set('title_for_layout', 'Edycja rekordu');
			$this->data = $this->{ $this->modelParams['name'] }->get($id);
		}
	}

	function user_delete($id) {
		$comment = $this->Comment->get($id);
		if($comment['Comment']['user_id'] != $this->Auth->user('id') && !$this->Auth->user('admin') && !$this->Auth->user('teacher'))
			$this->alert('Brak dostępu', '/');
		if ($this->{ $this->modelParams['name'] }->delete($id)) {
			$this->message('Rekord został usunięty!');
		} else
			$this->alert('Rekord nie został usunięty!');

		$this->redirect($this->referer());
	}

	function beforeFilter() {
		parent::beforeFilter();
		$this->Config->selectMenu('news');
		$this->set('modelParams', $this->modelParams);
	}

}