<?php

class NewsController extends LearningContentAppController {

	var $name = 'News';
	var $disallow = array('edit', 'publish');
	var $news_id = null;
	var $uses = array('LearningContent.News', 'LearningContent.Files', 'LearningContent.Picture', 'Learning.Classes', 'Learning.TeacherClass', 'Learning.Teacher');
	var $helpers = array('Javascript', 'Text', 'Time', 'Number', 'Ajax', 'TinyMce.TinyMce');
	var $components = array('Session', 'Seo.Seo');
	var $paginate = array('limit' => 10);

	function view() {
		$id = $this->Config->getParam('news_id', true);
		$conditions = ($this->Auth->user('admin') || $this->Auth->user('teacher') ) ? array() :array('published' => 1);
		
		$new = $this->News->find('first', array('contain' => array('User'), 'conditions' => array('News.id' => $id) + $conditions));

		if (empty($new)) {
			$this->alert('Brak wpisu w bazie danych', '/');
		}

		$files = $this->Files->find('all', array(
				'conditions' => array('Files.news_id' => $new['News']['id']),
				'order' => array('position' => 'desc'))
		);

		$pictures = $this->Picture->find('all', array('conditions' => array('Picture.news_id' => $new['News']['id']), 'order' => array('position' => 'desc')));

		$this->set(compact('new', 'files', 'pictures'));
		$this->set('newsImgFolder', $this->News->storeFolder(true));

		$this->Seo->set($new['News']);

		$this->set('title_for_layout', $this->Config->setTitleForLayout($new['News']['title']));

		if ($new['News']['comments_enabled']) {
			$this->__handleComment($id);
		}
	}

	function __handleComment($news_id) {

		if (!empty($this->data)) {
			$this->data['Comment']['user_id'] = $this->Auth->user('id');
			$this->data['Comment']['news_id'] = $news_id;
			if ($this->News->Comment->save($this->data)) {
				$this->data = null;
				$this->message('Twój komentarz został zapisany!');
			} else
				$this->alert('Twój komentarz nie został zapisany!');
		}

		$comments = $this->News->Comment->find('all', array('order' => 'Comment.created DESC', 'contain' => array('User'), 'conditions' => array('Comment.news_id' => $news_id)));
		$this->set('comments', $comments);
	}

	function downloadFile() {
		$this->view = 'media';
		$file_id = $this->Config->getParam('file_id', true);

		$file = $this->Files->get($file_id);

		if (empty($file)) {
			$this->alert('Brak pliku', '/');
		}

		$this->Files->id = $file_id;
		$this->Files->saveField('downloads_count', $file['Files']['downloads_count'] + 1);
		$extension = end(explode('.', $file['Files']['url']));
		$params = array(
			'id' => $file['Files']['url'],
			'name' => slug($file['Files']['title']),
			'download' => true,
			'extension' => $extension,
			'path' => $this->Files->storeFolder(),
			'mimeType' => array($extension => $file['Files']['type'])
		);

		$this->set($params);
	}

	function teacher_delete($id = null) {

		if ($id) {
			if ($this->News->delete($id)) {
				$this->Session->setFlash('Pozycja została skasowana', 'default', array());
			} else
				$this->Session->setFlash('Pozycja nie została skasowana', 'default', array('class' => 'alert'));
		}

		$this->redirect($this->referer());
	}

	function teacher_index() {
		$this->NewFilter->filter($this->News->filterData, 'News');
		$this->paginate['News']['conditions'][] = array('user_id' => $this->Auth->user('id'));

		$defaultOrder = array('News.position' => 'desc');

		$this->paginate['News']['order'] = $defaultOrder;
		$news = $this->paginate('News');
		$this->set('news', $news);
	}

	function teacher_move($id=null, $direction = 0) {// 1 = up 0 = down
		if ($id) {
			$this->News->id = $id;
			if ($this->News->move($id, $direction)) {
				$this->Session->setFlash('Pozycja została zmieniona');
			} else {
				$this->Session->setFlash($this->News->getErrMsg(), 'default', array('class' => 'alert'));
			}
		}

		$this->redirect($this->referer());
	}

	function teacher_edit($id = false) {

		if (!empty($this->data)) {
			if(!$id) $this->data['News']['user_id'] = $this->Auth->user('id');
			if ($this->News->saveAll($this->data)) {
				$filesSaved = !empty($this->data['Files']) ? $this->Files->saveFiles($this->data['Files'], $this->News->id) : true;
				$imagesSaved = !empty($this->data['Picture']) ? $this->Picture->saveImages($this->data['Picture'], $this->News->id) : true;
				$this->message(sprintf('Rekord <em><a href = "%s">%s</a></em> został zapisany',
						Router::url(array('teacher' => false, 'action' => 'view', 'news_id' => $this->News->id, 'slug' => slug($this->data['News']['title']))),
						$this->data['News']['title']
					), array('action' => 'index'));
			} else {
				$this->alert('Rekord nie został zapisany. Spróbuj ponownie.');
			}
		} elseif ($id) {
			$this->data = $this->News->get($id, array(), array('Classes'));
		}

		if ($id) {
			$files = $this->Files->find('all', array('conditions' => array('news_id' => $id), 'order' => array('position' => 'desc')));
			$pictures = $this->Picture->find('all', array('conditions' => array('news_id' => $id), 'order' => array('position' => 'desc')));
			$this->set(compact('files', 'pictures'));
			$this->set('title_for_layout', 'Edytuj wpis');
		} else {
			$this->set('title_for_layout', 'Dodaj wpis');
		}

		$classes_ids = $this->getClassesId(); // from app_controller
		$this->set('classes', $this->Classes->getList($this->getClassesId()));

		$url = $this->News->field('url', array('id' => $id));
		$this->set(compact('id', 'url'));
	}

	function admin_saveFile($news_id = null) {
		$this->layout = 'ajax';
		$url = null;
		Configure::write('debug', 0);
		$old_url = $this->News->field('url', array('id' => $news_id));

		if (!empty($this->data['News']['file']['tmp_name'])) {
			$url = $this->News->savePicture($this->data, $news_id);
			if ($url) {
				$saved = true;
			} else {
				$url = $old_url;
				$saved = false;
			}
		}
		$this->set('url', $url);
		$this->set('news_id', $news_id);
		$this->set('saved', $saved);
	}

	function _isAuthorized() {
		if ($this->Auth->user('admin'))
			return true;

		if (in_array($this->action, $this->disallow)) {
			$user_id = $this->Auth->user('id');

			if (!empty($this->params['pass'][0]) || $this->news_id) {
				$news_id = $this->news_id ? $this->news_id : $this->params['pass'][0];
				$news_user_id = $this->News->field('user_id', array('id' => $news_id));
				if ($user_id != $news_user_id)
					return false;
				else
					return true;
			} else
				return false;
		} else
			return true;
	}

	function isAuthorized() {
		return true;
	}

	function lastEntries($limit = 1) {

		$data['data'] = $this->News->find('all', array(
				//'recursive' => -1,
				'fields' => array('News.id', 'News.created', 'News.header', 'News.title', 'News.url', 'News.alias'),
				'contain' => array(),
				'order' => 'News.position desc',
				'limit' => $limit,
				'conditions' => array('published' => 1)
			));

		$data['storeFolder'] = $this->News->storeFolder(1);

		return $data;
	}

	function admin_editPicture($id = null) {
		if ($id) {

			if (!empty($this->data)) {

				if ($this->Picture->save($this->data)) {
					$this->Session->setFlash('Obraz został zapisany');
					$this->redirect(array('action' => 'edit', $this->Picture->field('news_id')));
				} else {
					$this->Session->setFlash('Błąd: obraz nie został zapisany.', 'default', array('class' => 'alert'));
				}
			}
			$this->data = $this->Picture->read(null, $id);
		}
	}

	function admin_move($id=null, $direction = 0) {// 1 = up 0 = down
		if ($id) {
			$this->News->id = $id;
			if ($this->News->move($id, $direction)) {
				$this->Session->setFlash('Pozycja została zmieniona');
			} else {
				$this->Session->setFlash($this->News->getErrMsg(), 'default', array('class' => 'alert'));
			}
		}

		$this->redirect($this->referer());
	}

	function admin_product_move($id=null, $direction = 0) {// 1 = up 0 = down
		if ($id) {
			$this->News->id = $id;
			if ($this->News->move($id, $direction)) {
				$this->Session->setFlash('Pozycja została zmieniona');
			}else
				$this->Session->setFlash($this->News->getErrMsg(), 'default', array('class' => 'alert'));
		}

		$this->redirect($this->referer());
	}

	function admin_picture_move($id=null, $direction = 0) {// 1 = up 0 = down
		if ($id) {

			$this->Picture->id = $id;
			if ($this->Picture->move($id, $direction)) {
				$this->Session->setFlash('Obraz został przeniesiony');
			}else
				$this->Session->setFlash('Brak kolejnego elementu', 'default', array('class' => 'alert'));
		}

		$this->redirect($this->referer() . '#edycja-obrazow');
	}

	function admin_file_move($id=null, $direction = 0) {// 1 = up 0 = down
		if ($id) {

			$this->Files->id = $id;
			if ($this->Files->move($id, $direction)) {
				$this->Session->setFlash('Plik został przeniesiony', 'default', array(), 'file_edit');
			}else
				$this->Session->setFlash('Brak kolejnego elementu', 'default', array('class' => 'alert'), 'file_edit');
		}

		$this->redirect($this->referer() . "#edycja-plikow");
	}

	function admin_index() {


		$defaultOrder = array('News.position' => 'desc');

		$this->NewFilter->filter($this->News->filterData, 'News');
		
		$this->paginate['News']['order'] = $defaultOrder;
		if (!empty($this->controller->params['named']['sort']) && !empty($this->controller->params['named']['direction'])) {
			$this->controller->paginate['order'][$this->controller->params['named']['sort']] = $this->controller->params['named']['direction'];
		}

		if (!empty($this->params['named']['sort']) && !empty($this->params['named']['direction'])) {
			$this->paginate['order'][$this->params['named']['sort']] = $this->params['named']['direction'];
		}

		$news = $this->paginate('News');
		$this->set('news', $news);
	}

	function admin_edit($id = false) {

		if (!empty($this->data)) {
			if(!$id) $this->data['News']['user_id'] = $this->Auth->user('id');
			if ($this->News->saveAll($this->data)) {
				$filesSaved = !empty($this->data['Files']) ? $this->Files->saveFiles($this->data['Files'], $this->News->id) : true;
				$imagesSaved = !empty($this->data['Picture']) ? $this->Picture->saveImages($this->data['Picture'], $this->News->id) : true;
				$this->message(sprintf('Rekord <em><a href = "%s">%s</a></em> został zapisany',
						Router::url(array('admin' => false, 'action' => 'view', 'news_id' => $this->News->id, 'slug' => slug($this->data['News']['title']))),
						$this->data['News']['title']
					), array('action' => 'index'));
			} else {
				$this->alert('Rekord nie został zapisany. Spróbuj ponownie.');
			}
		} elseif ($id) {
			$this->data = $this->News->get($id, array(), array('Classes'));
		} else {
			$this->data['News']['user_id'] = $this->Auth->user('id');
		}

		if ($id) {
			$files = $this->Files->find('all', array('conditions' => array('news_id' => $id), 'order' => array('position' => 'desc')));
			$pictures = $this->Picture->find('all', array('conditions' => array('news_id' => $id), 'order' => array('position' => 'desc')));
			$this->set(compact('files', 'pictures'));
			$this->set('title_for_layout', 'Edytuj wpis');
		} else {
			$this->set('title_for_layout', 'Dodaj wpis');
		}

		$this->set('classes', $this->Classes->getList($this->getClassesId()));
		$url = $this->News->field('url', array('id' => $id));
		$this->set(compact('id', 'url'));
		$this->set('users', $this->News->User->find('list', array('fields'=> array('id','username'),'conditions'=> array('or'=> array('User.admin >='=> 1, 'User.teacher'=> 1) ))));
	}

	function admin_deleteFile($id=null) {
		if ($id) {
			if ($this->Files->delete($id)) {
				$this->Session->setFlash('Plik został skasowany', 'default', array(), 'file_edit');
			} else
				$this->Session->setFlash('Plik nie został skasowany', 'default', array('class' => 'alert'), 'file_edit');
		}

		$this->redirect($this->referer() . '#edycja-plikow');
	}
	
	function teacher_deleteNewsPicture($id) {

		if ($id) {
			$this->News->id = $id;

			if ($this->News->deletePicture($id)) {

				$this->Session->setFlash('Obraz został skasowany', 'default', array());
			} else {
				$this->Session->setFlash('Obraz nie został skasowany', 'default', array('class' => 'alert'));
			}
		}

		$this->redirect($this->referer());
	}
	
	function admin_deleteNewsPicture($id) {

		if ($id) {
			$this->News->id = $id;

			if ($this->News->deletePicture($id)) {

				$this->Session->setFlash('Obraz został skasowany', 'default', array());
			} else {
				$this->Session->setFlash('Obraz nie został skasowany', 'default', array('class' => 'alert'));
			}
		}

		$this->redirect($this->referer());
	}

	function admin_deletePicture($id=null) {
		if ($id) {
			if ($this->Picture->delete($id)) {
				$this->Session->setFlash('Obraz został skasowany', 'default', array());
			} else
				$this->Session->setFlash('Obraz nie został skasowany', 'default', array('class' => 'alert'));
		}

		$this->redirect($this->referer() . '#edycja-obrazow');
	}

	function admin_deleteNewsPictureAjax($id) {
		$this->layout = 'ajax';
		Configure::write('debug', 0);
		$url = false;
		if ($id) {
			$this->News->id = $id;
			$url = $this->News->field('url');
			if ($this->News->deletePicture($id)) {
				$deleted = true;
			} else {
				$deleted = false;
			}
		}
		$this->set('deleted', $deleted);
		$this->set('url', $url);
	}

	function admin_delete($id = null) {

		//$categoryAlias = $this->NewsCategory->field('alias',array('id'=>$this->News->field('category_id',array('id'=>$id))));

		if ($id) {
			if ($this->News->delete($id)) {
				$this->Session->setFlash('Pozycja została skasowana', 'default', array());
			} else
				$this->Session->setFlash('Pozycja nie została skasowana', 'default', array('class' => 'alert'));
		}

		$this->redirect($this->referer());
	}

	function getBreadCrumbs($alias=null) {

		$category_id = $this->LearningContentsCategory->field('id', array('alias' => $alias));
		$parents = $this->LearningContentsCategory->getpath($category_id);
		$breadCrumbs = $this->_generateBreadCrumbs($parents);

		return $breadCrumbs;
	}

	function _generateBreadCrumbs($treePath=null) {

		return;

		$breadCrumbs = array();
		if (!$treePath)
			return array();
		foreach ($treePath as $key => $path) {
			if (isset($treePath[$key + 1])) {
				if ($path['LearningContentsCategory']['dynamic'] == 0) {
					$linkPath = array('plugin' => null, 'controller' => 'pages', 'action' => 'display', $path['LearningContentsCategory']['alias']);
				} else {
					$linkPath = array('plugin' => null, 'controller' => 'pages', 'action' => 'display', 'home');
				}
				$breadCrumbs[$path['LearningContentsCategory']['title']] = $linkPath;
			}
			else
				$breadCrumbs[] = $path['LearningContentsCategory']['title'];
		}

		return $breadCrumbs;
	}

	function _emailAdminPublish($id = null) {
		$news = $this->News->find('first', array('contain' => array('User' => array('username', 'alias', 'id', 'email')), 'fields' => array()));

		$this->Email->to = $news['User']['email'];
		$this->Email->subject = 'Twoja zguba została opublikowana';
		$this->Email->replyTo = $this->emailReplyTo;
		$this->Email->from = $this->emailName;
		$this->Email->template = 'learning_content_publish';
		$this->Email->sendAs = 'html';
		$this->set('data', $news);
		return($this->Email->send());
	}

	function teacher_publish($id = null) {
		$published = $this->News->field('published', array('id' => $id));
		$publish = $published ? 0 : 1;
		$this->News->id = $id;
		if ($this->News->saveField('published', $publish)) {
			if ($publish) {
				$this->Session->setFlash('Wpis został opublikowany', 'default', array());
			}
			else
				$this->Session->setFlash('Wpis został ukryty', 'default', array());
		} else
			$this->Session->setFlash('Błąd: nie można zmienić statusu wpisu', 'default', array('class' => 'alert'));

		$this->redirect($this->referer());
	}

	function admin_publish($id = null) {
		$published = $this->News->field('published', array('id' => $id));
		$publish = $published ? 0 : 1;
		$this->News->id = $id;
		if ($this->News->saveField('published', $publish)) {
			if ($publish) {
				$this->Session->setFlash('Wpis został opublikowany', 'default', array());
			}
			else
				$this->Session->setFlash('Wpis został ukryty', 'default', array());
		} else
			$this->Session->setFlash('Błąd: nie można zmienić statusu wpisu', 'default', array('class' => 'alert'));

		$this->redirect($this->referer());
	}	
	
	function admin_users($q=null) {
		Configure::write('debug', 0);

		$this->layout = 'ajax';
		if ($q) {
			$users = $this->News->User->find('all', array('order' => array('alias' => 'asc'), 'conditions' => array('alias LIKE "' . $q . '%"'), 'fields' => array('username', 'alias', 'admin', 'id'), 'recursive' => -1));
			$this->set('users', $users);
		}
	}

	function index() {
		$this->set('title_for_layout', 'Aktualności');

		$class_id = $this->getClassesId(); // in app_controller.php
		$this->paginate['conditions']['or']['News.id'] = $this->News->getNewsForClasses($class_id);
		$this->paginate['conditions']['or']['News.open'] = 1;
		
		$this->paginate['conditions']['News.published'] = 1;
		$this->paginate['contain'] = array('User');

		$this->paginate['limit'] = 5;
		$this->paginate['order']['News.position'] = 'desc';

		$news = $this->paginate('News');

		$this->set('news', $news);
		$this->set('newsImgFolder', $this->News->storeFolder(true));
		$this->set('alias', null);
	}

	function userIndex() {

		$this->paginate['conditions']['News.user_id'] = $this->Auth->user('id');

		$this->paginate['order']['News.position'] = 'desc';

		$news = $this->paginate('News');

		$this->set('news', $news);
	}

	function _setCategoriesRecursively($categories, $step=0, $char='--') {
		foreach ($categories as $category) {
			if (!empty($category['children'])) {
				$categoriesToReturn[$this->_generateAdditionalLevelCharAtCategoryName($step, $char) . $category['Category']['name']] = $this->_setCategoriesRecursively($category['children'], $step + 1, '--');
			} else {
				if ($category['Category']['type'] == '1')
					$categoriesToReturn[$category['Category']['id']] = $this->_generateAdditionalLevelCharAtCategoryName($step, $char) . $category['Category']['name'];
				else
					$categoriesToReturn[$this->_generateAdditionalLevelCharAtCategoryName($step, $char) . $category['Category']['name']] = array();
			}
		}

		return $categoriesToReturn;
	}

	function _setCategoriesList() {
		$categories = $this->Category->find('threaded', array('order' => 'lft asc', 'recursive' => -1, 'fields' => array('id', 'name', 'type', 'parent_id', 'lft', 'rght')));
		$categories = $this->_setCategoriesRecursively($categories);
		$this->set('categories', $this->_setCategoriesForThisCakeFormInputSelectFunction($categories));
	}

	function _setCategoriesForThisCakeFormInputSelectFunction($elements = array(), $dataToReturn = array()) {
		if (empty($elements))
			return false;

		foreach ($elements as $key => $element) {

			$key = $this->_setAdditionalSpacesToKeyToMakeThemUnique($key, $dataToReturn);

			if (is_array($element)) {
				$dataToReturn[$key] = array();
				if (!empty($element))
					$dataToReturn = $this->_setCategoriesForThisCakeFormInputSelectFunction($element, $dataToReturn);
			} else {
				$dataToReturn[$key] = $element;
			}
		}

		return $dataToReturn;
	}

	function _generateAdditionalLevelCharAtCategoryName($step, $char) {
		$name = null;

		for ($a = 0; $a < $step; $a++)
			$name .= $char;

		return $name;
	}

	function _setAdditionalSpacesToKeyToMakeThemUnique($key, $dataToReturn) {
		if (array_key_exists($key, $dataToReturn)) {
			$key .= " ";
			return($this->_setAdditionalSpacesToKeyToMakeThemUnique($key, $dataToReturn));
		}
		else
			return $key;
	}

	function beforeFilter() {
		parent::beforeFilter();
		$this->set('canEdit', $this->Auth->user('admin')||$this->Auth->user('teacher'));
		$this->set('newsStoreFolder', $this->News->storeFolder(1));

		//$this->Auth->allow('index', 'view', 'downloadFile', 'lastEntries');
		$this->News->user_id = $this->Auth->user('id');
		$pictureStoreFolder = $this->Picture->storeFolder(1);
		$this->set('pictureStoreFolder', $pictureStoreFolder);
		$this->set('filesStoreFolder', $this->Files->storeFolder(1));
		$this->set('filesExtension', implode('|', $this->Files->validate['file']['rule'][1]));
		$this->set('picturesExtension', implode('|', $this->Picture->validate['file']['rule'][1]));

		if (!$this->_isAuthorized()) {
			$this->Session->setFlash('Brak dostępu do lokalizacji', 'default', array('class' => 'alert'));
			$this->redirect($this->Auth->loginAction);
		}
	}

}