<?php 

class LearningContentAppModel extends AppModel {
	
	function beforeSave(){
		parent::beforeSave();	
		return true;
	}
	
	function extension($params,$args){
		if(empty($params['file']['tmp_name'])) return true;
		
		$ext = end(explode('.',$params['file']['name']));
		
		return in_array(low($ext), $args);
	}	
	
    function isUploadedFile($data, $required = false) {
            // Remove first level of Array ($data['Artwork']['size'] becomes $data['size'])
            $upload_info = array_shift($data);

            // No file uploaded.
            if ($required && $upload_info['size'] == 0) {
                    return false;
            }

            // Check for Basic PHP file errors.
            if ($upload_info['error'] !== 0) {
                    return false;
            }

            // Finally, use PHP’s own file validation method.
            return is_uploaded_file($upload_info['tmp_name']);
    }
	
	function _checkStructure(){
		
		if(!$this->storeFolder()) return;
		if(!file_exists($this->storeFolder())) {
			mkdir($this->storeFolder());
		} 
		
		return;
	}
	
	function _uploadFile($file,$target){
		if(is_uploaded_file($file['tmp_name'])) {

			$ext = end(explode('.',$file['name']));
			$name = substr(str_replace('.'.$ext,'',$file['name']),0,50);
			
			$nameToSave = 'file_'.rand(3021323,12312312).'_'.low(slug($name)).'.'.low($ext);
			
			
			while(file_exists($target.$nameToSave)) 
				$nameToSave = 'file_'.rand(3021323,1231231200000).'_'.low(slug($name)).'.'.$ext;
			
			
			if(move_uploaded_file($this->data[$this->name]['file']['tmp_name'],$target.$nameToSave)) {
				return $nameToSave;
			} else return false;

		}		
		return false;
	}
	
	function _generatePicture($field, $size = array(),$file='file'){
		
		if(empty($size)) return false;
		$pic2del= false;
			
		if(isset($this->data[$this->name][$file]) && is_uploaded_file($this->data[$this->name][$file]['tmp_name'])) {
			App::import('Vendor', 'thumbnail');
			
			$exploded = explode('.',$this->data[$this->name][$file]['name']);
			$ext = low(array_pop($exploded));
			$name = implode('.',$exploded);
			
			$thumb = new Thumbnail($this->data[$this->name][$file]['tmp_name'],$this->data[$this->name][$file]['name']); // ładowanie pliku
			$this->thumb = $thumb;
			//$thumb->size_width($size['width']);
			//$thumb->size_height($size['height']); 
			$thumb->size($size['width'],$size['height']);  
			// generating unique name
			if($this->storeFolder()) {
				do {
					$nameToSave = 'pic_'.rand(10000,888898989).'_'.low(slug($name)).'.'.$ext;
				} while (file_exists($this->storeFolder().$nameToSave));				
			} else die('Error in nameGenerator');

			$thumb->save($this->storeFolder().$nameToSave);

			// generating thumbnail
			if(!empty($size['thumb_width']) && !empty($size['thumb_height'])) {
				$thumb->size($size['thumb_width'],$size['thumb_height']);
				$thumb->save($this->storeFolder().'thumb_'.$nameToSave);
			
			} elseif (!empty($size['thumb_width'])) {
				$thumb->square($size['thumb_width']);
				$thumb->save($this->storeFolder().'thumb_'.$nameToSave);
				
			} elseif (!empty($size['thumb_height'])) {
				$thumb->square($size['thumb_height']);
				$thumb->save($this->storeFolder().'thumb_'.$nameToSave);
			} 

			// generating thumbnail2
			if(!empty($size['thumb2_width']) && !empty($size['thumb2_height'])) {
				$thumb->size($size['thumb2_width'],$size['thumb2_height']);
				$thumb->save($this->storeFolder().'thumb2_'.$nameToSave);
			
			} elseif (!empty($size['thumb2_width'])) {
				$thumb->square($size['thumb2_width']);
				$thumb->save($this->storeFolder().'thumb2_'.$nameToSave);
				
			} elseif (!empty($size['thumb2_height'])) {
				$thumb->square($size['thumb2_height']);
				$thumb->save($this->storeFolder().'thumb2_'.$nameToSave);
			} 
			
			$this->data[$this->name][$field] = $nameToSave;
			
			if($this->id) $url = $this->field($field,array('id'=>$this->id));
			if(!empty($url) && $this->data[$this->name][$field]) $this->pic2del = $url;	
		}

		if(!empty($this->data[$this->name][$field])) {
		 	$this->data[$this->name][$file] = 'validated';
		}
	}		
	
}
