<?php

class News extends LearningContentAppModel {

	var $useTable = 'learning_news';
	var $actsAs = array('Move', 'Containable');
	
	var $filterData = array(
		'basic'=> array(
			'title'=> array('type'=> 'like'),
			'body'=> array('type'=> 'like'),
			'created'=> array('type'=> 'date_between'),
			'published'=> array('type' => 'equal','options' => 'custom:yes-no','class' => 'short'),			
		)

	);
	
	var $size = array(
		'width' => 900,
		'height' => 600,
		'thumb_width' => 210,
		'thumb_height' => 140,
		'thumb2_width' => 340,
		'thumb2_height' => 255
	);

	function getNewsForClasses($class_id) {
		return $this->NewsClasses->find('list', array('fields' => array('news_id', 'news_id'), 'conditions' => array('class_id' => $class_id)));
	}

	function storeFolder($web = false) {
		if (!$web)
			return '..' . DS . 'webroot' . DS . 'upload' . DS . 'news' . DS;
		else {
			return '/upload/news/';
		}
	}

	var $belongsTo = array(
		'User' => array('className' => 'Account.User', 'foreignKey' => 'user_id', 'fields' => array('User.id', 'User.username', 'User.email')),
		'NewsCategory' => array('className' => 'LearningContent.NewsCategory', 'foreignKey' => 'category_id', 'counterCache' => 'news_count', 'counterScope' => array('News.published' => 1)),
	);
	var $hasAndBelongsToMany = array(
		'Classes' =>
		array(
			'className' => 'Learning.Classes',
			'joinTable' => 'learning_news_classes',
			'foreignKey' => 'news_id',
			'associationForeignKey' => 'class_id',
			'fields' => array('id')
			));
	var $hasMany = array(
		'Picture' => array(
			'className' => 'LearningContent.Picture',
			'foreignKey' => 'news_id',
			'dependent' => true,
		),
		'Comment' => array(
			'className' => 'LearningContent.Comment',
			'foreignKey' => 'news_id',
			'dependent' => true,
		),
		'Files' => array(
			'className' => 'LearningContent.Files',
			'foreignKey' => 'news_id',
			'dependent' => true,
		), 'NewsClasses' => array(
			'className' => 'LearningContent.NewsClasses',
			'foreignKey' => 'news_id'
		)
	);
	var $validate = array(
		'title' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste'),
		'product_category_id' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste'),
		//'body' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste'),
		//'header' => array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste'),
		'file' => array(
			'extension' => array('rule' => array('extension', array('gif', 'jpg', 'jpeg', 'png')), 'message' => 'Niepoprawne rozszerzenie', 'allowEmpty' => true),
		)
	);

	function notEmptyFile($check) {
		$data = array_shift($check);
		if (!empty($data['name'])) {
			return true;
		}
		return false;
	}

	function beforeValidate() {

		return true;
	}

	function savePicture($data, $news_id) {
		$this->data = $data;

		$this->stopBeforeSave = true;
		$this->_generatePicture('url', $this->size);
		$url = $this->data[$this->name]['url'];
		if (!empty($url)) {
			$this->id = $news_id;
			if ($this->saveField('url', $url)) {
				return $url;
			} else
				return false;
		}


		return false;
	}

	function beforeSave() {
		parent::beforeSave();
		if (!empty($this->stopBeforeSave))
			return true;
		$this->_generatePicture('url', $this->size);

		return true;
	}

	function afterFind($results) {
		return $results;
	}

	function beforeDelete() {
		if ($this->id)
			$this->file = $this->field('url', array('id' => $this->id));
		return true;
	}

	function afterDelete() {
		if (!empty($this->file)) {
			@unlink($this->storeFolder() . $this->file);
			@unlink($this->storeFolder() . 'thumb_' . $this->file);
			@unlink($this->storeFolder() . 'thumb2_' . $this->file);
		}
	}

	function deletePicture($id) {

		$url = $this->field('url', array('id' => $id));

		if (!$url)
			return false;

		@unlink($this->storeFolder() . $url);
		@unlink($this->storeFolder() . 'thumb_' . $url);
		@unlink($this->storeFolder() . 'thumb2_' . $url);

		$this->id = $id;
		return $this->saveField('url', null);
	}

}
