function generateId(value){
 	returnValue = value.replace(/\./g,'_')
	.replace('C:\\fakepath\\','')
	.replace('(ą|ć|ę|ł|ś|ó|ż|ź)','_')
	.replace(/(\?|\$|\!|\^|\[|\.|\{|\*|\(|\\|\+|\||\>|\<|\)|\})+/g,'_');
	return string_to_slug(returnValue);
}

function string_to_slug(str) {
  str = str.replace(/^\s+|\s+$/g, ''); // trim
  str = str.toLowerCase();
  
  // remove accents, swap ñ for n, etc
  var from = "àáäâąèęéëêìíïîòóöôùúüûñçćźłżśń·/_,:;";
  var to   = "aaaaaeeeeeiiiioooouuuuncczlzsn------";
  for (var i=0, l=from.length ; i<l ; i++) {
    str = str.replace(new RegExp(from.charAt(i), 'g'), to.charAt(i));
  }

  str = str.replace(/[^a-z0-9 -]/g, '') // remove invalid chars
    .replace(/\s+/g, '-') // collapse whitespace and replace by -
    .replace(/-+/g, '-'); // collapse dashes

  return str;
}

$(function(){ // wait for document to load 
$('#files').MultiFile({ 
	STRING: {
		remove: '[usuń]'
	},
	onFileRemove: function(element, value, master_element){ 
		$('#files'+generateId(value)).remove();

	}, 
	onFileAppend: function(element, value, master_element){ 
		$('#files_wrap_list').append('<p id = "files'+(generateId(value))+'">Tytuł: <input type = "text" class = "fileTitleInput" maxlength = "70" name = "data[Files][files][][title]" /></p>');
	}
	
	}); 

$('#picture').MultiFile({ 
	STRING: {
		remove: '[usuń]'
	},
	onFileRemove: function(element, value, master_element){ 
		$('#picture'+generateId(value)).remove();
	 
	}, 
	onFileAppend: function(element, value, master_element){ 
		$('#picture_wrap_list').append('<p id = "picture'+(generateId(value))+'">Tytuł: <input type = "text" class = "pictureTitleInput" name = "data[Picture][files][][title]"  /></p>');

	}
	
}); 
	
$("form").submit(function(event){
	alerted = false;
	$('.pictureTitleInput').each(function(index, item){
		if(!item.value) {
			if(!alerted) alert('Wypełnij wszystkie pola tytułów obrazów!');	
			alerted = true;
			event.preventDefault();
			$('.MultiFile-applied').removeAttr("disabled");
		}
	});
	$('.fileTitleInput').each(function(index, item){

		if(!item.value) {
			if(!alerted) alert('Wypełnij wszystkie pola tytułów plików!');	
			alerted = true;
			event.preventDefault();
			$('.MultiFile-applied').removeAttr("disabled");
		}
	});
});
	

});