<?php

class NewslettersController extends NewsletterAppController {

	var $components = array('Email', 'Auth');
	var $name = 'Newsletters';
	var $uses = array('Newsletter.Template', 'Newsletter.Newsletter', 'Learning.Classes', 'LearningAccount.Group', 'Learning.Team', 'Account.Profile');
	var $helpers = array('Javascript', 'TinyMce.TinyMce', 'Js');
	var $sendLimit = 100;

	function __dataForEdit() {
		$classes_ids = $this->getClassesId();
		$this->set('classes', $this->Classes->getList($classes_ids));
		$data = array();

		$groups = $this->Group->find('all', array('conditions' => array('Group.class_id' => $classes_ids)));
		$data['groups'] = Set::combine($groups, '{n}.Group.id', '{n}.Group.name', '{n}.Group.class_id');

		$teams = $this->Team->find('all', array('conditions' => array('Group.class_id' => $classes_ids), 'contain' => 'Group'));
		$data['teams'] = Set::combine($teams, '{n}.Team.id', '{n}.Team.name', '{n}.Team.group_id');

		$this->set('data', $data);
	}

	function admin_add($tid = null) {
		$buttons = array(
			'b0' => 'load',
			'b1' => 'send',
			'b2' => 'save',
			'b3' => 'test',
			'b4' => 'preview',
			'b5' => 'remove'
		);

		if (!empty($this->data)) {
			$this->Newsletter->create($this->data);
			$action = false;
			foreach ($buttons as $button => $value) {
				if (array_key_exists($button, $this->data['Newsletter'])) {
					$action = $value;
					break;
				}
			}

			// ładowanie szablonu
			if ($action == 'load') {
				if (!empty($this->data['Newsletter']['template_id'])) {
					$tId = $this->data['Newsletter']['template_id'];
					$template = $this->Template->read(null, $tId);
					$this->data['Newsletter'] = $template['Template'];
					$this->data['Newsletter']['template_id'] = $tId;
					$this->Session->setFlash('Wybrany szablon został załadowany');
				} else
					$this->Session->setFlash('Aby załadować szablon wybierz jego tytuł z listy', 'default', array('class' => 'alert'));
			} elseif ($action == 'remove') {
				if (!empty($this->data['Newsletter']['template_id'])) {
					$tId = $this->data['Newsletter']['template_id'];
					if ($this->Template->delete($tId)) {
						$this->Session->setFlash('Wybrany szablon został skasowany');
					}else
						$this->Session->setFlash('Wystąpił bład podczas kasowania szablonu', 'default', array('class' => 'alert'));
				}else
					$this->Session->setFlash('Wybierz z listy szablon do skasowania', 'default', array('class' => 'alert'));
			} elseif ($this->Newsletter->validates()) {

				switch ($action) {
					case 'send':
						if ($error = $this->_sendNewsletter($this->data['Newsletter']) === true) {
							$this->Session->setFlash('Wiadomości zostały wysłane', 'default', array());
						} elseif($error === false) {
							$this->Session->setFlash('Wystąpił bład podczas wysyłania wiadomości', 'default', array('class' => 'alert'));
						} else {
							$this->Session->setFlash('Wystąpił bład podczas wysyłania wiadomości do: ' . implode(', ', $error), 'default', array('class' => 'alert'));
						}
						break;
					case 'test':

						if ($this->_sendNewsletter($this->data['Newsletter'], 'test') === true) {
							$this->Session->setFlash('Wiadomości testowe zostały wysłane', 'default', array());
						} else {
							$this->Session->setFlash('Wystąpił bład podczas wysyłania wiadomości testowych', 'default', array('class' => 'alert'));
						}
						break;
					case 'save':

						if (!empty($this->data['Newsletter']['template_id']))
							$this->data['Newsletter']['id'] = $this->data['Newsletter']['template_id'];
						if ($this->_saveTemplate($this->data['Newsletter'])) {
							$this->Session->setFlash('Zapisano szablon', 'default', array());
						} else
							$this->Session->setFlash('Wystąpił bład podczas zapisywania szablonu', 'default', array('class' => 'alert'));
						break;

					case 'preview':
						$this->set('preview', $this->data);
						break;
					default:
						die('Error in form fields');
				}
			} else
				$this->Session->setFlash('Wystąpił bład w formularzu. Spróbuj ponownie', 'default', array('class' => 'alert'));
		} elseif($tid) {
			$template = $this->Template->read(null, $tid);
			$this->data['Newsletter'] = $template['Template'];
		}
		$this->__dataForEdit();
		$templates = $this->_shortTitle($this->Template->find('list', array('order' => 'title asc', 'conditions'=> array('user_id'=> $this->Auth->user('id')))), 25);
		$this->set('templates', $templates);
	}

	function teacher_add(){
		$this->admin_add();
		$this->render('admin_add');
	}

	function _shortTitle($data, $len) {
		foreach ($data as $key => $row)
			if (strlen($row) > $len)
				$data[$key] = '#' . $key . ': ' . substr($row, 0, $len) . '...';
			else
				$data[$key] = '#' . $key . ': ' . $row;
		return $data;
	}

	function _sendNewsletter($data, $mode=null) {

		$attachements = array();
		foreach ($data['files'] as $file) {
			if (!empty($file['name']) && is_uploaded_file($file['tmp_name'])) {
				if (copy($file['tmp_name'], TMP . DS . $file['name'])) {
					$attachements[] = TMP . DS . $file['name'];
				}
			}
		}

		if (!empty($mode) && $mode == 'test') {

			$emails = explode(';', $data['emails']);
			$bccs = array_chunk($emails, $this->sendLimit);

			foreach ($bccs as $bcc) {
				$error = $this->_sendEmail( Configure::read('Email.newsletter_to'), null, $data, $attachements, $bcc);
			}
			return $error;
		} else {
			//$emails = $this->Mail->find('all', array('fields' => array('id', 'address', 'remove_code')));

			$emails = $this->__getEmails($data);
			$bccs = array_chunk($emails, $this->sendLimit);
			foreach ($bccs as $bcc) {
				if (!$this->_sendEmail(Configure::read('Email.newsletter_to'), null, $data, $attachements, $bcc)) {
					
					return $bcc;
				}
			}
		}

		foreach ($attachements as $file) {
			unlink($file);
		}

		return true;
	}

	function __getEmails($data) {

		if ($data['team_id'] > 0) {
			$conditions = array('team_id' => $data['team_id']);
		} elseif ($data['group_id'] > 0) {
			$conditions = array('group_id' => $data['group_id']);
		} elseif ($data['class_id'] > 0) {
			$conditions = array('class_id' => $data['class_id']);
		} else {
			// do wszystkich klass przypisanych do danego uzytkownika
			$conditions = array('class_id' => $this->getClassesId());
		}

		return Set::combine($this->Profile->find('all', array(
				'contain' => array(
					'User' => array('fields' => array('email', 'id'))
				), 'conditions' => $conditions
			)), '{n}.User.id', '{n}.User.email');
	}

	function _sendEmail($address, $remove_code, $data, $attachements=array(), $bcc = array()) {

		return $this->Config->emailSend(array(
			'to' => $address,
			'bcc' => $bcc,
			'subject' => $data['title'],
			'template' => 'newsletters_add',
			'attachments' => $attachements,
			'data' => array(
				'data' => $data,
				'remove_code' => $remove_code
			)
		));
	}

	function _saveTemplate($data) {
		$toSave['Template'] = $data;
		$toSave['Template']['user_id'] = $this->Auth->user('id');
		return $this->Template->save($toSave);
	}

}
