<?php

class ConfigComponent extends Object {

	public $controller = null;

	function initialize(&$controller, $settings = array()) {
		$this->controller = &$controller;
	}

	function start() {
		$this->load();
		$this->mail();
		$this->auth();
		$this->debug();
	}

	function admin_menu() {
		return ClassRegistry::init('AdminPanel.AdminMenu')->find('all', array('order' => 'position'));
	}

	/**
	 * Funkcja pobiera dane klucza z parametrów.
	 * Jeśli $redirect == true przekierowuje
	 * @return string
	 */
	function getParam($key, $redirect = false) {
		$param = !empty($this->controller->params[$key]) ? $this->controller->params[$key] : false;
		if (!$param)
			$param = !empty($this->controller->params['named'][$key]) ? $this->controller->params['named'][$key] : false;
		if ($redirect && !$param)
			$this->alert('Niepoprawny adres! ' . base64_encode($key), $this->controller->referer());

		return $param;
	}

	function setTitleForLayout($string, $separator = ' - ') {
		if (!isset($this->titleForLayout))
			$this->titleForLayout = array();
		$this->titleForLayout[] = $string;
		return implode($separator, array_reverse($this->titleForLayout));
	}

	function message($string = null, $redirect = null, $class = 'message') {
		if ($string)
			$this->controller->Session->setFlash($string, 'default', array('class' => $class));
		if ($redirect) {
			if (is_array($redirect) || strpos($redirect, '/') !== false)
				$this->controller->redirect($redirect);
			elseif (is_string($redirect)) {
				$this->controller->redirect(array('action' => $redirect));
			} else {
				$this->controller->redirect('/');
			}
		}
	}

	function alert($string, $redirect = null) {
		if ($string)
			$this->message($string, $redirect, 'alert');
		if ($redirect)
			$this->controller->redirect($redirect);
	}

	/**
	 * Funkcja ustawia layout znajdujący się w pluginie
	 * @param String $plugin nazwa pluginu
	 * @param String $name nazwa layoutu
	 */
	function setLayout($plugin, $name) {
		$this->controller->layoutPath = '..' . DS . '..' . DS . 'plugins' . DS . $plugin . DS . 'views' . DS . 'layouts';
		$this->controller->layout = $name;
	}

	/**
	 * Funkcja ustawia które menu jest zaznaczone.
	 * @param <type> $selectedMenu
	 */
	function selectMenu($selectedMenu=null) {
		if (!$selectedMenu)
			$selectedMenu = low($this->controller->name);
		$this->controller->set(compact('selectedMenu'));
	}

	/**
	 * Wysyłanie maila
	 * @param <type> $options
	 * @return <type>
	 */
	function emailSend($options) {

		$this->controller->Email->reset();
		$this->controller->Email->from = Configure::read('Email.name') . ' <' . Configure::read('Email.from') . '>';
		$this->controller->Email->to = $options['to'];
		$this->controller->Email->subject = $options['subject'];
		$this->controller->Email->template = $options['template'];

		if (isset($options['bcc'])) {
			$this->controller->Email->bcc = array_values($options['bcc']);
		}
		if (isset($options['attachments'])) {
			$this->controller->Email->attachments = $options['attachments'];
		}

		$this->controller->set('data', $options['data']);
		$this->controller->set($options['data']);
		return $this->controller->Email->send();
	}

	/**
	 * Ustawienie wysyłki mailowej
	 */
	public function mail() {
		$this->controller->Email->sendAs = 'html';
		$this->controller->Email->delivery = 'smtp';
		//$this->controller->Email->from     = Configure::read('Email.name') .' <'.Configure::read('Email.from').'>';
		//$this->controller->Email->fromName = Configure::read('Email.name');

		if (Configure::read('Email.replyto'))
			$this->controller->Email->replyTo = Configure::read('Email.replyto');

		$this->controller->Email->smtpOptions =
			array(
				'port' => '25',
				'timeout' => '30',
				'host' => Configure::read('Smtp.host'),
				'username' => Configure::read('Smtp.user'),
				'password' => Configure::read('Smtp.pass')
		);
	}

	/**
	 * Ładowanie konfiguracji z bazy danych i zapisywanie w Cache
	 */
	public function load() {
		$_settings = array();
		if (($_settings = Cache::read('settings')) === false) {
			$this->controller->loadModel('Settings.Setting');
			$_settings = Set::combine($this->controller->Setting->find('all'), '{n}.Setting.name', '{n}.Setting.value');
			Cache::write('settings', $_settings);
		}
		foreach ($_settings as $key => $value) {
			Configure::write($key, $value);
		}
	}

	/**
	 * Ustawienie autoryzacji (komponent Auth)
	 */
	public function auth() {

		$this->controller->Auth->loginRedirect = '/';
		$this->controller->Auth->logoutRedirect = array('plugin' => 'account', 'controller' => 'users', 'action' => 'login');
		$this->controller->Auth->fields = array('username' => 'email', 'password' => 'password');
		$this->controller->Auth->loginAction = array('plugin' => 'account', 'controller' => 'users', 'action' => 'login', 'admin' => false);
		$this->controller->Auth->autoRedirect = false;
		$this->controller->Auth->loginError = 'Wystąpił błąd logowania!<br/>Nieprawidłowy email / PESEL lub hasło!';
		$this->controller->Auth->authError = 'Musisz się zalogować, aby mieć dostęp!';
		$this->controller->Auth->authorize = 'controller';
		$this->controller->Auth->userModel = 'Account.User';
		$this->controller->Auth->userScope = array('User.banned' => 0, 'User.active' => 1);

		$this->controller->set('auth', $this->controller->Auth->user());
	}

	/**
	 * Ustawienie dla panelu administracyjnego (layout i zabezpieczenie praw)
	 * oraz ustawienie hasła dla trybu debug (jeśli skrypt znajduje sie w folderze debug,
	 * to zabezpiecza dostęp hasłem htaccess)
	 */
	public function debug() {

		if (!empty($this->controller->params['admin'])) {
			$this->controller->Auth->loginAction = array('admin' => true, 'plugin' => 'account', 'controller' => 'users', 'action' => 'login');
			$this->controller->Auth->loginRedirect = '/admin';
			$this->controller->Auth->userScope['User.admin >='] = 1;

			if ($this->controller->Auth->user('id') && !$this->controller->Auth->user('admin')) {
				$this->alert('Brak uprawnień do tej strony', '/');
			}
			$this->setLayout('admin_panel', 'admin');
			$this->controller->set('admin_menu', $this->admin_menu());


			$this->controller->set('title_for_layout', 'Panel administracyjny');
		}

		$this->selectMenu();
		if ($this->controller->webroot == '/debug/') {
			$this->controller->loginOptions = array(
				'type' => 'basic',
				'realm' => 'Access restricted'
			);
			$this->controller->Security->loginUsers = array(
				'admin' => 'haslo123',
			);
			$this->controller->Security->requireLogin();
		}

		$this->controller->Security->validatePost = false;
	}

}