<?php
App::import('Vendor', 'Stats.gchart');

class Stat extends StatsAppModel {

	public $useTable = false;
	
	public $filterSettings = array(
		'basic'=> array(
			'range' => array('type'=> 'date_between', 'field'=> 'created', 'model'=> '#model#')
		)
	);

	public $chartDefaults = array(
		'width'=> 820, 
		'height'=> 300, 
		'legend'=> array('position'=> 'bottom'),
		'chartArea'	=> array('width'=> '85%', 'height'=> '60%'),
	);
	
	public $chartCustomOptions = array(
		'PieChart'=> array(
			'width'=> 385, 
			'height'=> 330, 
			'chartArea'	=> array('width'=> '85%', 'height'=> '85%'),
		)
	);

	
	public $__chartStructure = array(
//		'orders_sum'=> array(
//			'title'=> 'Wartość zamówień',
//			'model'=> 'Product.Order',
//			'inNumericTab'=> 'currency',
//			'fields'=> array(
//				'odate'=> array('type' => 'date','label' => 'data', 'dbName'=> 'DATE(created)'),
//				'osum'=> array('type' => 'number','label' => 'suma (zł)', 'dbName'=> 'SUM(#model#.value)'),				
//			),
//			'type'=> 'LineChart'
//		),	
//		'orders_count'=> array(
//			'title'=> 'Ilość zamówień',
//			'model'=> 'Courier.Order',
//			'inNumericTab'=> 'number',
//			'fields'=> array(
//				'udate'=> array('type' => 'date','label' => 'data', 'dbName'=> 'DATE(created)'),
//				'ucount'=> array('type' => 'number','label' => 'ilość zamówień', 'dbName'=> 'COUNT(*)'),
//				
//			),
//			'type'=> 'ColumnChart'
//		),	
		'grades_count'=> array(
			'title'=> 'Wystawiane oceny dziennie',
			'model'=> 'Learning.Grade',
			'inNumericTab'=> 'number',
			'fields'=> array(
				'udate'=> array('type' => 'date','label' => 'data', 'dbName'=> 'DATE(created)'),
				'ucount'=> array('type' => 'number','label' => 'ilość ocen', 'dbName'=> 'COUNT(*)'),
				
			),
			'type'=> 'AreaChart'
		),		
		'users_register'=> array(
			'title'=> 'Rejestracje użytkowników',
			'model'=> 'Account.User',
			'inNumericTab'=> 'number',
			'fields'=> array(
				'udate'=> array('type' => 'date','label' => 'data', 'dbName'=> 'DATE(created)'),
				'ucount'=> array('type' => 'number','label' => 'ilość rejestracji', 'dbName'=> 'COUNT(*)'),
				
			),
			'type'=> 'ColumnChart'
		),	
		'login_history'=> array(
			'title'=> 'Logowania dziennie',
			'model'=> 'Account.LoginHistory',
			'inNumericTab'=> 'number',
			'fields'=> array(
				'udate'=> array('type' => 'date','label' => 'data', 'dbName'=> 'DATE(created)'),
				'ucount'=> array('type' => 'number','label' => 'ilość logowań', 'dbName'=> 'COUNT(*)'),
				
			),
			'type'=> 'AreaChart'
		),			
		'grade_avg'=> array(
			'title'=> 'Średnia wystawianych ocen w miesiącach',
			'model'=> 'Learning.Grade',
			'order'=> 'MONTH(created) ASC',
			'fields'=> array(
				'udate'=> array('type' => 'string','label' => 'data', 'dbName'=> 'MONTHNAME(created)'),
				'avg_grade'=> array('type' => 'number','label' => 'średnia ocen', 'dbName'=> 'AVG(Grade.grade)'),
			),
			'type'=> 'LineChart'
		),	
				
		'grade_types'=> array(
			'title'=> 'Typy ocen',
			'model'=> 'Learning.Grade',
			'fields'=> array(
				'grade_type'=> array('type' => 'string','label' => 'typ oceny', 'dbName'=> 'Grade.grade'),
				'qty'=> array('type' => 'number','label' => 'ilość ocen', 'dbName'=> 'COUNT(*)'),
				
			),
			'type'=> 'PieChart'
		),	
		'grade_count_schools'=> array(
			'title'=> 'Ilość ocen dla szkół',
			'model'=> 'Learning.Grade',
			'customQuery'=> 'SELECT COUNT(*) as qty, School.name as school_name FROM learning_grades Grade, account_users Student, profiles Profile, learning_schools School WHERE School.id = Profile.school_id AND Profile.user_id = Student.id AND Grade.student_id = Student.id #conditions# GROUP BY School.name ORDER BY qty DESC',
			
			'fields'=> array(
				'school_name'=> array('type' => 'string','label' => 'szkoła', 'dbName'=> 'School.name'),
				'qty'=> array('type' => 'number','label' => 'ilość ocen', 'dbName'=> 'COUNT(*)'),
				
			),
			'type'=> 'PieChart'
		),			
		'schools_grade_avg'=> array(
			'title'=> 'Średnia ocen wg szkół',
			'model'=> 'Learning.Grade',
			'contain'=> array('Student'),
			'customQuery'=> 'SELECT AVG(Grade.grade) as grade_avg, School.name as school_name FROM learning_grades Grade, account_users Student, profiles Profile, learning_schools School WHERE School.id = Profile.school_id AND Profile.user_id = Student.id AND Grade.student_id = Student.id #conditions# GROUP BY School.name ORDER BY grade_avg DESC',
			'fields'=> array(
				
				'school_name'=> array('type' => 'string','label' => 'ilość ocen', 'dbName'=> 'School.name'),
				'grade_avg'=> array('type' => 'number','label' => 'typ oceny', 'dbName'=> 'AVG(Grade.grade)'),
				
			),
			'type'=> 'ColumnChart'
		),			
//		'orders_pays'=> array(
//			'title'=> 'Zamówienia wg sposobów płatności',
//			'model'=> 'Product.Order',
//			'contain'=> array('Pay'),
//			'fields'=> array(
//				'pay'=> array('type' => 'string','label' => 'płatność', 'dbName'=> 'Pay.name'),
//				'qty'=> array('type' => 'number','label' => 'ilość zamówień', 'dbName'=> 'COUNT(*)'),
//				
//			),
//			'type'=> 'PieChart'
//		),			
	); 
	
	
	public $statsConditions = array();
		
	/**
	 * Pobieranie danych do statystyk
	 * @return type 
	 */
	public function getData($rawConditions){
		// ilość rejestracji dziennie
		$this->__initialize();
		
		foreach ($this->__chartStructure as $alias => $chartDetails) {
			list($plugin, $model) = pluginSplit($chartDetails['model']);
			$firstField = $chartDetails['fields'][current(array_keys($chartDetails['fields']))]['dbName'];
			$conditions = $this->__parseConditions($rawConditions, $model, $firstField); // warunki zapytań
			
			if(empty($chartDetails['customQuery'])) {

				$fields = array();

				foreach ($chartDetails['fields'] as $fieldName => $fieldDetails) { // pola które chcemy pobierać
					$dbName = str_replace('#model#', $model, $fieldDetails['dbName']); // zamiana tagu model na model podany w parametrach
					$fields[] = sprintf('%s as %s', $dbName, $fieldName);
				}

				

				if(empty($chartDetails['order'])) {
					$order = array($firstField=> 'ASC'); // kolejność według pierwszego pola
				} else{
					$order = $chartDetails['order']; // według zdefiniowanej kolumny
				}

				$group = array($firstField);

				

				$contain = !empty($chartDetails['contain'])? $chartDetails['contain']: array();
				$data[$alias] = $this->{$model}->find('all',compact('order','fields','group','conditions','contain'));				
			} else {
				
				$query = $chartDetails['customQuery'];
				$conditionsString = null;
				if($rawConditions) {
					$conditionsString = 'AND '. implode(' AND ', Set::flatten($conditions) );
					
				}
				$query = str_replace('#conditions#', $conditionsString,$query);
				$data[$alias] = $this->{$model}->query($query);				
			}

			
			if(!empty($chartDetails['inNumericTab'])) {
				
				$rawValue = $this->{$model}->find('all',compact('order','fields','conditions','contain'));
				$value  = end($rawValue[0][0]);
				$data['numStats'][$alias] = array(
					'value'=> $value,
					'title'=> $chartDetails['title'],
					'type'=> $chartDetails['inNumericTab']
				);
			}
		}

		return $data;

	}
		
	private function __initialize(){
				
		foreach ($this->__chartStructure as $chart) {
			if(!empty($chart['model'])) {
				list($plugin,$model) = pluginSplit($chart['model']);
				if(!isset($this->{$model})) {
					$this->{$model} = ClassRegistry::init($chart['model']);
				}
			}
		}
		
	}
	
	public function getDetails(){
		$data = $this->__chartStructure;
		foreach ( $data as $alias => $detail) {
			if(!isset($detail['options'])) {
				$data[$alias]['options'] = array();
			}
		}
		return $data;
	}
		
	public function getCharts($data){
		
		$charts = array();
		foreach ($this->__chartStructure as $alias => $chartData) {
			if(isset($data[$alias])) {
				
				$charts[$alias] = new GoogleChart();
				
				$chartData += $this->chartDefaults;
				$chartCustomSettings= $this->chartDefaults;
				if(isset($this->chartCustomOptions[$chartData['type']])) {
					$chartCustomSettings =  $this->chartCustomOptions[$chartData['type']];
				}

				$charts[$alias]->type($chartData['type'])	
					//Options array holds all options for Chart API
					->options(array('title' => $chartData['title'])+ $chartCustomSettings )
					->columns($chartData['fields']);	

				foreach($data[$alias] as $value){

					$row = $this->__findRow(  $chartData['fields'], $value );									
					$charts[$alias]->addRow($row);
				}			
				
				$charts[$alias]->setDiv($alias);		
			}
		}

		return $charts;	
		
	}
	
	private function __findRow($keys, $haystack){
		$row = array();

		foreach ($keys as $key => $details ) {
			$row[$key]= $this->recursiveArraySearch($haystack, $key);
		}

		return $row;
	}
	
	/**
	 * Funkcja zwraca listę aliasów z danych do charsów 
	 */
	public function getAliases(){
	
		return $this->__chartStructure;
	}
	
	public function parseDateConditions($data){
		
		if(empty($data['Stat']['range'])) {
			return;
		}
		
		$range = $data['Stat']['range'];
		
		if(strpos($range, '::')!== false) {
			$dates = explode('::', $range);
			$conditions['from'] = $dates[0];
			$conditions['to'] = $dates[1];
		} else {
			$conditions['from'] = $range;
			$conditions['to'] = $range;
		}
		
		return $conditions;
	}
	
	private function __parseConditions($conditions, $model, $field){
		$conditions = $this->recursiveArrayReplace(array('#model#','.range'), array($model, $field), $conditions);
			
		return $conditions;
	}
	
	public function recursiveArrayReplace($find, $replace, $data) {

		if (is_array($data)) {
			foreach ($data as $key => $value) {
				if (is_array($value)) {
					$data[$key] = $this->recursiveArrayReplace($find, $replace, $data[$key]);
				} else {
					$data[$key] = str_replace($find, $replace, $value);
				}
			}
		} else {
			$data = str_replace($find, $replace, $data);
		}

		return $data;	
	}
	
	public function recursiveArraySearch(array $array, $key) {

		foreach ($array as $k => $v) {
			if(is_array($v)) {
				if($found = $this->recursiveArraySearch($v, $key)){
					return $found;
				} 
			} elseif($k == $key) {
				return $v;				
			} 
		}
		
	}	
}


