<?php

/**
 * CakePHP TinyMCE Plugin
 *
 * Copyright 2009 - 2010, Cake Development Corporation
 *                        1785 E. Sahara Avenue, Suite 490-423
 *                        Las Vegas, Nevada 89104
 *
 * Licensed under The LGPL License
 * Redistributions of files must retain the above copyright notice.
 *
 * @copyright 2009 - 2010, Cake Development Corporation (http://cakedc.com)
 * @link      http://github.com/CakeDC/TinyMCE
 * @package   plugins.tiny_mce
 * @license   LGPL License (http://www.opensource.org/licenses/lgpl-2.1.php)
 */

/**
 * Short description for class.
 *
 * @package  plugins.tiny_mce.views.helpers
 */
class TinymceHelper extends AppHelper {

     /**
      * Other helpers used by FormHelper
      *
      * @var array
      * @access public
      */
     public $helpers = array('Html');
     /**
      *
      *
      * @var array
      * @access public
      */
     public $configs = array(
	 'simple' => array(
	     'mode' => 'textareas',
	     'theme' => 'simple',
	     'editor_selector' => 'mceSimple'),
	 'newsletter' => array(
	     'editor_selector' => 'editor',
	     'mode' => 'textareas',
	     'theme' => 'advanced',
	     'theme_advanced_buttons1' => "save,newdocument,preview,|,bold,italic,underline,strikethrough,|,justifyleft,justifycenter,justifyright,justifyfull,|,cut,copy,paste,pasteword,|,bullist,numlist,|,link,unlink,anchor,image,cleanup,help,code,|,search,replace",
	     'theme_advanced_buttons2' => "outdent,indent,blockquote,|,undo,redo,|,forecolor,|,html,fontsizeselect,formatselect,|,tablecontrols",
	     'theme_advanced_buttons3' => "spellchecker,|,hr,removeformat,visualaid,|,sub,sup,|,charmap,media,advhr,|,print,|,ltr,rtl",
	     'paste_auto_cleanup_on_paste' => true,
	     'plugins' => "spellchecker,save,advhr,advimage,print,paste,spellchecker,table,save,media,advlink,insertdatetime,paste,directionality,fullscreen,preview,searchreplace",
	     'language' => 'pl',
	     'theme_advanced_toolbar_location' => 'top',
	     'theme_advanced_toolbar_align' => "left",
	     'theme_advanced_resizing' => true,
	     'theme_advanced_resize_horizontal' => false,
	     'spellchecker_languages' => "+Polski=pl,Angielski=en",
	     'relative_urls' => false,
	     'remove_script_host' => false,
	 ),
	 'advanced' => array(
	     'mode' => "specific_textareas",
	     'textarea_trigger' => 'mce_editable',
	     'strict_loading_mode' => 'tinymce.isWebKit',
	     'width' => '740px',
	     'browsers' => 'msie,gecko,opera,safari',
	     'accessibility_focus' => false,
	     'gecko_spellcheck' => true,
	     'remove_linebreaks' => true,
	     'apply_source_formatting' => false,
	     'convert_newlines_to_brs' => true,
	     'relative_urls' => false,
	     'absolute_urls' => true,
	     'convert_urls' => false,
	     'init_instance_callback' => "tinyMCEPostInit",
	     'theme' => "advanced",
	     'theme_advanced_toolbar_location' => "top",
	     'theme_advanced_toolbar_align' => "left",
	     'theme_advanced_path' => false,
	     'theme_advanced_statusbar_location' => "bottom",
	     'init_instance_callback' => "tinyMCEPostInit",
	     'language' => 'pl',
	     'paste_insert_word_content_callback' => 'convertWord',
	     'theme_advanced_resizing' => true,
	     'theme_advanced_resize_horizontal' => false,
	     'plugins' => "safari, table, inlinepopups, paste",
	     'theme_advanced_buttons1' => "formatselect, fontsizeselect, forecolor, bold, italic, underline, strikethrough, separator,table,separator, image, separator, bullist, numlist, separator,justifyleft,justifycenter,justifyright,justifyfull,separator, outdent, indent, separator, pasteword, link, unlink, separator, removeformat, code",
	     'theme_advanced_buttons2' => "",
	     'theme_advanced_buttons3' => "",
	     'content_css' => "css/content.css",
	     'editor_selector' => 'editor',
	     'height'=> '90',
		'width'=> '740px',
	     'theme_advanced_resizing_use_cookie'=> false,
	     //'valid_elements' => '#p[id|style|dir|class|align],+a[href|target|title|class],-strong/-b[class|style],-em/-i[class|style],-strike[class|style],-u[class|style],-ol[class|style],-ul[class|style],-li[class|style],br,img[id|dir|lang|longdesc|usemap|style|class|src|border|alt=|title|hspace|vspace|width|height|align],-sub[style|class],-sup[style|class],-blockquote[dir|style],-div[id|dir|class|align|style],-span[style|class|align],-pre[class|align|style],address[class|align|style],-h1[id|style|dir|class|align],-h2[id|style|dir|class|align],-h3[id|style|dir|class|align],-h4[id|style|dir|class|align],-h5[id|style|dir|class|align],-h6[id|style|dir|class|align],hr[class|style],-table[border=0|cellspacing|cellpadding|width|frame|rules|height|align|summary|bgcolor|background|bordercolor|class|border-top-color|border-right-color|border-bottom-color|border-left-color|border-top-style|border-right-style|border-bottom-style|border-left-style|border-top-width|border-right-width|border-bottom-width|border-left-width|background-color],-tr[rowspan|width|height|align|valign|bgcolor|background|bordercolor],tbody,thead,tfoot,#td[colspan|rowspan|width|height|align|valign|bgcolor|background|bordercolor|scope],#th[colspan|rowspan|width|height|align|valign|scope]'
	 )
     );
     /**
      *
      *
      * @var array
      * @access protected
      */
     protected $_defaults = array();

     /**
      * Adds a new editor to the script block in the head
      *
      * @see http://wiki.moxiecode.com/index.php/TinyMCE:Configuration for a list of keys
      * @param mixed If array camel cased TinyMce Init config keys, if string it checks if a config with that name exists
      * @return void
      * @access public
      */
     public function editor($options = array()) {
	  if (is_string($options)) {
	       if (isset($this->configs[$options])) {
		    $options = $this->configs[$options];
	       } else {
		    throw new OutOfBoundsException(sprintf(__('Invalid TinyMCE configuration preset %s', true), $options));
	       }
	  }
	  $options = array_merge($this->_defaults, $options);
	  $lines = '';

	  foreach ($options as $option => $value) {
	       if ($option != 'file_browser_callback') {
		    $lines .= Inflector::underscore($option) . ' : "' . $value . '",' . "\n";

	       } else {
		    $lines .= Inflector::underscore($option) . ' : ' . $value . ',' . "\n";
	       }
	  }
	  $this->Html->script('/tiny_mce/js/tiny_mce/tiny_mce.js', false);
	  $this->Html->script('/tiny_mce/js/tiny_mce/tiny_custom_functions.js', false);
	  $this->Html->css('/tiny_mce/css/style.css', false, array('inline' => false));

	  $this->Html->scriptBlock('tinyMCE.init({' . "\n" . $lines . '});' . "\n", array(
	      'inline' => false));
     }

     /**
      * beforeRender callback
      *
      * @return void
      * @access public
      */
     public function beforeRender() {

	  //$this->Html->script('/tiny_mce/js/tiny_mce/tiny_mce.js', false);
	  //$this->Html->script('/tiny_mce/js/tiny_mce/plugins/asciimath/js/ASCIIMathMLwFallback.js', false);
	  //$this->Html->scriptBlock('var AMTcgiloc = "http://www.imathas.com/cgi-bin/mimetex.cgi"', array('inline'=> false) );
     }

}