// uniform validation helper


var tiny_mce_editor;
var tiny_mce_editor_iframe;
var tiny_mce_editor_span_container;

adjustHeight = function () {
  if (!window.tinyMCE.activeEditor._doc_element || !window.tinyMCE.activeEditor._iframe_element) {
    return false;
  } // if

  var inner_body_height;
  var iframe_height = window.tinyMCE.activeEditor._iframe_element.height();
  if (jQuery.browser.msie) {
    // IE
    inner_body_height = window.tinyMCE.activeEditor._body_element.attr('scrollHeight');
  } else if (jQuery.browser.safari  && (verComp('530', jQuery.browser.version) == 1)) {
    // SAFARI AND CHROME (webkit < 530)
    var last_element = window.tinyMCE.activeEditor._body_element.find('> *:last');
    if (last_element.length > 0) {
      var last_element_position = last_element.position();
      inner_body_height = last_element_position.top + last_element.height() + parseInt(last_element.css('marginBottom')) + parseInt(last_element.css('paddingBottom')) + 20;
    } else {

      inner_body_height = 0;
    } // if
  } else {
    // OTHERS
    inner_body_height = window.tinyMCE.activeEditor._body_element.height();
  } // if

  var new_height = inner_body_height + 25;
  if ( inner_body_height > iframe_height ) {
    window.tinyMCE.activeEditor._iframe_element.css('height', new_height + 'px');
  } // if
  setTimeout("adjustHeight()",250);
};

function tinyMCEPostInit(ed) {

  tiny_mce_editor = jQuery(ed);
  tiny_mce_editor_iframe = jQuery('#' + tiny_mce_editor.attr('id') + '_ifr');

  // object on which we hook blur i focus events
  var hook_nod = ed.settings.content_editable ? ed.getBody() : (tinymce.isGecko ? ed.getDoc() : ed.getWin());

  var tiny_mce_editor_span_container = jQuery(ed.contentAreaContainer).parents('span.mceEditor');

  // find objects that are important for uniform validation
  var parent_form = jQuery(ed.contentAreaContainer);
  while(parent_form[0].nodeName != 'FORM') {
    parent_form = parent_form.parent();
  } // if
  var textarea = jQuery(ed.getElement());

  // variables needed for resizing
  ed._doc_element = ed.getDoc();
  ed._body_element = jQuery(ed.getDoc()).find('body:first');
  ed._iframe_element = jQuery(ed.contentAreaContainer).find('iframe:first');

  // hook events
  tinymce.dom.Event.add(hook_nod, 'focus', function(e) {
    if (!tiny_mce_editor_span_container.is('expanded')) {
      tiny_mce_editor_span_container.addClass('expanded');
    } // if
  });

  tinymce.dom.Event.add(hook_nod, 'keypress', function(event) {
    if ((event.keyCode == 37) && (event.metaKey == true)) {
      return false;
    } // if
  });

  //if ((textarea.attr('auto_expand') && (textarea.attr('auto_expand') != 'no'))) {
    ed._iframe_element.css('overflow-y', 'hidden');
    setTimeout("adjustHeight()",550);
  //} // if
} // tinyMCEPostInit

verComp = function (version1, version2) {
  version1 = parVerStr(version1);
  version2 = parVerStr(version2);

  if (version1.major < version2.major) {
    return -1;
  } else if (version1.major > version2.major) {
    return 1;
  } else {
    if (version1.minor < version2.minor) {
      return -1;
    } else if (version1.minor > version2.minor) {
      return 1;
    } else {
      if (version1.patch < version2.patch) {
        return -1;
      } if (version1.patch > version2.patch) {
        return 1;
      } else {
        return 0;
      }
    }
  }
}

parVerStr = function (str) {
    if (typeof(str) != 'string') { return false; }
    var x = str.split('.');
    var maj = parseInt(x[0]) || 0;
    var min = parseInt(x[1]) || 0;
    var pat = parseInt(x[2]) || 0;
    return {
        major: maj,
        minor: min,
        patch: pat
    }
};