<?php
##############################################
# Shiege Iseng Resize Class
# 11 March 2003
# shiegege_at_yahoo.com
# View Demo :
#   http://shiege.com/scripts/thumbnail/
/*############################################
Sample :
$thumb=new thumbnail("./shiegege.jpg");            // generate image_file, set filename to resize
$thumb->size_width(100);                // set width for thumbnail, or
$thumb->size_height(300);                // set height for thumbnail, or
$thumb->size_auto(200);                    // set the biggest width or height for thumbnail
$thumb->jpeg_quality(75);                // [OPTIONAL] set quality for jpeg only (0 - 100) (worst - best), default = 75
$thumb->show();                        // show your thumbnail
$thumb->save("./huhu.jpg");                // save your thumbnail to file
----------------------------------------------
Note :
- GD must Enabled
- Autodetect file extension (.jpg/jpeg, .png, .gif, .wbmp)
  but some server can't generate .gif / .wbmp file types
- If your GD not support 'ImageCreateTrueColor' function,
  change one line from 'ImageCreateTrueColor' to 'ImageCreate'
  (the position in 'show' and 'save' function)
*/############################################


class Thumbnail
{
    var $img;
	var $xPos = 0;
	var $yPos = 0;

	function square($size = 100, $location = 'center') {
		$width = $this->img["width"];
		$height = $this->img["height"];

		if($width > $height) // Horizontal Rectangle?
		{
			if($location == 'center')
			{
				$x_pos = ($width - $height) / 2;
				$x_pos = ceil($x_pos);
				$y_pos = 0;
			}
			else if($location == 'left')
			{
				$x_pos = 0;
				$y_pos = 0;
			}
			else if($location == 'right')
			{
				$x_pos = ($width - $height);
				$y_pos = 0;
			}

			 $this->img["width"] = $this->img["height"];
		}
		else if($height > $width) // Vertical Rectangle?
		{
				if($location == 'center')
				{
					$x_pos = 0;

					$y_pos = ($height - $width) / 2;
					$y_pos = ceil($y_pos);
				}
				else if($location == 'left')
				{
					$x_pos = 0;
					$y_pos = 0;
				}
				else if($location == 'right')
				{
				$x_pos = 0;
					$y_pos = ($height - $width);
				}
			$this->img["height"] = $this->img["width"] ;
		}


		   $this->img["width_thumb"] = $size;
		   $this->img["height_thumb"] = $size;
		   $this->xPos = $x_pos;
		   $this->yPos = $y_pos;

	}

    function thumbnail($imgfile,$name)
    {
        //detect image format
        $this->img["format"]=ereg_replace(".*\.(.*)$","\\1",$name);
        $this->img["format"]=strtoupper($this->img["format"]);
        if ($this->img["format"]=="JPG" || $this->img["format"]=="JPEG") {
            $this->img["format"]="JPEG";
            $this->img["src"] = ImageCreateFromJPEG ($imgfile);

        } elseif ($this->img["format"]=="PNG") {
            $this->img["format"]="PNG";
            $this->img["src"] = ImageCreateFromPNG ($imgfile);
			imagealphablending($this->img["src"], true);

        } elseif ($this->img["format"]=="GIF") {
            $this->img["format"]="GIF";
            $this->img["src"] = ImageCreateFromGIF ($imgfile);

        } elseif ($this->img["format"]=="WBMP" ) {
            $this->img["format"]="WBMP";
            $this->img["src"] = ImageCreateFromWBMP ($imgfile);

        }  else {
            echo "Not Supported File";
            exit();
        }
        @$this->img["width"] = imagesx($this->img["src"]);
        @$this->img["height"] = imagesy($this->img["src"]);
        //default quality jpeg
        $this->img["quality"]=90;
    }


    function size_height($size=100)
    {
        //height
		$this->img["height_thumb"]=$size;
        @$this->img["width_thumb"] = ($this->img["height_thumb"]/$this->img["height"])*$this->img["width"];
    }

    function size_width($size=100)
    {
        //width
        $this->img["width_thumb"]=$size;
        @$this->img["height_thumb"] = ($this->img["width_thumb"]/$this->img["width"])*$this->img["height"];
    }

    function size_auto($size=100)
    {
        //size
        if ($this->img["width"]>=$this->img["height"]) {
            $this->img["width_thumb"]=$size;
            @$this->img["height_thumb"] = ($this->img["width_thumb"]/$this->img["width"])*$this->img["height"];
        } else {
            $this->img["height_thumb"]=$size;
            @$this->img["width_thumb"] = ($this->img["height_thumb"]/$this->img["height"])*$this->img["width"];
         }
    }


	function size($img_width=100, $img_height=100) {


		$width = $this->img["width"];
		$height = $this->img["height"];
		$w = true;

		$img_ratio = $width/$height; // ratio obrazka

		if($img_height > 0 && $img_width > 0) {
			$scale_ratio = $img_width / $img_height;
			if($scale_ratio > $img_ratio) $w = false;
		} elseif($img_width == 0) $w = false;

		if(!$w) {
			$modheight = $img_height;
			$diff = $height / $modheight;
			$modwidth = $width / $diff;
		} else {
			$modwidth = $img_width;
			$diff = $width / $modwidth;
			$modheight = $height / $diff;
		}

		if(!($width > $img_width || $height > $img_height)) {
			$modwidth = $width;
			$modheight = $height;
		}

		$this->img["width_thumb"] = $modwidth;
		$this->img["height_thumb"] = $modheight;
	}

    function jpeg_quality($quality=75)
    {
        //jpeg quality
        $this->img["quality"]=$quality;
    }

    function show()
    {
        //show thumb
        @Header("Content-Type: image/".$this->img["format"]);

        /* change ImageCreateTrueColor to ImageCreate if your GD not supported ImageCreateTrueColor function*/
        $this->img["des"] = ImageCreateTrueColor($this->img["width_thumb"],$this->img["height_thumb"]);
            @imagecopyresampled ($this->img["des"], $this->img["src"], 0, 0, 0, 0, $this->img["width_thumb"], $this->img["height_thumb"], $this->img["width"], $this->img["height"]);

        if ($this->img["format"]=="JPG" || $this->img["format"]=="JPEG") {
            //JPEG
            imageJPEG($this->img["des"],"",$this->img["quality"]);
        } elseif ($this->img["format"]=="PNG") {
            //PNG
            imagePNG($this->img["des"]);
        } elseif ($this->img["format"]=="GIF") {
            //GIF
            imageGIF($this->img["des"]);
        } elseif ($this->img["format"]=="WBMP") {
            //WBMP
            imageWBMP($this->img["des"]);
        }
    }

    function save($save="")
    {
        //save thumb
        if (empty($save)) $save=strtolower("./thumb.".$this->img["format"]);
        /* change ImageCreateTrueColor to ImageCreate if your GD not supported ImageCreateTrueColor function*/

        $this->img["des"] = ImageCreateTrueColor($this->img["width_thumb"],$this->img["height_thumb"]);

		imagealphablending ($this->img["des"],false);
		imagealphablending ($this->img["src"],false);

		imagesavealpha($this->img["des"], true);
		imagesavealpha($this->img["src"], true);

        @imagecopyresampled ($this->img["des"], $this->img["src"], 0, 0, $this->xPos, $this->yPos, $this->img["width_thumb"], $this->img["height_thumb"], $this->img["width"], $this->img["height"]);


        if ($this->img["format"]=="JPG" || $this->img["format"]=="JPEG") {
            //JPEG
            if(imageJPEG($this->img["des"],"$save",$this->img["quality"]))
				return true;
        } elseif ($this->img["format"]=="PNG") {
            //PNG
			if(imagePNG($this->img["des"],"$save"))
				return true;
        } elseif ($this->img["format"]=="GIF") {
            //GIF
            if(imageGIF($this->img["des"],"$save"))
				return true;
        } elseif ($this->img["format"]=="WBMP") {
            //WBMP
            if(imageWBMP($this->img["des"],"$save"))
				return true;
        }
		return false;
    }

    function size_both($size_width = 100, $size_height = 100){
//    	$this->size($size_width,$size_height);

		$org_ratio = imagesx($this->img["src"])/imagesy($this->img["src"]);
		$new_ratio = $size_width/$size_height;
		if($org_ratio < $new_ratio)
			$this->size_height($size_height);
		else
			$this->size_width($size_width);
	}

}
