<?php 
	// Pamiętać ze Jquery w wersji 1.3.1 jest wymagane.
	echo $this->Html->css('/daterange_picker/jquery-ui-1.7.1.custom');
	echo $this->Html->css('/daterange_picker/ui.daterangepicker');
	echo $this->Html->script('/daterange_picker/jquery-ui-1.7.1.custom.min');
	echo $this->Html->script('/daterange_picker/daterangepicker.jQuery');	
	echo $this->Html->script('/daterange_picker/jquery.ui.datepicker-pl');	
	
?>

<script type="text/javascript">	
	var datepicker_was_init = false;
	
	$(function(){
		if($('.datepicker').length > 0) {
			$('.datepicker').mouseover(function(){ datepicker_init(this) });
		}

	});
	
	function datepicker_init(what){
		if(!datepicker_was_init) {
			$(what).attr('autocomplete','off');

			$(what).daterangepicker({
				presetRanges: [
					{text: 'Dzisiaj', dateStart: 'today', dateEnd: 'today' },
					{text: 'Ostatnie 7 dni', dateStart: 'today-7days', dateEnd: 'today' },
					{text: 'Od początku miesiąca', dateStart: function(){ return Date.parse('today').moveToFirstDayOfMonth();  }, dateEnd: 'today' },
					{text: 'Od początku roku', dateStart: function(){ var x= Date.parse('today'); x.setMonth(0); x.setDate(1); return x; }, dateEnd: 'today' },
					//extras:
					{text: 'Zeszły miesiąc', dateStart: function(){ return Date.parse('1 month ago').moveToFirstDayOfMonth();  }, dateEnd: function(){ return Date.parse('1 month ago').moveToLastDayOfMonth();  } }
				],
				arrows:false,
				dateFormat: 'yy-mm-dd',
				rangeSplitter: '::',
				datepickerOptions: {
					changeMonth: true,
					changeYear: true
				},
				presets: {
					'specificDate':'Wybierz dzień',
					'allDatesBefore':'Wszystkie dodane przed',
					'allDatesAfter':'Wszystkie dodane po',
					'dateRange':'Przedział dat'
				},
				rangeStartTitle: 'Data początkowa',
				rangeEndTitle: 'Data końcowa',
				doneButtonText: 'Wybierz',
				prevLinkText: 'Poprzedni',
				nextLinkText: 'Następny'	 	
			});	
			
			datepicker_was_init = true;

		}
		
	}

</script>