/**
 * Skrypt przyjmuje wartosci
 * @selector to nazwa inputa który będzie wypełniany przy zmianie rodzica
 * @data to dane w postaci {parent_id = {id: nazwa}}
 */
(function($) {
	$.fn.chained = function(selector, data, default_select) {
		var _t = $(this);

		$(this).change(function(){
			select_handle(selector, data, default_select);
		});

		function select_handle(selector, data, default_select) {
			var id = _t.val(); // wartość zaznaczonego selecta
			var values = data[id];  // dane dla selecta
			
			// usuwamy wszystkie opcje
			$(selector + ' option').remove();
			$(selector).append($("<option></option>").
				attr("value", "").
				text('---'));
			
			$(selector).val(" ").change();

			for (record_id in values) {
				$(selector).append($("<option></option>").
					attr("value",record_id).
					text(values[record_id]));

				if(default_select > 0) {
					$(selector).val(default_select);
				}
			}
		}

		select_handle(selector, data, default_select);

	}


})(jQuery);
