<?php
class AccountAppModel extends AppModel {

	var $actsAs = array('Containable');

	function beforeSave(){
		parent::beforeSave();
		//if(!empty($this->data)) $this->data = $this->clean($this->data, array('remove'=>true, 'escape'=>false));
		return true;
	}

	function html($string, $remove = false) {
		$string = strip_tags($string);
		return $string;
	}

	function clean($data, $options = array()) {

		if (empty($data)) {
			return $data;
		}

		if (is_string($options)) {
			$options = array('connection' => $options);
		} else if (!is_array($options)) {
			$options = array();
		}

		$options = array_merge(array(
			'connection' => 'default',
			'odd_spaces' => false,
			'encode' => true,
			'dollar' => true,
			'carriage' => true,
			'unicode' => true,
			'escape' => false,
			'backslash' => false,
			'remove'=> false
		), $options);

		if (is_array($data)) {
			foreach ($data as $key => $val) {
				$data[$key] = $this->clean($val, $options);
			}
			return $data;
		} else {
			if ($options['encode']) {
				$data = $this->html($data, true);
			}
			return $data;
		}
	}

	function autocomplete(){
		die();
		$this->Payment = new Payment();
		$this->User = new User();
		$this->PaymentsUser = new PaymentsUser();
		$this->Profile = new Profile();
	}

	function CheckNIP($params)
	{
		$str = array_shift($params);
		if(!empty($str)){
			if(substr_count($str, '-') > 3){
				return false;
			}
			$chr_to_replace = array('-', ' ');
			$str = str_replace($chr_to_replace, '', $str);
				
			if (strlen($str) != 10 || $str == '0000000000')
			{
				return false;
			}
				
			$arrSteps = array(6, 5, 7, 2, 3, 4, 5, 6, 7);
			$intSum=0;
			for ($i = 0; $i < 9; $i++)
			{
				$intSum += $arrSteps[$i] * $str[$i];
			}
			$int = $intSum % 11;
				
			$intControlNr=($int == 10)?0:$int;
			if ($intControlNr == $str[9])
			{
				return true;
			}
			return false;
		}
		return false;
	}

}
?>