<?php

class LoginHistoryController extends AccountAppController {

     var $name = 'LoginHistory';
     var $components = array('Email', 'Auth', 'Session', 'SavePaginate');

     function admin_index() {
	  $this->Config->selectMenu('login_history');
	  $conditions = array();
	  if (!empty($this->params['named']['user_id'])) {
	       $user = $this->LoginHistory->User->find('first', array('recursive' => -1, 'conditions' => array('User.id' => $this->params['named']['user_id'])));
	       $conditions = array('LoginHistory.user_id' => $this->params['named']['user_id']);
	       if (!empty($user))
		    $this->set('user', $user);
	  }

	  $this->__paginateIndex($conditions);
	  $this->paginate['contain'] = array('User' => array('name', 'id'));
	  $this->paginate['order'] = 'LoginHistory.created desc';
	  $login_history = $this->paginate('LoginHistory');
	  $this->set('registersCount', $this->LoginHistory->User->find('count', array('conditions' => array('admin' => 0))));
	  $this->set('loginCounter', $this->LoginHistory->find('count'));
	  $this->set('login_history', $login_history);
     }

     function __paginateIndex($conditions = array()) {
	  $default = array(
	      'limit' => 10,
	      'order' => array('LoginHistory.created' => 'desc'),
	      'conditions' => $conditions
	  );

	  //$this->SavePaginate->setPaginateOptions($default);
	  $this->paginate = $default;
	  if (!empty($this->data['Filter']))
	       $this->paginate['conditions'] = $default['conditions'];

	  if (!empty($this->data['Filter']['date_from'])) {
	       $this->paginate['conditions']['LoginHistory.created >='] = $this->data['Filter']['date_from'];
	  }
	  if (!empty($this->data['Filter']['date_to'])) {
	       $this->paginate['conditions']['LoginHistory.created <='] = $this->data['Filter']['date_to'];
	  }
	  if (!empty($this->data['Filter']['limit'])) {
	       $this->paginate['limit'] = $this->data['Filter']['limit'];
	  }
	  $users = $this->SavePaginate->paginate('LoginHistory');
     }

     function beforeFilter() {
	  parent::beforeFilter();
	  $this->set('title_for_layout', 'Historia logowań');
     }

}

