<?php

class ProfilesController extends AccountAppController {
     public $components = array('Filter');
     public $uses = array('Account.User', 'Account.Profile', 'Cntst.School');

     /*
      *  ***** ADMIN PANEL *****
      */

     public function admin_index(){
	   $this->Filter->filter( array(), 'Profile');

	   $this->paginate['Profile']['contain'] = array('User', 'School');
	   $profiles = $this->paginate('Profile');

	   $this->set('profiles', $profiles);
		
     }

     function admin_edit($id = null) {

	  if (!empty($this->data)) {
	       $this->User->create($this->data);
	       $this->User->id = $this->data['User']['id'];
	       if ($this->User->saveAll($this->data)) {
		    $this->message('Zmiany zostały zapisane');
		    $this->redirect(array('action' => 'index'));
	       } else {
		    $this->alert('Wystąpiły błędy w formularzu. Spróbuj ponownie');
	       }
	  } else {
	       $this->data = $this->User->find('first', array('contain' => array('Profile'), 'conditions' => array('Profile.id' => $id)));
	  }
	  $schools = $this->School->find('list', array('order' => 'name'));
	  $this->set(compact('schools'));

     }

     public function admin_delete($id){
	  if($this->User->delete($this->Profile->field('user_id', array('id'=> $id)))) {
		$this->message('Konto uczestnika zostało usunięte');
	  } else $this->alert('Nie można było skasować konta uczestnika!');

	  $this->redirect(array('action'=> 'index'));
     }

     /*
      * ***** USER PANEL *****
      */

     public function user_edit(){
	  if (!empty($this->data)) {
	       $this->Profile->create($this->data);
	       $this->Profile->id = $this->Profile->field('id', array('user_id'=> $this->Auth->user('id')));
	       if ($this->Profile->save($this->data)) {
		    $this->message('Zmiany w profilu zostały zapisane', '/');
		    
	       } else {
		    $this->alert('Wystąpiły błędy w formularzu. Spróbuj ponownie');
	       }
	  } else {
	       $this->data = $this->Profile->find('first', array( 'conditions' => array('Profile.user_id' => $this->Auth->user('id') )));
	  }
	  $schools = $this->School->find('list', array('order' => 'name'));
	  $this->set(compact('schools'));

	   $this->set('title_for_layout', 'Edycja danych');
     }
}