<?php

class LoginHistory extends AccountAppModel {

     var $name = 'LoginHistory';
     var $useTable = 'account_login_history';
     var $belongsTo = array(
	 'User' => array(
	     'className' => 'Account.User',
	     'foreignKey' => 'user_id',
	     'counterCache' => 'login_count'
	     ));

     function write($data, $user = null) {

	  $this->data[$this->name]['email'] = $data['User']['email'];

	  if (empty($user))
	       $this->data[$this->name]['success'] = 0;
	  else {
	       $this->data[$this->name]['user_id'] = $user['User']['id'];
	       if (isset($this->User)) {
		    $this->User->id = $user['User']['id'];
		    $this->User->saveField('last_login', date("Y-m-d h:i:s"));
	       }
	  }
	  return $this->save($this->data);
     }

     function beforeSave() {
	  parent::beforeSave();

	  $this->data[$this->name]['ip'] = $_SERVER["REMOTE_ADDR"];
	  $this->data[$this->name]['host'] = gethostbyaddr($_SERVER["REMOTE_ADDR"]);
	  $this->data[$this->name]['useragent'] = $_SERVER['HTTP_USER_AGENT'];

	  return true;
     }

}