<?php

class User extends AccountAppModel {

     var $name = 'User';
     var $useTable = 'users';
     //var $actsAs = array('Cacheable.Cacheable');
     
     var $hasOne = array(
	 'Profile' => array(
	     'className' => 'Account.Profile',
	     'foreignKey' => 'user_id',
	     'dependent' => true
	 )
     );
     
     var $validateUserChangePassword = array(
	 'password' => array(
	     'rule' => 'notEmpty',
	     'message' => 'Wprowadź hasło'
	 ),
	 'oldPassword' => array(
	     array(
		 'rule' => array('isPassword'),
		 'message' => 'Stare hasło nie jest poprawne'
	     ),
	     array(
		 'rule' => 'notEmpty',
		 'message' => 'Wprowadź hasło'
	     ),
	 ),
	 'newPassword' => array(
	     'isMatch' => array(
		 'rule' => array('isMatch', 'confirmPassword'),
		 'message' => 'Hasła się nie zgadzają'
	     ),
	     'between' => array(
		 'rule' => array('between', 6, 20),
		 'message' => 'Hasło musi mieć minimalną długość 6 znaków, a maksymalną 20'
	     ),
	     'notEmpty' => array(
		 'rule' => 'notEmpty',
		 'message' => 'Wprowadź hasło'
	     )
	 ),
	 'confirmPassword' => array(
	     'notEmpty' => array(
		 'rule' => 'notEmpty',
		 'message' => 'Wprowadź hasło'
	     )
	 )
     );
     public $validateAdminAdd = array(
	 'email' => array(
	     array('rule' => 'isUnique', 'message' => 'Ten adres e-mail jest zajęty', 'required' => true),
	     array('rule' => 'email', 'message' => 'Wprowadź poprawny adres email'),
	     array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste', 'required' => true),
	 ),
	 'password' => array(
	     array('rule' => array('minLength', 5), 'message' => 'Hasło musi się składać z conajmniej 5 znaków'),
	     array('rule' => 'retypeField', 'message' => 'Podane hasła się nie zgadzają'),
	     array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste', 'required' => true)
	 ),
	 'retype_password' => array(
	     array('rule' => array('minLength', 5), 'message' => 'Hasło musi się składać z conajmniej 5 znaków'),
	     array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste', 'required' => true)
	 ),
     );
     
     public $validateAdminEdit = array(
	 'email' => array(
	     array('rule' => 'isUnique', 'message' => 'Ta adres e-mail należy już do innego użytkownika', 'required' => true),
	     array('rule' => 'email', 'message' => 'Wprowadź poprawny adres email'),
	     array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste', 'required' => true),
	 ),
     );
     
     public function generate($length = 10) {
	  $characters = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
	  $return = '';

	  if ($length > 0) {
	       $totalChars = mb_strlen($characters) - 1;
	       for ($i = 0; $i <= $length; ++$i) {
		    $return .= $characters[rand(0, $totalChars)];
	       }
	  }

	  return $return;
     }

     public function login($user) {

	  if (!empty($user)) {
	       $data = array();
	       $data['currentLogin'] = date('Y-m-d H:i:s');
	       $data['lastLogin'] = $user['User']['currentLogin'];

	       $this->id = $user['User']['id'];
	       return $this->save($data, false, array_keys($data));
	  }

	  return true;
     }

     function retypeField($field = null) {
	  $field = end(array_keys($field));

	  if (strpos($field, 'retype') !== false) {
	       $field = str_replace('retype_', null, $field);
	       if ($this->data[$this->name][$field] === Security::hash(null, false, true) || $this->data[$this->name][$field] == null)
		    return true;
	       return $this->data[$this->name][$field] == $this->data[$this->name]['retype_' . $field];
	  }

	  return $this->data[$this->name][$field] === Security::hash($this->data[$this->name]['retype_' . $field], false, true);
     }

     function retypeField2($field = null) {
	  $field = end(array_keys($field));

	  if (strpos($field, 'retype') !== false) {
	       $field = str_replace('retype_', null, $field);

	       return $this->data[$this->name][$field] == $this->data[$this->name]['retype_' . $field];
	  }

	  return $this->data[$this->name][$field] === $this->data[$this->name]['retype_' . $field];
     }

     var $validateRegister =
	     array(
	 'accept' => array('rule' => 'checkAccept', 'message' => 'Aby zarejestrować nowe konto, wymagana jest akceptacja regulaminu.', 'required' => true),
	 'email' => array(
	     array('rule' => 'isUnique', 'message' => 'Ta adres e-mail należy już do innego użytkownika', 'required' => true),
	     array('rule' => 'email', 'message' => 'Wprowadź poprawny adres email'),
	     array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste', 'required' => true),
	 ),
	 'password' => array(
	     array('rule' => array('minLength', 5), 'message' => 'Hasło musi się składać z conajmniej 5 znaków'),
	     array('rule' => 'retypeField', 'message' => 'Podane hasła się nie zgadzają'),
	     array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste', 'required' => true)
	 ),
	 'retype_password' => array(
	     array('rule' => array('minLength', 5), 'message' => 'Hasło musi się składać z conajmniej 5 znaków'),
	     array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste', 'required' => true)
	 ),
     );
     var $validateEditPassword = array(
	 'password' => array(
	     array('rule' => 'checkActualPassword', 'message' => 'Niepoprawne hasło'),
	     array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste')
	 ),
	 'new_password' => array(
	     array('rule' => 'retype', 'message' => 'Powtórzone hasła się nie zgadzają'),
	     array(
		 'rule' => array('maxLength', '40'),
		 'message' => 'Hasło musi mieć nie mniej niż 6 i nie więcej niż 40 znaków',
		 'required' => true
	     ),
	     array(
		 'rule' => array('minLength', '6'),
		 'message' => 'Hasło musi mieć nie mniej niż 6 i nie więcej niż 40 znaków',
		 'required' => true
	     ),
	     array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste')
	 ),
	 'retype_new_password' => array(
	     array('rule' => 'retype', 'message' => 'Powtórzone hasła się nie zgadzają'),
	     array('rule' => 'notEmpty', 'message' => 'Pole nie może być puste')
	 )
     );

     /**
      * Checks to see if the old password matches their input.
      *
      * @access public
      * @param array $data
      * @return boolean
      */
     public function isPassword($data) {
	  $user = $this->find('first', array(
		      'conditions' => array('User.id' => $_SESSION['Auth']['User']['id']),
		      'fields' => array('User.password'),
		      'contain' => false
		  ));

	  $data = array_values($data);

	  $var1 = Security::hash($data[0], 'sha1', true);
	  $var2 = $user['User']['password'];

	  return ($var1 === $var2);
     }

     function checkActualPassword($params) {
	  $actualPassword = $this->field('password');

	  return Security::hash($params['password'], false, true) == $actualPassword;
     }

     function retype($params) {

	  return $this->data[$this->name]['new_password'] == $this->data[$this->name]['retype_new_password'];
     }

     var $validateAdminChangePassword = array(
	 'new_password' => array(
	     'maxLength' => array(
		 'rule' => array('maxLength', '40'),
		 'message' => 'Hasło musi mieć nie mniej niż 6 i nie więcej niż 40 znaków'
	     ),
	     'minLength' => array(
		 'rule' => array('minLength', '6'),
		 'message' => 'Hasło musi mieć nie mniej niż 6 i nie więcej niż 40 znaków'
	     ),
	     'notEmpty' => array(
		 'rule' => 'notEmpty',
		 'message' => 'Pole jest wymagane'
	     ),
	 ),
	 'old_password' => array(
	     'check_old_password' => array(
		 'rule' => array('check_old_password'),
		 'required' => true,
		 'message' => 'Niepoprawne hasło'
	     ),
	     'notempty' => array(
		 'rule' => 'notempty',
		 'required' => true,
		 'message' => 'Pole jest wymagane',
	     )
	 ),
	 'rep_password' => array(
	     'fieldsEqualTo' => array(
		 'rule' => array('isMatch', 'new_password', 'rep_password'),
		 'required' => true,
		 'message' => 'Błędnie powtórzono nowe hasło',
	     ),
	     'notempty' => array(
		 'rule' => 'notempty',
		 'required' => true,
		 'message' => 'Pole jest wymagane',
	     )
	 ),
     );
     var $validateEdit = array(
	 'name' => array('rule' => 'notempty', 'message' => 'Pole jest wymagane', 'required' => true),
     );

     function check_old_password($data) {
	  $valid = false;
	  $data['old_password'] = Security::hash(Configure::read('Security.salt') . $data['old_password']);
	  $password = $this->field('password', $this->name . '.id = "' . $this->id . '"');
	  if ($data['old_password'] == $password && !empty($data['old_password'])) {
	       $valid = true;
	  }
	  return $valid;
     }

     function beforeValidate() {

	  if (!empty($this->data[$this->name]['password']) && $this->data[$this->name]['password'] == Security::hash('', false, true))
	       $this->data[$this->name]['password'] = null;

	  return true;
     }

     function checkNewPass() {
	  return $this->data[$this->name]['new1'] == $this->data[$this->name]['new2'];
     }

     function checkActualPass() {

	  return Security::hash($this->data[$this->name]['password'], false, true) == $this->field('password', array('id' => $this->id));
     }

     function checkAccept() {
	  return ($this->data[$this->name]['accept'] != 0);
     }

     function checkReason($params) {
	  return (array_key_exists($params['reason'], $this->reason));
     }

     function beforeSave() {
	  parent::beforeSave();
	  if (empty($this->data[$this->name]['name']) && !empty($this->data['Profile']['fname']) && !empty($this->data['Profile']['lname'])) {
	       $this->data[$this->name]['name'] = $this->data['Profile']['fname'] . ' ' . $this->data['Profile']['lname'];
	  }
	  if (!empty($this->data[$this->name]['new_password']))
	       $this->data[$this->name]['password'] = Security::hash($this->data[$this->name]['new_password'], false, true);

	  return true;
     }

     function checkPass() {
	  //return $this->data[$this->name]['password'] == $this->data[$this->name]['password2'];
	  //debug(Security::hash($this->data[$this->name]['password2'], null, true));
	  return $this->data[$this->name]['password'] == Security::hash($this->data[$this->name]['password2'], null, true);
     }

     function checkCaptcha($params) {
	  return($params['captcha'] == $this->captcha);
     }

     function checkEmail() {
	  return $this->data[$this->name]['email'] == $this->data[$this->name]['emailz'];
     }

     public function savePassword($data) {
	  $this->id = $_SESSION['Auth']['User']['id'];
	  $newPassword = Security::hash($data['User']['newPassword'], null, true);
	  return $this->saveField('password', $newPassword);
     }

}
