<?php

class Contact extends ContactAppModel {
	var $name = 'Contact';

	var $useTable = false;

	var $_schema = array(
		'birth'=>array('type'=>'date'),
		'startDate'=>array('type'=>'date')
	);

	var $cities =  array(
			'warszawa'=>array(
				'name'=>'Warszawa',
				'title'=>'Skład fabryczny w Warszawie',
				'email'=>'warszawa(małpa)lupus.eu',
				'phone1'=>'022 478 31 72',
				'phone2'=>'022 478 34 74',
				'fax'=>'022 478 34 76',
				'street'=>'ul. Traktorzystów 1 ',
				'postal'=>'02-495 Warszawa - Ursus',
				'alias'=>1
	),
			'wroclaw'=>array(
				'name'=>'Wrocław',
				'title'=>'Skład fabryczny we Wrocławiu',
				'email'=>'wroclaw(małpa)lupus.eu',
				'phone1'=>'071 352 79 60',
				'phone2'=>'071 352 79 70',
				'fax'=>'071 352 99 29',
				'street'=>'ul.Paprotna 5',
				'postal'=>'51-117 Wrocław',
				'alias'=>3
	),
			'poznan'=>array(
				'name'=>'Poznań',
				'title'=>'Skład fabryczny w Poznaniu',
				'email'=>'poznan(małpa)lupus.eu',
				'phone1'=>'061 861 47 19',
	//'phone2'=>'022 478 34 74',
				'fax'=>'061 861 46 87',
				'street'=>'ul. Górecka 104',
				'postal'=>'61-483 Poznań',
				'alias'=>2
	),
			'krakow'=>array(
				'name'=>'Kraków',
				'title'=>'Skład fabryczny w Krakowie',
				'email'=>'krakow(małpa)lupus.eu',
				'phone1'=>'012 418 28 80',
	//'phone2'=>'022 478 34 74',
				'fax'=>'012 418 28 81',
				'street'=>'ul.Powstańców 50',
				'postal'=>'31-422 Kraków',
				'alias'=>4
	),
			'rzeszow'=>array(
				'name'=>'Rzeszów',
				'title'=>'Skład fabryczny w Rzeszowie',
				'email'=>'rzeszow(małpa)lupus.eu',
				'phone1'=>'017 863 76 40',
				'phone2'=>'017 863 76 41',
				'fax'=>'017 863 76 42',
				'street'=>'ul. Wspólna 2',
				'postal'=>'35-205 Rzeszów',
				'alias'=>5
	),
	);

	var $validate = array(
		'subject'		=>	array('rule'=>'notEmpty','message'=>'Pole nie może być puste'),
		'body'		=>	array('rule'=>'notEmpty','message'=>'Pole nie może być puste'),

		'email'		=>	array(
	array('rule'=>'email','message'=>'Wprowadź poprawny adres email'),
	array('rule'=>'notEmpty','message'=>'Pole nie może być puste'),
	),
	);

	function checkContact(){
		return !(empty($this->data[$this->name]['phone']) && empty($this->data[$this->name]['email']));
	}

	function email($params){
		if(empty($params['email'])) return true;
		else return Validation::email($params['email']);
	}
}