<?php

class GalleriesController extends ContentAppController {

     var $modelParams = array(
	 'name'=> 'Gallery',
	 'foreign'=> 'GalleryPicture',
	 'contain'=> array('GalleryPicture')
     );

     var $helpers = array('Text','TinyMce.TinyMce','Time');
     var $components = array('Seo.Seo');

     var $uses = array('Content.Gallery');

     function view(){
	  $id = $this->Config->getParam('id', 'Niepoprawny adres!');
	  $record = $this->{$this->modelParams['name']}->get($id, array(),$this->modelParams['contain']);
	  if(empty($record)) $this->alert('Nie znaleziono wpisu w bazie danych!', '/');
	  $this->set('record', $record);
	  $this->set('title_for_layout', $record[ $this->modelParams['name'] ]['name'] );

	  $this->Seo->set( $record[$this->modelParams['name']] );
     }

     function index(){
	  $this->paginate[$this->modelParams['name']]['order']['position'] = 'DESC';
	  $this->paginate[$this->modelParams['name']]['conditions']['published'] = 1;
	  $this->paginate[$this->modelParams['name']]['contain'] = array( $this->modelParams['foreign']=> array('limit'=>1, 'order'=> array('position'=> 'desc')) );

	  $records = $this->paginate( $this->modelParams['name'] );
	  $this->set('title_for_layout', 'Galerie' );

	  $this->Seo->set( array(
	      'seo_title'=> 'Galerie',
	      'seo_desc'=>  'Galerie opis (ustaw w kontrolerze)',
	      'seo_keywords'=> 'Galerie słowa kluczowe(ustaw w kontrolerze)'
	  ) );

	  $this->set('records', $records);
     }

     function admin_index() {
	  $this->paginate[$this->modelParams['name']]['order']['position'] = 'DESC';
	  $this->set('title_for_layout', 'Lista galerii');
	  $records = $this->paginate( $this->modelParams['name'] );
	  $this->set('records', $records);
     }

     function admin_edit($id = null){
	  if(!empty($this->data)) {
	       if($this->{ $this->modelParams['name'] }->saveAll($this->data)) {
		    $this->message('Rekord został zapisany!','index');
	       } else $this->alert('Rekord nie zostal zapisany!');
	  } elseif($id) {
	       $this->set('title_for_layout', 'Edycja rekordu');
	       $this->data = $this->{ $this->modelParams['name'] }->get($id);
	  } else {
	       $this->set('title_for_layout', 'Dodaj rekord');
	  }

	  if($id) {
	       $pictures = $this->{ $this->modelParams['name'] }
	       ->{ $this->modelParams['foreign'] }
	       ->find('all', array(
		   'conditions'=>array('foreign_id'=> $id),
		   'order'=> 'position DESC')
		 );
			 
	       $this->set(compact( 'pictures') );
	  }
     }

     function admin_delete($id = null){
	  if($this->{ $this->modelParams['name'] }->delete($id)) {
	       $this->message('Rekord został usunięty!');
	  } else $this->alert('Rekord nie został usunięty!');

	  $this->redirect($this->referer());
     }

     function admin_move($id=null, $direction = 0) {// 1 = up 0 = down
	  if ($id) {
	       $this->{ $this->modelParams['name'] }->id = $id;
	       if ($this->{ $this->modelParams['name'] }->move($id, $direction)) {
		    $this->message('Pozycja została zmieniona');
	       } else {
		    $this->alert($this->{ $this->modelParams['name'] }->getErrMsg());
	       }
	  }
	  $this->redirect($this->referer());
     }

     function admin_publish($id = null) {
	  $published = $this->{ $this->modelParams['name'] }->field('published', array('id' => $id));
	  $publish = $published ? 0 : 1;
	  $this->{ $this->modelParams['name'] }->id = $id;
	  if ($this->{ $this->modelParams['name'] }->saveField('published', $publish)) {
	       if ($publish) $this->message('Wpis został opublikowany');
	       else $this->alert('Wpis został ukryty');
	  } else{
	       $this->alert('Bład: nie można zmienić statusu wpisu');
	  }
	  $this->redirect($this->referer());
     }

     function beforeFilter(){
	  parent::beforeFilter();
	  $this->set('pictureFolder', $this->{ $this->modelParams['name'] }->{ $this->modelParams['foreign'] }->storeFolder() );
	  $this->set('modelParams', $this->modelParams);
	  $this->Auth->allow('index','view');
     }
}