<?php

class NewsController extends ContentAppController {

     var $name = 'News';
     var $disallow = array('edit', 'publish');
     var $news_id = null;
     var $uses = array('Content.News', 'Content.Files', 'Content.Picture', 'Content.NewsCategory');
     var $helpers = array('Javascript', 'Text', 'Time', 'Number', 'Ajax', 'TinyMce.TinyMce');
     var $components = array('Session', 'Seo.Seo');
     var $paginate = array('limit' => 10, 'contain'=> array('NewsCategory'));

     function view() {

	  $id = $this->Config->getParam('news_id', true);
	  
	  $category_alias = $this->Config->getParam('category_id');

	  if($category_alias) {
	       $category = $this->NewsCategory->find('first', array('conditions' => array('alias' => $category_alias)));
	       $this->set('category', $category);
	       $this->Config->setTitleForLayout( $category['NewsCategory']['title'] );
	  }

	  $conditions = !$this->Auth->user('admin') ? array('published' => 1) : array();
	  $new = $this->News->find('first', array('conditions' => array('News.id' => $id) + $conditions));

	  if (empty($new)) {
	       $this->alert('Brak wpisu w bazie danych', '/');
	  }

	  $files = $this->Files->find('all', array('conditions' => array('Files.news_id' => $new['News']['id']), 'order' => array('position' => 'desc')));
	  $pictures = $this->Picture->find('all', array('conditions' => array('Picture.news_id' => $new['News']['id']), 'order' => array('position' => 'desc')));

	  $this->set(compact('new', 'files', 'pictures'));
	  $this->set('newsImgFolder', $this->News->storeFolder(true));

	  $this->Seo->set($new['News']);

	  $this->set('title_for_layout', $this->Config->setTitleForLayout( $new['News']['title'] ));
     }

    function downloadFile() {
	$this->view = 'media';
	$file_id = $this->Config->getParam('file_id', true);

	$file = $this->Files->get($file_id);

	if (empty($file))
	    $this->alert('Brak pliku' , '/');


	$this->Files->id = $file_id;
	$this->Files->saveField('downloads_count', $file['Files']['downloads_count'] + 1);
	$extension = end(explode('.', $file['Files']['url']) );
	$params = array(
	    'id' => $file['Files']['url'],
	    'name' => slug( $file['Files']['title'] ),
	    'download'=> true,
	    'extension' => $extension,
	    'path' => $this->Files->storeFolder(),
	    'mimeType' => array($extension => $file['Files']['type'])
	);

	$this->set($params);

    }

     function admin_saveFile($news_id = null) {
	  $this->layout = 'ajax';
	  $url = null;
	  Configure::write('debug', 0);
	  $old_url = $this->News->field('url', array('id' => $news_id));

	  if (!empty($this->data['News']['file']['tmp_name'])) {
	       $url = $this->News->savePicture($this->data, $news_id);
	       if ($url) {
		    $saved = true;
	       } else {
		    $url = $old_url;
		    $saved = false;
	       }
	  }
	  $this->set('url', $url);
	  $this->set('news_id', $news_id);
	  $this->set('saved', $saved);
     }

     function _isAuthorized() {
	  if ($this->Auth->user('admin'))
	       return true;

	  if (in_array($this->action, $this->disallow)) {
	       $user_id = $this->Auth->user('id');

	       if (!empty($this->params['pass'][0]) || $this->news_id) {
		    $news_id = $this->news_id ? $this->news_id : $this->params['pass'][0];
		    $news_user_id = $this->News->field('user_id', array('id' => $news_id));
		    if ($user_id != $news_user_id)
			 return false;
		    else
			 return true;
	       } else
		    return false;
	  } else
	       return true;
     }

     function isAuthorized() {
	  return true;
     }

     function lastEntries($limit = 1) {
	  $category_id = $this->NewsCategory->field('id', array('alias' => 'aktualnosci'));

	  $data['data'] = $this->News->find('all', array(
		      //'recursive' => -1,
		      'fields' => array('News.id', 'News.created', 'News.header', 'News.title', 'News.url', 'News.alias', 'NewsCategory.alias'),
		      'contain' => array('NewsCategory'),
		      'order' => 'News.position desc',
		      'limit' => $limit,
		      'conditions' => array('published' => 1, 'category_id' => $category_id)
		  ));

	  $data['storeFolder'] = $this->News->storeFolder(1);

	  return $data;
     }

     function admin_editPicture($id = null) {
	  if ($id) {
	       $category = $this->NewsCategory->field('alias', array('id' => $this->News->field('category_id', array('id' => $this->Picture->field('news_id', array('id' => $id))))));

	       if (!empty($this->data)) {

		    if ($this->Picture->save($this->data)) {
			 $this->Session->setFlash('Obraz został zapisany');
			 $this->redirect(array('action' => 'edit', $this->Picture->field('news_id'), 'category_alias' => $category));
		    } else {
			 $this->Session->setFlash('Błąd: obraz nie został zapisany.', 'default', array('class' => 'alert'));
		    }
	       }
	       $this->data = $this->Picture->read(null, $id);
	       $this->set('category', $category);
	  }
     }

     function admin_move($id=null, $direction = 0) {// 1 = up 0 = down
	  if ($id) {
	       $this->News->id = $id;
	       if ($this->News->move($id, $direction, 'category_id')) {
		    $this->Session->setFlash('Pozycja została zmieniona');
	       } else {
		    $this->Session->setFlash($this->News->getErrMsg(), 'default', array('class' => 'alert'));
	       }
	  }

	  $this->redirect($this->referer());
     }

     function admin_product_move($id=null, $direction = 0) {// 1 = up 0 = down
	  if ($id) {
	       $this->News->id = $id;
	       if ($this->News->move($id, $direction, 'product_category_id')) {
		    $this->Session->setFlash('Pozycja została zmieniona');
	       }else
		    $this->Session->setFlash($this->News->getErrMsg(), 'default', array('class' => 'alert'));
	  }

	  $this->redirect($this->referer());
     }

     function admin_picture_move($id=null, $direction = 0) {// 1 = up 0 = down
	  if ($id) {

	       $this->Picture->id = $id;
	       if ($this->Picture->move($id, $direction)) {
		    $this->Session->setFlash('Obraz został przeniesiony');
	       }else
		    $this->Session->setFlash('Brak kolejnego elementu', 'default', array('class' => 'alert'));
	  }

	  $this->redirect($this->referer() . '#edycja-obrazow');
     }

     function admin_file_move($id=null, $direction = 0) {// 1 = up 0 = down
	  if ($id) {

	       $this->Files->id = $id;
	       if ($this->Files->move($id, $direction)) {
		    $this->Session->setFlash('Plik został przeniesiony', 'default', array(), 'file_edit');
	       }else
		    $this->Session->setFlash('Brak kolejnego elementu', 'default', array('class' => 'alert'), 'file_edit');
	  }

	  $this->redirect($this->referer() . "#edycja-plikow");
     }

     function admin_index() {
	  $alias = $this->Config->getParam('category_alias');
	  $this->set('alias', $alias);

	  if ($alias) {
	       $category = $this->NewsCategory->find('first', array('conditions' => array('alias' => $alias)));
	       $this->set('category', $category);
	       $this->Config->selectMenu($category['NewsCategory']['alias']);
	       $this->paginate['conditions']['NewsCategory.alias'] = $alias;
	       $this->set('categoryTitle', $this->NewsCategory->field('title', array('alias' => $alias)));
	  }

	  if (isset($this->params['named']['published'])) {
	       $this->paginate['conditions']['published'] = $this->params['named']['published'];
	  }
	  if (isset($this->params['named']['promoted'])) {
	       $this->paginate['conditions']['promoted'] = $this->params['named']['promoted'];
	  }
	  if (!empty($this->params['named']['user'])) {
	       $user = $this->News->User->find('first', array('recursive' => -1, 'conditions' => array('alias' => $this->params['named']['user']), 'fields' => array('alias', 'id', 'username')));
	       if (!empty($user)) {
		    $this->paginate['conditions']['user_id'] = $user['User']['id'];
		    $this->set('selUser', $user['User']['username']);
	       }
	  }

	  $categories = $this->NewsCategory->find('all', array('order' => array('position' => 'desc'), 'recursive' => -1));
	  $this->set('categories', $categories);

	  $defaultOrder = array('News.position' => 'desc');

	  $this->paginate['order'] = $defaultOrder;
	  if (!empty($this->controller->params['named']['sort']) && !empty($this->controller->params['named']['direction'])) {
	       $this->controller->paginate['order'][$this->controller->params['named']['sort']] = $this->controller->params['named']['direction'];
	  }

	  if (!empty($this->params['named']['sort']) && !empty($this->params['named']['direction'])) {
	       $this->paginate['order'][$this->params['named']['sort']] = $this->params['named']['direction'];
	  }

	  $news = $this->paginate('News');
	  $this->set('news', $news);
     }

     function admin_edit($id = false) {

	  $alias = $this->Config->getParam('category_alias');
	  $this->set('alias', $alias);

	  if ($alias) {
	       $category = $this->NewsCategory->find('first', array('conditions' => array('alias' => $alias)));
	       $this->set('category', $category);
	  }

	  if (!empty($this->data)) {
	       if ($this->News->save($this->data)) {
		    $filesSaved = !empty($this->data['Files']) ? $this->Files->saveFiles($this->data['Files'], $id) : true;
		    $imagesSaved = !empty($this->data['Picture']) ? $this->Picture->saveImages($this->data['Picture'], $id) : true;
		    $this->message(sprintf('Rekord <em><a href = "%s">%s</a></em> został zapisany',
			    Router::url(array('admin'=> false, 'action'=>'view', 'news_id'=> $this->News->id, 'slug'=> slug($this->data['News']['title']) ) ),
			    $this->data['News']['title']
		    ),array( 'action'=> 'index') );
	       } else {
		    $this->alert('Rekord nie został zapisany. Spróbuj ponownie.');
	       }
	  } elseif ($id) {
	       $this->data = $this->News->get($id);
	       $files = $this->Files->find('all', array('conditions' => array('news_id' => $id), 'order' => array('position' => 'desc')));
	       $pictures = $this->Picture->find('all', array('conditions' => array('news_id' => $id), 'order' => array('position' => 'desc')));
	       $this->set(compact('files', 'pictures'));
	  }

	  $news_categories = $this->NewsCategory->find('list');
	  $this->set(compact('news_categories', 'id'));
     }

     function admin_deleteFile($id=null) {
	  if ($id) {
	       if ($this->Files->delete($id)) {
		    $this->Session->setFlash('Plik został skasowany', 'default', array(), 'file_edit');
	       } else
		    $this->Session->setFlash('Plik nie został skasowany', 'default', array('class' => 'alert'), 'file_edit');
	  }

	  $this->redirect($this->referer() . '#edycja-plikow');
     }

     function admin_deleteNewsPicture($id) {

	  if ($id) {
	       $this->News->id = $id;

	       if ($this->News->deletePicture($id)) {

		    $this->Session->setFlash('Obraz został skasowany', 'default', array());
	       } else {
		    $this->Session->setFlash('Obraz nie został skasowany', 'default', array('class' => 'alert'));
	       }
	  }

	  $this->redirect($this->referer());
     }

     function admin_deletePicture($id=null) {
	  if ($id) {
	       if ($this->Picture->delete($id)) {
		    $this->Session->setFlash('Obraz został skasowany', 'default', array());
	       } else
		    $this->Session->setFlash('Obraz nie został skasowany', 'default', array('class' => 'alert'));
	  }

	  $this->redirect($this->referer() . '#edycja-obrazow');
     }

     function admin_deleteNewsPictureAjax($id) {
	  $this->layout = 'ajax';
	  Configure::write('debug', 0);
	  $url = false;
	  if ($id) {
	       $this->News->id = $id;
	       $url = $this->News->field('url');
	       if ($this->News->deletePicture($id)) {
		    $deleted = true;
	       } else {
		    $deleted = false;
	       }
	  }
	  $this->set('deleted', $deleted);
	  $this->set('url', $url);
     }

     function admin_delete($id = null) {

	  //$categoryAlias = $this->NewsCategory->field('alias',array('id'=>$this->News->field('category_id',array('id'=>$id))));

	  if ($id) {
	       if ($this->News->delete($id)) {
		    $this->Session->setFlash('Pozycja została skasowana', 'default', array());
	       } else
		    $this->Session->setFlash('Pozycja nie została skasowana', 'default', array('class' => 'alert'));
	  }

	  $this->redirect($this->referer());
     }

     function getBreadCrumbs($alias=null) {

	  $category_id = $this->ContentsCategory->field('id', array('alias' => $alias));
	  $parents = $this->ContentsCategory->getpath($category_id);
	  $breadCrumbs = $this->_generateBreadCrumbs($parents);

	  return $breadCrumbs;
     }

     function _generateBreadCrumbs($treePath=null) {

	  return;

	  $breadCrumbs = array();
	  if (!$treePath)
	       return array();
	  foreach ($treePath as $key => $path) {
	       if (isset($treePath[$key + 1])) {
		    if ($path['ContentsCategory']['dynamic'] == 0) {
			 $linkPath = array('plugin' => null, 'controller' => 'pages', 'action' => 'display', $path['ContentsCategory']['alias']);
		    } else {
			 $linkPath = array('plugin' => null, 'controller' => 'pages', 'action' => 'display', 'home');
		    }
		    $breadCrumbs[$path['ContentsCategory']['title']] = $linkPath;
	       }
	       else
		    $breadCrumbs[] = $path['ContentsCategory']['title'];
	  }

	  return $breadCrumbs;
     }

     function _emailAdminPublish($id = null) {
	  $news = $this->News->find('first', array('contain' => array('User' => array('username', 'alias', 'id', 'email')), 'fields' => array()));

	  $this->Email->to = $news['User']['email'];
	  $this->Email->subject = 'Twoja zguba została opublikowana';
	  $this->Email->replyTo = $this->emailReplyTo;
	  $this->Email->from = $this->emailName;
	  $this->Email->template = 'content_publish';
	  $this->Email->sendAs = 'html';
	  $this->set('data', $news);
	  return($this->Email->send());
     }

     function admin_publish($id = null) {
	  $published = $this->News->field('published', array('id' => $id));

	  $publish = $published ? 0 : 1;

	  $this->News->id = $id;

	  if ($this->News->saveField('published', $publish)) {

	       if ($publish) {
		    $this->Session->setFlash('Wpis został opublikowany', 'default', array());
	       }
	       else
		    $this->Session->setFlash('Wpis został ukryty', 'default', array());
	  } else
	       $this->Session->setFlash('Bład: nie można zmienić statusu wpisu', 'default', array('class' => 'alert'));

	  $this->redirect($this->referer());
     }

     function admin_users($q=null) {
	  Configure::write('debug', 0);

	  $this->layout = 'ajax';
	  if ($q) {
	       $users = $this->News->User->find('all', array('order' => array('alias' => 'asc'), 'conditions' => array('alias LIKE "' . $q . '%"'), 'fields' => array('username', 'alias', 'admin', 'id'), 'recursive' => -1));
	       $this->set('users', $users);
	  }
     }

     function index() {
	  $alias = $this->Config->getParam('category_alias');
	  $this->set('title_for_layout', 'Aktualności');
	  
	  if($alias) {
	       $category = $this->NewsCategory->find('first', array('conditions' => array('alias' => $alias)));
	       $this->set('category', $category);
	       $this->set('title_for_layout', $category['NewsCategory']['title']);
	       $this->paginate['conditions']['NewsCategory.alias'] = $alias;
	       $seo = array(
		   'title' => $category['NewsCategory']['seo_title'],
		   'desc' => $category['NewsCategory']['seo_desc'],
		   'keywords' => $category['NewsCategory']['seo_keywords']
	       );

	       $this->set('seo', $seo);
	  }

	  $this->paginate['conditions']['News.published'] = 1;
	  $this->paginate['limit'] = 5;
	  $this->paginate['order']['News.position'] = 'desc';

	  $news = $this->paginate('News');

	  $this->set('news', $news);
	  $this->set('newsImgFolder', $this->News->storeFolder(true));
	  $this->set('alias', $alias);
     }

     function userIndex() {

	  $this->paginate['conditions']['News.user_id'] = $this->Auth->user('id');

	  $this->paginate['order']['News.position'] = 'desc';

	  $news = $this->paginate('News');

	  $this->set('news', $news);
     }

     function _setCategoriesRecursively($categories, $step=0, $char='--') {
	  foreach ($categories as $category) {
	       if (!empty($category['children'])) {
		    $categoriesToReturn[$this->_generateAdditionalLevelCharAtCategoryName($step, $char) . $category['Category']['name']] = $this->_setCategoriesRecursively($category['children'], $step + 1, '--');
	       } else {
		    if ($category['Category']['type'] == '1')
			 $categoriesToReturn[$category['Category']['id']] = $this->_generateAdditionalLevelCharAtCategoryName($step, $char) . $category['Category']['name'];
		    else
			 $categoriesToReturn[$this->_generateAdditionalLevelCharAtCategoryName($step, $char) . $category['Category']['name']] = array();
	       }
	  }

	  return $categoriesToReturn;
     }

     function _setCategoriesList() {
	  $categories = $this->Category->find('threaded', array('order' => 'lft asc', 'recursive' => -1, 'fields' => array('id', 'name', 'type', 'parent_id', 'lft', 'rght')));
	  $categories = $this->_setCategoriesRecursively($categories);
	  $this->set('categories', $this->_setCategoriesForThisCakeFormInputSelectFunction($categories));
     }

     function _setCategoriesForThisCakeFormInputSelectFunction($elements = array(), $dataToReturn = array()) {
	  if (empty($elements))
	       return false;

	  foreach ($elements as $key => $element) {

	       $key = $this->_setAdditionalSpacesToKeyToMakeThemUnique($key, $dataToReturn);

	       if (is_array($element)) {
		    $dataToReturn[$key] = array();
		    if (!empty($element))
			 $dataToReturn = $this->_setCategoriesForThisCakeFormInputSelectFunction($element, $dataToReturn);
	       } else {
		    $dataToReturn[$key] = $element;
	       }
	  }

	  return $dataToReturn;
     }

     function _generateAdditionalLevelCharAtCategoryName($step, $char) {
	  $name = null;

	  for ($a = 0; $a < $step; $a++)
	       $name .= $char;

	  return $name;
     }

     function _setAdditionalSpacesToKeyToMakeThemUnique($key, $dataToReturn) {
	  if (array_key_exists($key, $dataToReturn)) {
	       $key .= " ";
	       return($this->_setAdditionalSpacesToKeyToMakeThemUnique($key, $dataToReturn));
	  }
	  else
	       return $key;
     }

     function beforeFilter() {
	  parent::beforeFilter();

	  $this->set('newsStoreFolder', $this->News->storeFolder(1));

	  $this->Auth->allow('index', 'view', 'downloadFile', 'lastEntries');
	  $this->News->user_id = $this->Auth->user('id');
	  $pictureStoreFolder = $this->Picture->storeFolder(1);
	  $this->set('pictureStoreFolder', $pictureStoreFolder);
	  $this->set('filesStoreFolder', $this->Files->storeFolder(1));
	  $this->set('filesExtension', implode('|', $this->Files->validate['file']['rule'][1]));
	  $this->set('picturesExtension', implode('|', $this->Picture->validate['file']['rule'][1]));

	  if (!$this->_isAuthorized()) {
	       $this->Session->setFlash('Brak dostępu do lokalizacji', 'default', array('class' => 'alert'));
	       $this->redirect($this->Auth->loginAction);
	  }
     }

}