<?php

class Picture extends ContentAppModel {
	var $name = 'Picture';
	var $useTable = 'news_pictures';
	
	var $actsAs = array('Move'=>array('group'=>'news_id'));
	
	var $validate = array(
		'title'=>array('rule'=>'notEmpty','message'=>'Pole nie może być puste'),
		'file'=>array('rule'=>array('extension',array('gif','jpg','jpeg','png')),'message'=>'Niepoprawne rozszerzenie')
	);	
	
	var $belongsTo = array('News'=>array('foreignKey'=>'news_id','fields'=>array('alias','title','category_id')));
	
	var $size = array(
		'width'=>900,
		'height'=>600,
		'smallWidth'=>210,
		'smallHeight'=>140,
	);	
	
	function storeFolder($web=false){
		if(!$web) return '..'.DS.'webroot'.DS.'upload'.DS.'news_pictures'.DS;
		else return '/upload/news_pictures/';
	}

	function beforeSave(){
		parent::beforeSave();
		if(!empty($this->data[$this->name]['file']) && is_uploaded_file($this->data[$this->name]['file']['tmp_name'])) {
			
			$this->_generatePicture('url',array('width'=>$this->size['width'], 'height'=>$this->size['height'], 'thumb_width'=>$this->size['smallWidth'],'thumb_height'=>$this->size['smallHeight']));

			$this->data[$this->name]['type'] = $this->data[$this->name]['file']['type'];
			$this->data[$this->name]['size'] = $this->data[$this->name]['file']['size'];
		}

		
		return true;
	}
	
	function beforeDelete(){
		if($this->id) $this->file = $this->field('url',array('id'=>$this->id));
		return true;
	}
	
	function afterDelete(){

		if(!empty($this->file)) {
			@unlink($this->storeFolder().$this->file);
			@unlink($this->storeFolder().'thumb_'.$this->file);
		}
	}
	
	function afterSave(){
		if(!empty($this->pic2del)) {
			unlink($this->storeFolder().$this->pic2del);
		}
	}	
	
	function saveImages($data,$id,$model = 'News'){
		$saved = true;
		foreach ($data['files'] as $file) {

			if(!empty($file['tmp_name'])) {
				$dataToSave['Picture']['model'] = $model;
				$dataToSave['Picture']['news_id'] = $id;
				if(!empty($file['title'])) $dataToSave['Picture']['title'] = $file['title'];
				$dataToSave['Picture']['file'] = $file;
				$this->create();
				if(!$this->save($dataToSave) && $saved) 
					$saved = false;
				
			}
		}
		
		return $saved;		
	}	
	
}
