<?php

/**
 * Zarządzanie obrazkami z jednego miejsca
 */
class AttachementsController extends MultifileAppController {

	var $uses = array();


	function teacher_edit($id = null, $model = null, $controller = null, $plugin = null) {

		$this->loadModel($plugin . '.' . $model);
		$foreign_id = $this->{$model}->field('foreign_id', array('id' => $id));
		if (!empty($this->data)) {
			if ($this->{$model}->save($this->data)) {
				$this->message('Załącznik został zapisany', array('plugin' => $plugin, 'controller' => $controller, 'action' => 'edit', $foreign_id));
			} else {
				$this->alert('Załącznik nie został zapisany!');
			}
		}
		$this->data = $this->{$model}->get($id);
		$this->set('file', $this->{$model}->field('file', array('id' => $id)));
		$this->set('storeFolder', $this->{$model}->storeFolder());
		$this->set(compact('id', 'model', 'controller', 'foreign_id', 'plugin'));
	}

	function teacher_move($id=null, $direction = 0, $model = null, $plugin = null) {// 1 = up 0 = down
		$this->loadModel($plugin . '.' . $model);
		$this->{$model}->id = $id;
		if ($this->{$model}->move($id, $direction)) {
			$this->message('Załącznik został przeniesiony');
		} else {
			$this->message('Brak kolejnego elementu');
		}
		$this->redirect($this->referer() . '#edycja-obrazow');
	}

	function teacher_delete($id=null, $model = null, $plugin = null) {
		$this->loadModel($plugin . '.' . $model);

		if ($this->{$model}->delete($id)) {
			$this->message('Załącznik został skasowany');
		} else {
			$this->alert('Załącznik nie został skasowany');
		}


		$this->redirect($this->referer() . '#edycja-plikow');
	}



	function admin_edit($id = null, $model = null, $controller = null, $plugin = null) {

		$this->loadModel($plugin . '.' . $model);
		$foreign_id = $this->{$model}->field('foreign_id', array('id' => $id));
		if (!empty($this->data)) {
			if ($this->{$model}->save($this->data)) {
				$this->message('Załącznik został zapisany', array('plugin' => $plugin, 'controller' => $controller, 'action' => 'edit', $foreign_id));
			} else {
				$this->alert('Załącznik nie został zapisany!');
			}
		}
		$this->data = $this->{$model}->get($id);
		$this->set('file', $this->{$model}->field('file', array('id' => $id)));
		$this->set('storeFolder', $this->{$model}->storeFolder());
		$this->set(compact('id', 'model', 'controller', 'foreign_id', 'plugin'));
	}

	function admin_move($id=null, $direction = 0, $model = null, $plugin = null) {// 1 = up 0 = down
		$this->loadModel($plugin . '.' . $model);
		$this->{$model}->id = $id;
		if ($this->{$model}->move($id, $direction)) {
			$this->message('Załącznik został przeniesiony');
		} else {
			$this->message('Brak kolejnego elementu');
		}
		$this->redirect($this->referer() . '#edycja-obrazow');
	}

	function admin_delete($id=null, $model = null, $plugin = null) {
		$this->loadModel($plugin . '.' . $model);

		if ($this->{$model}->delete($id)) {
			$this->message('Załącznik został skasowany');
		} else {
			$this->alert('Załącznik nie został skasowany');
		}


		$this->redirect($this->referer() . '#edycja-plikow');
	}

}