<?php

class SettingsController extends SettingsAppController {

     public $scaffold = 'admin';
     public $categories = array(
	 'Site' => array('desc' => 'Ustawienia strony', 'name' => 'Strona'),
	 'Smtp' => array('desc' => 'Ustawienia serwera wysyłki mailowej', 'name' => 'SMTP'),
	 'Email' => array('desc' => 'Ustawienia wiadomości email wysyłanych przez serwis', 'name' => 'Email'),
	 'SEO' => array('desc' => 'Ustawienia SEO', 'name' => 'SEO')
     );

     public function isAuthorized() {
	  return true;
     }

     public function beforeFilter() {
	  parent::beforeFilter();
     }

     public function admin_list($prefix = false) {
	  if ($prefix) $this->set('title_for_layout', sprintf(__('Ustawienia - %s', true), $this->categories[$prefix]['name']));
	  else $this->set('title_for_layout', 'Ustawienia');

	  $this->set('categories', $this->categories);
	  $this->set('prefix', $prefix);

	  if (!empty($this->data) && $this->Setting->saveAll($this->data['Setting'])) {
	       Cache::delete('settings');
	       $this->message("Zapisano ustawienia!");
	  }
	  if($prefix) {
	       $settings = $this->Setting->find('all', array(
			   'order' => 'Setting.weight ASC',
			   'conditions' => array(
			       'Setting.name LIKE' => $prefix . '.%',
			       'Setting.editable' => 1,
			   ),
		       ));

	       $this->set(compact('settings'));

	       if (count($settings) == 0) {
		    $this->alert("Nieprawidłowe ustawienie", '/admin');
	       }
	  }

     }

}