"use strict";

function dice_initialize(container, w, h) {
    $t.remove($t.id('loading_text'));

    var canvas = $t.id('canvas');
    canvas.style.width = w + 'px';
    canvas.style.height = h-5 + 'px';
    var label = $t.id('label');
    var set = $t.id('set');
    var selector_div = $t.id('selector_div');
    var info_div = $t.id('info_div');
    on_set_change();

    function on_set_change(ev) { set.style.width = set.value.length + 3 + 'ex'; }
    $t.bind(set, 'keyup', on_set_change);
    $t.bind(set, 'mousedown', function(ev) { ev.stopPropagation(); });
    $t.bind(set, 'mouseup', function(ev) { ev.stopPropagation(); });
    $t.bind(set, 'focus', function(ev) { $t.set(container, { class: '' }); });
    $t.bind(set, 'blur', function(ev) { $t.set(container, { class: 'svg' }); });

    $t.bind($t.id('clear'), ['mouseup', 'touchend', 'touchcancel'], function(ev) {
        ev.stopPropagation();
        set.value = '0';
        on_set_change();
    });

    var box = new $t.dice.dice_box(canvas);

    function show_selector() {
        info_div.style.display = 'none';
        //selector_div.style.display = 'inline-block';
        box.draw_selector();
    }

    function before_roll(vectors) {
        info_div.style.display = 'none';
        selector_div.style.display = 'none';
    }

    function notation_getter() {
        return $t.dice.parse_notation(set.value);
    }

    function after_roll(notation, result) {
        var res = result.join(' ');
        if (notation.constant) res += ' +' + notation.constant;
        if (result.length > 1) res += ' = ' +
            (result.reduce(function(s, a) { return s + a; }) + notation.constant);
        label.innerHTML = res;
        res = parseInt(res);
        //info_div.style.display = 'inline-block';

        $('#throw_dwa').css('display','none');

        if(window.slides_not_seen.length > 0){
            if(window.slides_not_seen.indexOf(res) > -1){
                window.slides_not_seen.splice(window.slides_not_seen.indexOf(res),1);

                setTimeout(function () {
                    $('#canvas').css('display','none');
                    $('#canvas canvas').css('display','none');
                    $('#wrapper').addClass('active');

                    goToSlide(res);

                }, 900);

            } else {
                $('#throw_dwa').css('display','block');

                setTimeout(function(){
                    var vector = { x: (Math.random() * 2 - 1) * box.w, y: -(Math.random() * 2 - 1) * box.h };
                    var dist = Math.sqrt(vector.x * vector.x + vector.y * vector.y);
                    var notation = notation_getter.call(box);
                    if (notation.set.length == 0) return;

                    vector.x /= dist; vector.y /= dist;
                    var boost = (Math.random() + 3) * dist;
                    var vectors = box.generate_vectors(notation, vector, boost);
                    box.rolling = true;
                    if (before_roll) before_roll.call(box, vectors, notation);
                    if (after_roll) {
                        box.clear();
                        box.roll(vectors, function(result) {
                            if (after_roll) after_roll.call(box, notation, result);
                            box.rolling = false;
                        });
                    }
                },400)

            }
        } else {
            setTimeout(function () {
                $('#canvas').css('display','none');
                $('#canvas canvas').css('display','none');
                $('#wrapper').addClass('active');

                goToSlide(res);

            }, 900);
        }

    }

    box.bind_mouse(container, notation_getter, before_roll, after_roll);
    box.bind_throw($t.id('throw_dwa'), notation_getter, before_roll, after_roll);

    $t.bind(container, ['mouseup', 'touchend', 'touchcancel'], function(ev) {
        if (selector_div.style.display == 'none') {
            if (!box.rolling) show_selector();
            box.rolling = false;
            return;
        }
        var name = box.search_dice_by_mouse(ev);
        if (name != undefined) {
            var notation = $t.dice.parse_notation(set.value);
            notation.set.push(name);
            set.value = $t.dice.stringify_notation(notation);
            on_set_change();
        }
    });

    var params = $t.get_url_params();
    if (params.notation) {
        set.value = params.notation;
    }
    if (params.roll) {
        $t.raise_event($t.id('throw_dwa'), 'mouseup');

    }
    else {
        show_selector();
    }
}
