"use strict";

function dice_initialize(container, w, h) {
    $t.remove($t.id('loading_text'));

    var canvas = $t.id('canvas');
    canvas.style.width = w + 'px';
    canvas.style.height = h-5 + 'px';
    var label = $t.id('label');
    var set = $t.id('set');
    var selector_div = $t.id('selector_div');
    var info_div = $t.id('info_div');
    on_set_change();

    function on_set_change(ev) { set.style.width = set.value.length + 3 + 'ex'; }
    $t.bind(set, 'keyup', on_set_change);
    $t.bind(set, 'mousedown', function(ev) { ev.stopPropagation(); });
    $t.bind(set, 'mouseup', function(ev) { ev.stopPropagation(); });
    $t.bind(set, 'focus', function(ev) { $t.set(container, { class: '' }); });
    $t.bind(set, 'blur', function(ev) { $t.set(container, { class: 'svg' }); });

    $t.bind($t.id('clear'), ['mouseup', 'touchend', 'touchcancel'], function(ev) {
        ev.stopPropagation();
        set.value = '0';
        on_set_change();
    });

    var box = new $t.dice.dice_box(canvas);

    function show_selector() {
        info_div.style.display = 'none';
        //selector_div.style.display = 'inline-block';
        box.draw_selector();
    }

    function before_roll(vectors) {
        info_div.style.display = 'none';
        selector_div.style.display = 'none';
    }

    function notation_getter() {
        return $t.dice.parse_notation(set.value);
    }

    function after_roll(notation, result) {
        var res = result.join(' ');
        if (notation.constant) res += ' +' + notation.constant;
        if (result.length > 1) res += ' = ' +
            (result.reduce(function(s, a) { return s + a; }) + notation.constant);
        label.innerHTML = res;

        //info_div.style.display = 'inline-block';

        $('#throw_dwa').css('display','none');

        setTimeout(function () {
            $('#canvas').css('display','none');
            $('#canvas canvas').css('display','none');
            $('#wrapper').addClass('active');

            var ile_jeszcze = res
            var krok=0
            var teraz_most;
            var poprzedni_most;
            window.timeout_params=[];
            while(ile_jeszcze > 0){
                poprzedni_most = teraz_most;
                teraz_most = window.list_of_bridges[krok%list_of_bridges.length];
                window.teraz_most = teraz_most;

                ile_jeszcze--
                krok++
                window.timeout_params.push({'krok':krok,'teraz_most':teraz_most,'poprzedni_most':poprzedni_most})
                setTimeout(function(){
                    var parametry = window.timeout_params[0]
                    window.timeout_params.splice(0,1);
                    $('#slajd_plansza_n'+parametry.poprzedni_most).removeClass('active');
                    $('#slajd_plansza_n'+parametry.teraz_most).addClass('active');
                }, krok*600);

            }

            var index_do_usunieca = window.list_of_bridges.indexOf(teraz_most);
            if(index_do_usunieca>-1){
                window.list_of_bridges.splice(index_do_usunieca,1);
            }

            if(window.list_of_bridges.length == 0){
                setTimeout(function(){
                    if(window.teraz_most == undefined){
                        goToSlide(res);
                    }else{
                        goToSlide(window.teraz_most);
                    }

                }, 2*600);
            }else{
                setTimeout(function(){
                    goToSlide(window.teraz_most);

                }, (krok+1)*600);
            }


        }, 900);

    }

    box.bind_mouse(container, notation_getter, before_roll, after_roll);
    box.bind_throw($t.id('throw_dwa'), notation_getter, before_roll, after_roll);

    $t.bind(container, ['mouseup', 'touchend', 'touchcancel'], function(ev) {
        if (selector_div.style.display == 'none') {
            if (!box.rolling) show_selector();
            box.rolling = false;
            return;
        }
        var name = box.search_dice_by_mouse(ev);
        if (name != undefined) {
            var notation = $t.dice.parse_notation(set.value);
            notation.set.push(name);
            set.value = $t.dice.stringify_notation(notation);
            on_set_change();
        }
    });

    var params = $t.get_url_params();
    if (params.notation) {
        set.value = params.notation;
    }
    if (params.roll) {
        $t.raise_event($t.id('throw_dwa'), 'mouseup');

    }
    else {
        show_selector();
    }
}
