/**
 * Created by owidiusz on 15.10.14.
 */

function randomIntFromInterval(min,max)
{
    return Math.floor(Math.random()*(max-min+1)+min);
}

function getWrapperDimensions(wrapper) {
    var width = wrapper.width() * 1.;
    var height = wrapper.height() * 1.;

    if (width / height > 4. / 3) {
        width = height * 4. / 3;
    }

    if (width / height < 4. / 3) {
        height = width * 3. / 4;
    }
    return {width: width, height: height};
}

function resizeWrapperAndCanvas() {
    var wrapper = $('#wrapper').first();
    wrapper.css('width', '100%');
    wrapper.css('height', '100%');

    var __ret = getWrapperDimensions(wrapper);
    var width = __ret.width;
    var height = __ret.height;
    wrapper.css('width', parseInt(width)-5.*4/3+'px')
    wrapper.css('height', parseInt(height)-5+'px')

    var szerokosc_pola = $('.pole').first().width();
    $('.pole').css('height', szerokosc_pola);

    $('#canvas').css('width',width);
    $('#canvas').css('height',height);

    $('#canvas canvas').css('width',parseInt(width)-5.*4/3+'px');
    $('#canvas canvas').css('height',parseInt(height)-5+'px');

    return __ret;

}

function goToSlide(id){
    $('.slide').removeClass('active');
    $('.dot').removeClass('active');
    $('div.slide').eq(id-1).addClass('active');
    $('div.dot').eq(id-1).addClass('active');

    $('.slajd').removeClass('active');
    $('#slajd1_1').addClass('active')
    $('#slajd2_1').addClass('active')
    $('#slajd3_1').addClass('active')
    $('#slajd4_1').addClass('active')
    $('#slajd5_1').addClass('active')
    $('#slajd6_1').addClass('active')
}


function backToDices(){
    $('#throw_dwa').css('display','block');
    $('#canvas').css('display','block');
    $('#canvas canvas').css('display','block');
    $('#wrapper').removeClass('active');
    $('.slide').removeClass('active');
    $('.slajd').removeClass('active');
    $('.plansza').addClass('active');
    window.list_of_bridges.forEach(
        function(entry){
            $('#slajd_plansza_n'+entry).removeClass('active');
        }
    )
}

$( window ).resize(function() {
    __ret = resizeWrapperAndCanvas();

})
$(document).ready(function(){
    __ret = resizeWrapperAndCanvas();
    activeSlide = 0;
    backToDices(); // na początku żeby nie było żadnego mostu

})

$('#button').click(
    function(){
        if(activeSlide == 0){
            activeSlide = randomIntFromInterval(1,6);
        }else{
            activeSlide += randomIntFromInterval(0,4);
            activeSlide = activeSlide%6+1;
        }
        goToSlide(activeSlide);
    }
)

$('#dot1').click(
    function(){
        goToSlide(1);
    }
)

$('#dot2').click(
    function(){
        goToSlide(2);
    }
)

$('#dot3').click(
    function(){
        goToSlide(3);
    }
)

$('#dot4').click(
    function(){
        goToSlide(4);
    }
)

$('#dot5').click(
    function(){
        goToSlide(5);
    }
)

$('#dot6').click(
    function(){
        goToSlide(6);
    }
)

