<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Base extends Relio_Controller_Admin {
    
    public function action_index() {
        $message = message::get_once();
        
        if (!$this->request->param('id')) {
            parent::$_acl->check('base', 'list');
            
            $this->template->content = View::factory('smarty:admin/base/list_parent')
                ->bind('message', $message)
                ->bind('items', $items)
                ->bind('pagination', $pagination)
                ->bind('sort', $sort)
                ->bind('current_sort', $current_sort);
            
            $builder = Jelly::select('category')->filter(0, null, input::get('status'), input::get('q'));
            
            $order_how = (input::get('how')) ? input::get('how') : 'DESC';
            
            $order_direction = ($order_how == 'DESC') ? 'ASC' : 'DESC';
            
            $sort = array(
                'name'   => URL::query(array('sort' => 'name', 'how' => $order_direction)),
                'status' => URL::query(array('sort' => 'status', 'how' => $order_direction))
            );
            
            switch (input::get('sort')) {
                case 'name':
                    $builder->order_by('name', $order_how);
                    $current_sort = array('type' => 'name', 'how' => $order_how);
                break;
                case 'status':
                    $builder->order_by('active', $order_how);
                    $current_sort = array('type' => 'status', 'how' => $order_how);
                break;
                default:
                break;
            }
        
            $limit = 10;
            $pagination = Pagination::factory();
            $pagination->setup(array(
                'total_items' => $builder->count(),
                'items_per_page' => $limit
            ));
            $items = $builder->offset($pagination->offset)->limit($limit)->execute();
        }
        else {
            parent::$_acl->check('chapters', 'list');
            
            $this->template->content = View::factory('smarty:admin/base/list_child')
                ->bind('message', $message)
                ->bind('items', $items)
                ->bind('pagination', $pagination)
                ->bind('parent_id', $parent_id)
                ->bind('parent', $parent);
                
            $parent_id = $this->request->param('id');
            
            $parent = Jelly::select('category', $parent_id);
            
            $builder = Jelly::select('category')->filter($parent_id, 0);
            
            $limit = 900;
            $pagination = Pagination::factory();
            $pagination->setup(array(
                'total_items' => $builder->count(),
                'items_per_page' => $limit
            ));
            $items = $builder->offset($pagination->offset)->limit($limit)->execute();
        }
    }
    
    public function action_add_parent() {
        parent::$_acl->check('base', 'add');
        
        $this->template->content = View::factory('smarty:admin/base/add_parent')
            ->bind('errors', $errors);
        
        if ($_POST) {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty');
            
            if ($post->check()) {
                
                $item = Jelly::factory('category');
                $item->first_parent_id = 0;
                $item->second_parent_id = 0;
                $item->name = Security::xss_clean(input::post('name'));
                $item->save();
                
                Tracker::track(__('Dodano kategorie w bazie szkoleń ID: ').$item->id);
                
                message::good(__('Dodanie przebiegło pomyślnie'), 'admin/base'.URL::query());
            }
            else {
                $errors = $post->errors('backend/base/parent/form');
            }
        }
    }
    
    public function action_edit_parent() {
        parent::$_acl->check('base', 'edit');
        
        $this->template->content = View::factory('smarty:admin/base/edit_parent')
            ->bind('errors', $errors)
            ->bind('item', $item);
        
        $item = Jelly::select('category', (int)$this->request->param('id'));
        
        if ($_POST) {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty');
            
            if ($post->check()) {
                $item->first_parent_id = 0;
                $item->second_parent_id = 0;
                $item->name = Security::xss_clean(input::post('name'));
                $item->save();
                
                Tracker::track(__('Edycja kategorii w bazie szkoleń ID: ').$this->request->param('id'));
                
                message::good(__('Edycja przebiegła pomyślnie'), 'admin/base'.URL::query());
            }
            else {
                $errors = $post->errors('backend/base/parent/form');
            }
        }
    }
    
    public function action_add_child() {
        parent::$_acl->check('chapters', 'add');
        
        $this->template->content = View::factory('smarty:admin/base/add_child')
            ->bind('errors', $errors);
        
        if ($_POST) {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty');
            
            if ($post->check()) {
                $item = Jelly::factory('category');
                $max_posy = $item->preparePosyLast($this->request->param('id'));
                $item->first_parent_id = $this->request->param('id');
                $item->second_parent_id = 0;
                $item->name = Security::xss_clean(input::post('name'));
                $item->posy = ($max_posy+1);
                $item->save();
                
                Tracker::track(__('Dodano podkategorie w bazie szkoleń ID: ').$item->id);
                
                message::good(__('Dodanie przebiegło pomyślnie'), 'admin/base/index/'.$this->request->param('id').URL::query());
            }
            else {
                $errors = $post->errors('backend/base/child/form');
            }
        }
    }
    
    public function action_up() {
        $item = Jelly::select('category', $this->request->param('id'));
        if ($item->loaded()) {
            $item->positionUp('first_parent_id', '=', $this->request->param('stuff'));
            
            message::good(__('Pozycja została zmieniona pomyślnie'), 'admin/base/index/'.$this->request->param('stuff').URL::query());
        }
        else {
            message::error(__('Wystąpił błąd podczas zmiany pozycji'), 'admin');
        }
    }
     
    public function action_down() {
        $item = Jelly::select('category', (int)$this->request->param('id'));
        if ($item->loaded()) {
            $item->positionDown('first_parent_id', '=', $this->request->param('stuff'));
            
            message::good(__('Pozycja została zmieniona pomyślnie'), 'admin/base/index/'.$this->request->param('stuff').URL::query());
        }
        else {
            message::error(__('Wystąpił błąd podczas zmiany pozycji'), 'admin');
        }
    }
    
    public function action_edit_child() {
        parent::$_acl->check('chapters', 'edit');
        
        $this->template->content = View::factory('smarty:admin/base/edit_child')
            ->bind('errors', $errors)
            ->bind('item', $item);
        
        $item = Jelly::select('category', (int)$this->request->param('id'));
        
        if ($_POST) {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty');
            
            if ($post->check()) {
                $item->name = Security::xss_clean(input::post('name'));
                $item->save();
                
                Tracker::track(__('Edycja podkategorii w bazie szkoleń ID: ').$this->request->param('id'));
                
                message::good(__('Edycja przebiegła pomylnie'), 'admin/base/index/'.$item->first_parent_id.URL::query());
            }
            else {
                $errors = $post->errors('backend/base/child/form');
            }
        }
    }
    
    public function action_status() {
        parent::$_acl->check('base', 'edit');
        
        $allowed_status = array('0', '1');
        if (in_array($this->request->param('stuff'), $allowed_status)) {
            $item = Jelly::select('category', (int)$this->request->param('id'));
            if ($item->loaded()) {
                $item->active = $this->request->param('stuff');
                $item->save();
                
                Tracker::track(__('Zmiana statusu kategorii w bazie szkoleń ID: ').$this->request->param('id'));
                
                message::good(__('Status został zmieniony pomyślnie'), 'admin/base'.URL::query());
            }
            else {
                message::error(__('Wystąpił błąd podczas zmiany statusu'), 'admin');
            }
        }
        else {
            message::error(__('Wystąpił błąd podczas zmiany statusu'), 'admin');
        }
    }
    
    public function action_delete() {
        parent::$_acl->check('base', 'delete');
        
        $item = Jelly::select('category', $this->request->param('id'));
        if ($item->loaded()) {
            $first_parent_id = $item->first_parent_id;
            $item->delete();

            if ($first_parent_id) {
                $item->rePosy($first_parent_id);
            }
            
            Tracker::track(__('Usunięto kategorie z bazy szkoleń ID: ').$this->request->param('id'));
            
            $redirect_link = ($first_parent_id) ? '/index/'.$first_parent_id : '';
            message::good(__('Usunięcie przebiegło pomyślnie'), 'admin/base'.$redirect_link.URL::query());
        }
        else {
            message::error(__('Wystąpił błąd podczas usuwania'), 'admin/base'.URL::query());
        }
    }
    
    public function action_checkbox() {
        if ($_POST) {
            switch (input::post('action')) {
                case 'delete':
                    parent::$_acl->check('base', 'delete');
                    
                    if (is_array(input::post('list'))) {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('category', $value);
                            if ($item->loaded()) {
                                Tracker::track(__('Usunięto kategorie z bazy szkoleń ID: ').$item->id);
                                
                                $item->delete();
                            }
                        }
                    }
                break;
                case 'publish':
                    parent::$_acl->check('base', 'edit');
                    
                    if (is_array(input::post('list'))) {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('category', $value);
                            
                            Tracker::track(__('Zmiana statusu kategorii w bazie szkoleń ID: ').$item->id);
                            
                            $item->active = 1;
                            $item->save();
                        }
                    }
                break;
                case 'unpublish':
                    parent::$_acl->check('base', 'edit');
                    
                    if (is_array(input::post('list'))) {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('category', $value);
                            
                            Tracker::track(__('Zmiana statusu kategorii w bazie szkoleń ID: ').$item->id);
                            
                            $item->active = 0;
                            $item->save();
                        }
                    }
                break;
            }
            
            message::good(__('Operacja przeprowadzona pomyślnie'), 'admin/base'.URL::query());
        }
    }
}