<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Circles_Lessons extends Relio_Controller_Admin {
    public function action_index()
    {
        parent::$_acl->check('circles_lessons', 'list');
        
        $this->template->content = View::factory('admin/circles/lessons/list.tpl')
            ->bind('message', $message)
            ->bind('item_id', $item_id)
            ->bind('items', $items)
            ->bind('pagination', $pagination)
            ->bind('sort', $sort)
            ->bind('current_sort', $current_sort);

        $message = message::get_once();
        
        $item_id = $this->request->param('id');

        $builder = Jelly::select('circle_lesson')
            ->with('circle')
            ->where('circle_id', '=', $item_id);
        
        //if (Auth::instance()->get_user()->has_role('moderator'))
        //{
        //    $builder->where('_school:school.user_id', '=', Auth::instance()->get_user()->id);
        //}
        
        $order_how = (input::get('how')) ? input::get('how') : 'DESC';
        
        $order_direction = ($order_how == 'DESC') ? 'ASC' : 'DESC';
        
        $sort = array(
            'subject'  => URL::query(array('sort' => 'subject', 'how' => $order_direction)),
            'leader'   => URL::query(array('sort' => 'leader', 'how' => $order_direction)),
            'students' => URL::query(array('sort' => 'students', 'how' => $order_direction)),
            'date'     => URL::query(array('sort' => 'date', 'how' => $order_direction))
        );
        
        switch (input::get('sort')) {
            case 'subject':
                $builder->order_by('subject', $order_how);
                $current_sort = array('type' => 'subject', 'how' => $order_how);
            break;
            case 'leader':
                $builder->order_by('leader', $order_how);
                $current_sort = array('type' => 'leader', 'how' => $order_how);
            break;
            case 'students':
                $builder->order_by('students', $order_how);
                $current_sort = array('type' => 'students', 'how' => $order_how);
            break;
            case 'date':
                $builder->order_by('date_on', $order_how);
                $current_sort = array('type' => 'date', 'how' => $order_how);
            break;          
            default:
            break;
        }
        
        $limit = input::get('limit') ? input::get('limit') : 10;
        
        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $builder->count(),
            'items_per_page' => $limit
        ));
        
        $items = $builder->offset($pagination->offset)->limit($limit)->execute();
    }

    public function action_add()
    {
        parent::$_acl->check('circles_lessons', 'add');
        
        $this->template->content = View::factory('admin/circles/lessons/add.tpl')
            ->bind('errors', $errors);
                
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('subject', 'not_empty')
                ->rule('leader', 'not_empty')
                ->rule('students', 'not_empty')
                ->rule('date_on', 'not_empty');
            
            if ($post->check())
            {
                $item = Jelly::factory('circle_lesson');
                $item->circle = $this->request->param('id');
                $item->subject = Security::xss_clean(input::post('subject'));
                $item->leader = Security::xss_clean(input::post('leader'));
                $item->students = Security::xss_clean(input::post('students'));
                $item->date_on = Security::xss_clean(input::post('date_on'));                
                $item->save();
                
                Tracker::track('Dodano lekcje ID: '.$item->id.' do koła naukowego ID: '.$item->circle->id);

                message::good('Dodanie przebiegło pomyślnie', 'admin/circles_lessons/index/'.$item->circle->id);
            }
            else
            {
                $errors = $post->errors('backend/circles/lessons/form');
            }
        }
    }
    
    public function action_edit()
    {
        parent::$_acl->check('circles_lessons', 'edit');
        
        $this->template->content = View::factory('admin/circles/lessons/edit.tpl')
            ->bind('errors', $errors)
            ->bind('item', $item);
        
        $item = Jelly::select('circle_lesson', $this->request->param('id'));
                
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('subject', 'not_empty')
                ->rule('leader', 'not_empty')
                ->rule('students', 'not_empty')
                ->rule('date_on', 'not_empty');
            
            if ($post->check())
            {
                $item->subject = Security::xss_clean(input::post('subject'));
                $item->leader = Security::xss_clean(input::post('leader'));
                $item->students = Security::xss_clean(input::post('students'));
                $item->date_on = Security::xss_clean(input::post('date_on'));                
                $item->save();
                
                Tracker::track('Dodano lekcje ID: '.$item->id.' do koła naukowego ID: '.$item->circle->id);

                message::good('Dodanie przebiegło pomyślnie', 'admin/circles_lessons/index/'.$item->circle->id);
            }
            else
            {
                $errors = $post->errors('backend/circles/lessons/form');
            }
        }
    }
    
    public function action_delete()
    {
        parent::$_acl->check('circles_lessons', 'delete');
        
        $item = Jelly::select('circle_lesson', $this->request->param('id'));
        if ($item->loaded())
        {
            Tracker::track('Usunięto lekcje ID: '.$item->id.' z koła naukowego ID: '.$item->circle->id);
            
            $item_id = $item->circle->id;
            
            $item->delete();
            
            message::good('Usunięcie przebiegło pomyślnie', 'admin/circles_lessons/index/'.$item_id);
        }
        else
        {
            message::error('Wystąpił błąd podczas usuwania', 'admin');
        }
    }
    
    public function action_checkbox()
    {
        if ($_POST)
        {
            $method_to_call = '_checkbox_'.input::post('action');
            if (method_exists($this, $method_to_call))
            {
                $this->$method_to_call();
            }
            
            message::good('Operacja przeprowadzona pomyślnie', 'admin/circles_lessons/index/'.$this->request->param('id').URL::query());
        }
    }
    
    /**
     * Checkbox - Usuń
     */
    private function _checkbox_delete()
    {
        parent::$_acl->check('circles_lessons', 'delete');
        
        if (is_array(input::post('list')))
        {
            $ids = array();
            foreach(input::post('list') as $key => $value) {
                $ids[] = $value;
            }
            
            if (empty($ids))
            {
                $ids[] = 0;
            }
            
            $items = Jelly::select('circle_lesson')
                ->where('id', 'IN', $ids)
                ->execute();
        
            foreach($items as $it) {
                Tracker::track('Usunięto lekcje ID: '.$it->id.' z koła naukowego ID: '.$it->circle->id);
                
                $it->delete();
            }
        }
    }
}