<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Filemanager extends Controller {
    public function action_index()
    {
        $template = View::factory('smarty:admin/filemanager/list')
            ->bind('items', $attachments);
        
        if ($this->request->param('id'))
        {
            $attachments = Jelly::select('attachment')->order_by('posy','ASC')->filter($this->request->param('id'), $this->request->param('stuff'), 1)->execute();
        }
        else
        {
            $attachments = '';
        }
        
        $this->request->response = $template->render();
    }

    public function action_upload()
    {
        $attachment = Jelly::factory('attachment');
        $attachment->set(array(
            'obj_id'   => input::post('obj_id'),
            'obj_type' => input::post('obj_type'),
            'name'     => input::post('name'),
            'filename' => trim(input::post('filename'), '/'),
            'ext'      => File::getExt(input::post('filename')),
            'slug'     => input::post('slug'),
            'type'     => input::post('type')
        ))->save();
        
        
        Cache::instance('file')->delete('attachments_'.input::get('obj_id'));
    }
    
    public function action_rename()
    {
        if (is_numeric(input::post('image_id')))
        {
            $attachment = Jelly::select('attachment', input::post('image_id'));
        }
        else
        {
            $attachment = Jelly::select('attachment')->where('slug','=',input::post('image_id'))->limit(1)->execute();
        }
        
        Cache::instance('file')->delete('attachments_'.$attachment->obj_id);
        
        $attachment->name = input::post('toName');
        $attachment->save();
        
        $message = array(
            'success'     => true,
            'newname'     => input::post('toName'),
            'newrealname' => input::post('toName')
        );
        echo json_encode($message);
        exit();
    }
    
    public function action_delete()
    {
        $imagestodelete = input::post('deleteimages');
        $successImages = array();
        if (is_array($imagestodelete))
        {
            foreach($imagestodelete as $key => $value) {
                if (is_numeric($value))
                {
                    $attachment = Jelly::select('attachment', $value);
                }
                else
                {
                    $attachment = Jelly::select('attachment')->where('slug','=',$value)->limit(1)->execute();
                }
                
                if ($attachment->loaded())
                {                    
                    Cache::instance('file')->delete('attachments_'.$attachment->obj_id);
                    
                    $attachment->delete();
                }
                                
                $successImages[] = $value;
            }
        }
        
        $message = array(
            'success'       => true,
            'successimages' => $successImages
        );
        echo json_encode($message);
        exit();
    }
    
    public function action_sort()
    {
        $sort = input::post('file');
        for ($i = 0; $i < count($sort); $i++) {
            DB::update('attachments')
                ->set(array(
                    'posy' => $i
                ))
                ->where('id', '=', $sort[$i])
                ->execute();
        }
    }
}
