<?php defined('SYSPATH') or die('No direct script access.');

require_once Kohana::find_file('vendor', 'excel');
require_once Kohana::find_file('vendor/Spreadsheet/Excel', 'Reader');

class Controller_Admin_Newsletter extends Relio_Controller_Admin {
    public function action_index()
    {
        parent::$_acl->check('newsletter_messages', 'list');

        $this->template->content = View::factory('smarty:admin/newsletter/list')
            ->bind('message', $message)
            ->bind('items', $items)
            ->bind('pagination', $pagination)
            ->bind('sort', $sort)
            ->bind('current_sort', $current_sort);

        $message = message::get_once();

        $builder = Jelly::select('newsletter_message')->filter(0);
        
        $order_how = (input::get('how')) ? input::get('how') : 'DESC';
        
        $order_direction = ($order_how == 'DESC') ? 'ASC' : 'DESC';
        
        $sort = array(
            'name' => URL::query(array('sort' => 'name', 'how' => $order_direction)),
            'send' => URL::query(array('sort' => 'send', 'how' => $order_direction)),
            'date' => URL::query(array('sort' => 'date', 'how' => $order_direction))
        );
        
        switch (input::get('sort')) {
            case 'name':
                $builder->order_by('name', $order_how);
                $current_sort = array('type' => 'name', 'how' => $order_how);
            break;
            case 'send':
                $builder->order_by('sentto', $order_how);
                $current_sort = array('type' => 'send', 'how' => $order_how);
            break;
            case 'date':
                $builder->order_by('updated', $order_how);
                $current_sort = array('type' => 'date', 'how' => $order_how);
            break;
            default:
            break;
        }

        $limit = input::get('limit') ? input::get('limit') : 10;
        
        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $builder->count(),
            'items_per_page' => $limit
        ));

        $items = $builder->offset($pagination->offset)->limit($limit)->execute();
    }

    public function action_tosend()
    {
        parent::$_acl->check('newsletter_messages', 'list');

        $this->template->content = View::factory('admin/newsletter/list_tosend.tpl')
            ->bind('message', $message)
            ->bind('items', $items)
            ->bind('pagination', $pagination)
            ->bind('sort', $sort)
            ->bind('current_sort', $current_sort);

        $message = message::get_once();

        $builder = Jelly::select('newsletter_message')->filter(1);

        $order_how = (input::get('how')) ? input::get('how') : 'DESC';
        
        $order_direction = ($order_how == 'DESC') ? 'ASC' : 'DESC';
        
        $sort = array(
            'name'   => URL::query(array('sort' => 'name', 'how' => $order_direction)),
            'type'   => URL::query(array('sort' => 'type', 'how' => $order_direction)),
            'sendon' => URL::query(array('sort' => 'sendon', 'how' => $order_direction)),
        );
        
        switch (input::get('sort')) {
            case 'name':
                $builder->order_by('name', $order_how);
                $current_sort = array('type' => 'name', 'how' => $order_how);
            break;
            case 'type':
                $builder->order_by('send_type', $order_how);
                $current_sort = array('type' => 'type', 'how' => $order_how);
            break;
            case 'sendon':
                $builder->order_by('send_on', $order_how);
                $current_sort = array('type' => 'sendon', 'how' => $order_how);
            break;
            default:
            break;
        }

        $limit = input::get('limit') ? input::get('limit') : 10;
        
        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $builder->count(),
            'items_per_page' => $limit
        ));

        $items = $builder->offset($pagination->offset)->limit($limit)->execute();
    }
    
    public function action_reciver()
    {
        parent::$_acl->check('newsletter_messages', 'edit');
        
        $this->template->content = View::factory('smarty:admin/newsletter/reciver')
            ->bind('items', $items)
            ->bind('pagination', $pagination);
        
        $builder = Jelly::select('newsletter_send')
            ->where('message_id', '=', $this->request->param('id'));

        $limit = input::get('limit') ? input::get('limit') : 10;
        
        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $builder->count(), 
            'items_per_page' => $limit
        ));

        $items = $builder->offset($pagination->offset)->limit($limit)->execute();
    }

    public function action_add()
    {
        parent::$_acl->check('newsletter_messages', 'add');

        $this->template->content = View::factory('smarty:admin/newsletter/add')
            ->bind('errors', $errors)
            ->bind('users', $users)
            ->bind('groups', $groups)
            ->bind('courses', $courses)
            ->bind('choosed_item', $choosed_item)
            ->bind('choosed_action', $choosed_action);

        $choosed_action = $this->request->param('stuff');
        
        $choosed_item = $this->request->param('id');        

        $users = Jelly::select('user')
            ->join('roles_users', 'LEFT')
            ->on('users.id', '=', DB::expr('roles_users.user_id'))
            ->by_role(2)
            ->distinct(true)
            ->execute();
        
        $groups = Jelly::select('user_group')->execute();
        
        $courses = Jelly::select('course')->execute();

        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty')
                ->rule('content', 'not_empty')
                ->rule('content', 'min_length', array(20));
            
            if ($post->check())
            {
                $item = Jelly::factory('newsletter_message');
                $item->name = Security::xss_clean(input::post('name'));                
                $item->content = Security::xss_clean(input::post('content'));
                $item->send_action = Security::xss_clean(input::post('send_action'));
                switch(input::post('send_action')) {
                    case '4':
                        $item->send_item = Security::xss_clean(input::post('course'));
                    break;
                    case '5':
                        $item->send_item = Security::xss_clean(input::post('student'));
                    break;
                    case '6':
                        $item->send_item = Security::xss_clean(input::post('group'));
                    break;
                }
                $item->send_type = input::post('send_type');
                $item->send_on = input::post('send_on');
                $item->save();

                message::good(__('Dodanie przebiegło pomyślnie'), 'admin/newsletter/tosend'.URL::query());
            }
            else
            {
                $errors = $post->errors('backend/newsletter/message/form');
            }
        }
    }


    public function action_edit()
    {
        parent::$_acl->check('newsletter_messages', 'edit');

        $this->template->content = View::factory('smarty:admin/newsletter/edit')
            ->bind('errors', $errors)
            ->bind('item', $item)
            ->bind('users', $users)
            ->bind('groups', $groups)
            ->bind('courses', $courses);

        $item = Jelly::select('newsletter_message', $this->request->param('id'));

        $users = Jelly::select('user')
            ->join('roles_users', 'LEFT')
            ->on('users.id', '=', DB::expr('roles_users.user_id'))
            ->by_role(2)
            ->distinct(true)
            ->execute();
        
        $groups = Jelly::select('user_group')->execute();
        
        $courses = Jelly::select('course')->execute();

        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty')
                ->rule('content', 'not_empty')
                ->rule('content', 'min_length', array(20));
            
            if ($post->check())
            {                
                $item->name = Security::xss_clean(input::post('name'));                
                $item->content = Security::xss_clean(input::post('content'));
                $item->send_action = Security::xss_clean(input::post('send_action'));
                switch(input::post('send_action')) {
                    case '4':
                        $item->send_item = Security::xss_clean(input::post('course'));
                    break;
                    case '5':
                        $item->send_item = Security::xss_clean(input::post('student'));
                    break;
                    case '6':
                        $item->send_item = Security::xss_clean(input::post('group'));
                    break;
                }
                $item->send_type = input::post('send_type');
                $item->send_on = input::post('send_on');
                $item->save();

                Tracker::track(__('Edycja wiadomości w newsletterze ID: ').$item->id);

                message::good(__('Edycja przebiegła pomyślnie'), 'admin/newsletter/tosend'.URL::query());
            }
            else
            {
                $errors = $post->errors('backend/newsletter/message/form');
            }
        }
    }
    
    public function action_reuse()
    {
        parent::$_acl->check('newsletter_messages', 'edit');

        $this->template->content = View::factory('smarty:admin/newsletter/reuse')
            ->bind('errors', $errors)
            ->bind('item', $item)
            ->bind('users', $users)
            ->bind('groups', $groups)
            ->bind('courses', $courses);

        $item = Jelly::select('newsletter_message', $this->request->param('id'));

        $users = Jelly::select('user')
            ->join('roles_users', 'LEFT')
            ->on('users.id', '=', DB::expr('roles_users.user_id'))
            ->by_role(2)
            ->distinct(true)
            ->execute();
        
        $groups = Jelly::select('user_group')->execute();
        
        $courses = Jelly::select('course')->execute();

        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty')
                ->rule('content', 'not_empty')
                ->rule('content', 'min_length', array(20));
            
            if ($post->check())
            {                
                $newitem = Jelly::factory('newsletter_message');
                $newitem->name = input::post('name');                
                $newitem->content = input::post('content');
                $newitem->send_action = input::post('send_action');
                switch(input::post('send_action')) {
                    case '4':
                        $newitem->send_item = input::post('course');
                    break;
                    case '5':
                        $newitem->send_item = input::post('student');
                    break;
                    case '6':
                        $newitem->send_item = input::post('group');
                    break;
                }
                $newitem->send_type = input::post('send_type');
                $newitem->send_on = input::post('send_on');
                $newitem->save();

                Tracker::track(__('Ponowne dodanie wiadomości w newsletterze ID: ').$item->id);

                message::good(__('Edycja przebiegła pomyślnie'), 'admin/newsletter/tosend'.URL::query());
            }
            else
            {
                $errors = $post->errors('backend/newsletter/message/form');
            }
        }
    }

    public function action_view()
    {
        parent::$_acl->check('newsletter_messages', 'list');

        $this->template->content = View::factory('smarty:admin/newsletter/view')
            ->bind('item', $item)
            ->bind('users', $users)
            ->bind('courses', $courses);

        $item = Jelly::select('newsletter_message', $this->request->param('id'));

        $users = Jelly::select('user')->get_students()->execute();
        
        $courses = Jelly::select('course')->execute();
    }

    public function action_delete()
    {
        parent::$_acl->check('newsletter_messages', 'delete');

        $item = Jelly::select('newsletter_message', $this->request->param('id'));

        if ($item->loaded())
        {
            Tracker::track(__('Usunięto wiadomość z newslettera ID: ').$item->id);
            
            $item->delete();            

            message::good(__('Usunięcie przebiegło pomyślnie'), 'admin/newsletter/tosend'.URL::query());
        }
        else
        {
            message::error(__('Wystąpił błąd podczas usuwania'), 'admin');
        }
    }

    public function action_sendworker()
    {
        parent::$_acl->check('newsletter_messages', 'send');

        $done = 0;
        $sent = 0;

        $row = Jelly::select('newsletter_message', input::get('id'));

        $pergo = intval($row->pergo);
        $sofar = intval($row->sentto);

        if ($row->send_action == 1)
        {
            $builder = Jelly::select('user')
                ->join('roles_users', 'LEFT')
                ->on('users.id', '=', DB::expr('roles_users.user_id'))
                ->by_role(2)
                ->distinct(true);
            
            $total = DB::select(DB::expr('COUNT(DISTINCT user_id) AS mycount'))
                ->from('roles_users')
                ->where('role_id', '=', '2')                                
                ->execute()
                ->get('mycount');    
        }
        elseif ($row->send_action == 2)
        {
            $builder = Jelly::select('user')
                ->join('roles_users', 'LEFT')
                ->on('users.id', '=', DB::expr('roles_users.user_id'))
                ->by_role(2)
                ->where('active', '=', '1');
            
            $total = DB::select(DB::expr('COUNT(DISTINCT users.id) AS mycount'))
                ->from('users')
                ->join('roles_users', 'LEFT')
                ->on('users.id', '=', DB::expr('roles_users.user_id'))
                ->where('roles_users.role_id', '=', '2')
                ->where('users.active', '=', '1')                
                ->execute()
                ->get('mycount');
        }
        elseif ($row->send_action == 3)
        {
            $builder = Jelly::select('user')
                ->join('roles_users', 'LEFT')
                ->on('users.id', '=', DB::expr('roles_users.user_id'))
                ->by_role(2)
                ->where('active', '=', '0');
            
            $total = DB::select(DB::expr('COUNT(DISTINCT users.id) AS mycount'))
                ->from('users')
                ->join('roles_users', 'LEFT')
                ->on('users.id', '=', DB::expr('roles_users.user_id'))
                ->where('roles_users.role_id', '=', '2')
                ->where('users.active', '=', '0')
                ->execute()
                ->get('mycount');
        }
        elseif ($row->send_action == 4)
        {
            $builder = Jelly::select('course_user')->filter(null, $row->course);
            
            $total = Jelly::select('course_user')->filter(null, $this->course)->count();
        }
        elseif ($row->send_action == 5)
        {
            $student = Jelly::select('user', $row->send_item);
        }
        elseif ($row->send_action == 6)
        {
            $builder = Jelly::select('user')
                ->join('user_groups_users', 'LEFT')
                ->on('user_groups_users.user_id', '=', DB::expr('users.id'))                
                ->by_group($this->send_item)
                ->distinct(true);
            
            $total = DB::select(DB::expr('COUNT(DISTINCT "users.id") AS mycount'))
                ->from('users')
                ->join('user_groups_users', 'LEFT')
                ->on('users.id', '=', DB::expr('user_groups_users.user_id'))
                ->where('user_groups_users.user_group_id', '=', $this->send_item)
                ->execute()
                ->get('mycount');
        }

        if ($row->send_action == 5)
        {
            $total = 0;
            $sent++;

            $message = View::factory('smarty:admin/newsletter/schema')
                ->set('content', $row->content)
                ->render();
				
			
            Email::connect();
            Email::send($student->email, CFG_WEBMASTER_EMAIL, 'Platforma e-learningowa - Newsletter - ' . $row->name, $message, true);
				
			$reciver = Jelly::factory('newsletter_send');
			$reciver->email = $student->email;
			$reciver->message = input::get('id');
			$reciver->save();
        }
        else
        {
            $row2 = $builder->offset($sofar)->limit($pergo)->execute();

            $sent++;

            if ($row->send_action == 4)
            {
                $email = $row2->user->email;
            }
            else
            {
                $email = $row2->email;
            }
			
            $message = View::factory('smarty:admin/newsletter/schema')
                ->set('content', $row->content)
                ->render();
			
            Email::connect();
            Email::send($row->email, CFG_WEBMASTER_EMAIL, 'Platforma e-learningowa - Newsletter - ' . $row->name, $message, true);
				
			$reciver = Jelly::factory('newsletter_send');
			$reciver->email = $email;
			$reciver->message = input::get('id');
			$reciver->save();
        }

        if ($sofar < $total)
        {
            $item = Jelly::select('newsletter_message', $row->id);
            $item->set(array(
                'updated' => date('Y-m-d H:i:s', time()),
                'sentto' => ($sofar + $pergo)
            ));
            $item->save();

            sleep(5);
            echo (1);
            exit;
        }
        else
        {
            $item = Jelly::select('newsletter_message', $row->id);
            $item->set(array(
                'updated' => date('Y-m-d H:i:s', time()),
                'sentto' => ($sofar+1),
                'active' => 0
            ));
            $item->save();

            echo (0);
            exit;
        }
    }

    public function action_checkbox()
    {
        if ($_POST)
        {
            switch (input::post('action'))
            {
                case 'delete':
                    parent::$_acl->check('newsletter_messages', 'delete');

                    if (is_array(input::post('list')))
                    {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('newsletter_message', $value);
                            if ($item->loaded())
                            {
                                Tracker::track(__('Usunięto wiadomość z newslettera ID: ').$item->id);
                                
                                $item->delete();
                            }
                        }
                    }
                break;
                default:
                break;
            }

            message::good(__('Operacja przeprowadzona pomyślnie'), 'admin/newsletter/tosend'.URL::query());
        }
    }
}
