<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Schools_Classes_Students extends Relio_Controller_Admin {
    public function action_index()
    {
        //parent::$_acl->check('schools_classes', 'list');
        
        $this->template->content = View::factory('admin/schools/classes/students/list.tpl')
            ->bind('message', $message)
            ->bind('item_id', $item_id)
            ->bind('items', $items)
            ->bind('pagination', $pagination)
            ->bind('sort', $sort)
            ->bind('current_sort', $current_sort);

        $message = message::get_once();
        
        $item_id = $this->request->param('id');

        $builder = Jelly::select('user')
            ->with('school')
            ->with('class')
            ->where('class_id', '=', $item_id);
        
        if (Auth::instance()->get_user()->has_role('moderator'))
        {
            $builder->where('_school:school.user_id', '=', Auth::instance()->get_user()->id);
        }
        
        $order_how = (input::get('how')) ? input::get('how') : 'DESC';
        
        $order_direction = ($order_how == 'DESC') ? 'ASC' : 'DESC';
        
        $sort = array(
            'firstname' => URL::query(array('sort' => 'firstname', 'how' => $order_direction)),
            'lastname'  => URL::query(array('sort' => 'lastname', 'how' => $order_direction)),
            'email'     => URL::query(array('sort' => 'email', 'how' => $order_direction)),
        );
        
        switch (input::get('sort')) {
            case 'firstname':
                $builder->order_by('name', $order_how);
                $current_sort = array('type' => 'name', 'how' => $order_how);
            break;
            case 'lastname':
                $builder->order_by('lastname', $order_how);
                $current_sort = array('type' => 'lastname', 'how' => $order_how);
            break;
            case 'email':
                $builder->order_by('email', $order_how);
                $current_sort = array('type' => 'email', 'how' => $order_how);
            break;           
            default:
            break;
        }
        
        $limit = input::get('limit') ? input::get('limit') : 10;
        
        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $builder->count(),
            'items_per_page' => $limit
        ));
        
        $items = $builder->offset($pagination->offset)->limit($limit)->execute();
    }

    public function action_add()
    {
        //parent::$_acl->check('schools_classes', 'add');
        
        $this->template->content = View::factory('admin/schools/classes/students/add.tpl')
            ->bind('errors', $errors);
        
        $class = Jelly::select('school_class', $this->request->param('id'));
        
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('students', 'not_empty');
            
            if ($post->check())
            {
                foreach(input::post('students') as $students) {
                    $user = Jelly::select('user', $students['id']);
                    $user->school = $class->school->id;
                    $user->class = $class->id;
                    $user->save();
                    
                    Tracker::track('Przypisano studenta ID: '.$user->id.' do klasy ID: '.$class->id);
                }

                message::good('Dodanie przebiegło pomyślnie', 'admin/schools_classes_students/index/'.$class->id);
            }
            else
            {
                $errors = $post->errors('backend/schools/classes/students/form');
            }
        }
    }

    public function action_delete()
    {
        //parent::$_acl->check('schools_classes', 'delete');
        
        $item = Jelly::select('user', $this->request->param('id'));
        if ($item->loaded())
        {
            Tracker::track('Usunięto studenta ID: '.$item->id.' z klasy ID: '.$item->class->id);
            
            $item_id = $item->class->id;
            
            DB::update('users')
                ->set(array(
                    'school_id' => NULL,
                    'class_id' => NULL
                ))
                ->where('id', '=', $item->id)
                ->execute();
            
            message::good('Zlecenie zostało usunięte pomyślnie', 'admin/schools_classes_students/index/'.$item_id);
        }
        else
        {
            message::error('Wystąpił błąd podczas usuwania zlecenia', 'admin');
        }
    }
    
    public function action_checkbox()
    {
        if ($_POST)
        {
            $method_to_call = '_checkbox_'.input::post('action');
            if (method_exists($this, $method_to_call))
            {
                $this->$method_to_call();
            }
            
            message::good('Operacja przeprowadzona pomyślnie', 'admin/schools_classes_students/index/'.$this->request->param('id').URL::query());
        }
    }
    
    /**
     * Checkbox - Usuń
     */
    private function _checkbox_delete()
    {
        //parent::$_acl->check('schools_classes', 'delete');
        
        if (is_array(input::post('list')))
        {
            $ids = array();
            foreach(input::post('list') as $key => $value) {
                $ids[] = $value;
            }
            
            if (empty($ids))
            {
                $ids[] = 0;
            }
            
            $items = Jelly::select('user')
                ->where('id', 'IN', $ids)
                ->execute();
        
            foreach($items as $it) {
                Tracker::track('Usunięto studenta ID: '.$it->id.' z klasy ID: '.$it->class->id);
                
                DB::update('users')
                ->set(array(
                    'school_id' => NULL,
                    'class_id' => NULL
                ))
                ->where('id', '=', $it->id)
                ->execute();
            }
        }
    }
}