<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Admin_Slider extends Relio_Controller_Admin {
    public function action_index()
    {
        parent::$_acl->check('slider', 'list');

        $this->template->content = View::factory('admin/slider/list.tpl')
            ->bind('message', $message)
            ->bind('items', $items)
            ->bind('pagination', $pagination)
            ->bind('sort', $sort)
            ->bind('current_sort', $current_sort);

        $message = message::get_once();

        $items = Jelly::select('slider')->execute();
    }

    public function action_add()
    {
        parent::$_acl->check('courses', 'add');

        $this->template->content = View::factory('admin/slider/add.tpl')
            ->bind('errors', $errors);

        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty')
                ->rule('content', 'not_empty')
                ->rule('icon', 'not_empty');
            
            if ($post->check())
            {                
                $item = Jelly::factory('slider');
                $item->preparePosy();
                $item->name = Security::xss_clean(input::post('name'));
                $item->content = Security::xss_clean(input::post('content'));
                $item->redirect = Security::xss_clean(input::post('redirect'));
                $item->icon = trim(input::post('icon'), '/');
                $item->save();

                $count = Jelly::select('slider')->where('active', '=', '1')->count();
                if($count > 4)
                {
                    $item->active = 0;
                    $item->save();
                }

                Tracker::track(__('Dodano nowy slajd ID: ').$item->id);

                if($count > 4)
                {
                    message::notice(__('Slajd został dodany pomyślnie. Jednak naraz może być aktywnych tylko 4 slajdy, obecnie dodany slajd jest odpublikowany'), 'admin/slider'.URL::query());
                }
                else 
                {
                    message::good(__('Dodanie przebiegło pomyślnie'), 'admin/slider');
                }
            }
            else
            {
                $errors = $post->errors('backend/slider/form');
            }
        }
    }

    public function action_edit()
    {
        parent::$_acl->check('slider', 'edit');

        $this->template->content = View::factory('admin/slider/edit.tpl')
            ->bind('errors', $errors)
            ->bind('item', $item);

        $item = Jelly::select('slider', $this->request->param('id'));

        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('name', 'not_empty')
                ->rule('content', 'not_empty');

            if (input::post('image_action') == '3')
            {
                $post->rule('icon', 'not_empty');
            }
            
            if ($post->check())
            {
                $item->name = Security::xss_clean(input::post('name'));
                $item->content = Security::xss_clean(input::post('content'));
                $item->redirect = Security::xss_clean(input::post('redirect'));
                $item->icon = trim(input::post('icon'), '/');
                $item->save();

                Tracker::track(__('Edycja slajdu ID: ').$this->request->param('id'));

                message::good(__('Edycja przebiegła pomyślnie'), 'admin/slider'.URL::query());
            }
            else
            {
                $errors = $post->errors('backend/slider/form');
            }
        }
    }

    public function action_status()
    {
        parent::$_acl->check('slider', 'edit');

        $allowed_status = array('0', '1');
        if (in_array($this->request->param('stuff'), $allowed_status))
        {
            $item = Jelly::select('slider', (int)$this->request->param('id'));
            if ($item->loaded())
            {
                $item->active = Security::xss_clean($this->request->param('stuff'));
                $item->save();

                Tracker::track(__('Zmiana statusu slajdu ID: ') . $item->id);

                if ($this->request->param('stuff') == '1')
                {
                    $count = Jelly::select('slider')->where('active', '=', '1')->count();
                    
                    if($count > 4)
                    {
                        $item->active = 0;
                        $item->save();

                        message::error(__('Status nie został zmieniony. Naraz może być aktywnych tylko 4 slajdy'), 'admin/slider'.URL::query());
                    }
                }

                message::good(__('Status został zmieniony pomyślnie'), 'admin/slider'.URL::query());                
            }
            else
            {
                message::error(__('Wystąpił błąd podczas zmiany statusu'), 'admin');
            }
        }
        else
        {
            message::error(__('Wystąpił błąd podczas zmiany statusu'), 'admin');
        }
    }

    public function action_sort()
    {
        $sort = input::post('image');
        for ($i = 0; $i < count($sort); $i++) {
            DB::update('sliders')
                ->set(array(
                    'posy' => $i
                ))
                ->where('id', '=', $sort[$i])
                ->execute();
        }
    }
    
    public function action_delete()
    {
        parent::$_acl->check('slider', 'delete');

        $item = Jelly::select('slider', $this->request->param('id'));

        if ($item->loaded())
        {
            $item->delete();

            Tracker::track(__('Usunięto slajd ID: ').$this->request->param('id'));

            message::good('Usunięcie przebiegło pomyślnie', 'admin/slider'.URL::query());
        }
        else
        {
            message::error(__('Wystąpił błąd podczas usuwania'), 'admin');
        }
    }
}