<?php defined('SYSPATH') or die('No direct script access.');

set_time_limit(0);

require_once Kohana::find_file('vendor/', 'PHPExcel');
require_once Kohana::find_file('vendor/PHPExcel/', 'IOFactory');
require_once Kohana::find_file('vendor/PHPExcel/Writer/', 'Excel5');

class Controller_Admin_Students extends Relio_Controller_Admin {
    public function action_index()
    {
        $this->template->content = View::factory('admin/students/list.tpl')
            ->bind('message', $message)
            ->bind('groups', $groups)
            ->bind('courses', $courses)
            ->bind('items', $items)
            ->bind('pagination', $pagination)
            ->bind('total', $total)
            ->bind('sort', $sort)
            ->bind('current_sort', $current_sort);

        $message = message::get_once();

        $groups = Jelly::select('user_group')->execute();
        
        $builder_courses = Jelly::select('course');
        
        if (Auth::instance()->get_user()->has_role('moderator'))
        {
            $builder_courses->join('course_moderators', 'LEFT')
                ->on('course_moderators.course_id', '=', DB::expr('courses.id'))
                ->where('course_moderators.user_id', '=', Auth::instance()->get_user()->id);
        }
        
        $courses = $builder_courses->execute();
        
        $in_courses = array();
        foreach($courses as $c) {
            $in_courses[] = $c->id;
        }
		
		if (empty($in_courses))
		{
			$in_courses[] = 0;
		}
        
        $builder = Jelly::select('user')
            ->join('user_groups_users', 'LEFT')
            ->on('user_groups_users.user_id', '=', DB::expr('users.id'))
            ->join('roles_users', 'LEFT')
            ->on('users.id', '=', DB::expr('roles_users.user_id'))
            ->join('courses_users', 'LEFT')
            ->on('courses_users.user_id', '=', DB::expr('users.id'))
            ->by_role(2)
            ->filter(input::get('term'))
            ->distinct(true);
        
        if (Auth::instance()->get_user()->has_role('moderator'))
        {
            $builder->where('courses_users.course_id', 'IN', $in_courses);
        }
        
        $order_how = (input::get('how')) ? input::get('how') : 'DESC';
        
        $order_direction = ($order_how == 'DESC') ? 'ASC' : 'DESC';
        
        $sort = array(
            'firstname'  => URL::query(array('sort' => 'firstname', 'how' => $order_direction)),
            'lastname'   => URL::query(array('sort' => 'lastname', 'how' => $order_direction)),
            'email'      => URL::query(array('sort' => 'email', 'how' => $order_direction)),
            'registered' => URL::query(array('sort' => 'registered', 'how' => $order_direction)),
            'login'      => URL::query(array('sort' => 'login', 'how' => $order_direction)),
            'status'     => URL::query(array('sort' => 'status', 'how' => $order_direction))
        );
        
        switch (input::get('sort')) {
            case 'firstname':
                $builder->order_by('firstname', $order_how);
                $current_sort = array('type' => 'firstname', 'how' => $order_how);
            break;
            case 'lastname':
                $builder->order_by('lastname', $order_how);
                $current_sort = array('type' => 'lastname', 'how' => $order_how);
            break;
            case 'email':
                $builder->order_by('email', $order_how);                    
                $current_sort = array('type' => 'email', 'how' => $order_how);
            break;
            case 'registered':
                $builder->order_by('registered', $order_how);
                $current_sort = array('type' => 'registered', 'how' => $order_how);
            break;
            case 'login':
                $builder->order_by('last_login', $order_how);
                $current_sort = array('type' => 'login', 'how' => $order_how);
            break;
            case 'status':
                $builder->order_by('active', $order_how);
                $current_sort = array('type' => 'status', 'how' => $order_how);
            break;
            default:
            break;
        }
        
        $total = $builder->count();
        
        $limit = input::get('limit') ? input::get('limit') : 10;
        
        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $total,
            'items_per_page' => $limit
        ));
        $items = $builder->offset($pagination->offset)->limit($limit)->execute();
    }
    
    public function action_ajax_select()
    {   
        $this->template = View::factory('admin/layout_iframe.tpl');
        $this->template->content = View::factory('admin/students/select.tpl')
            ->bind('message', $message)
            ->bind('groups', $groups)
            ->bind('courses', $courses)
            ->bind('items', $items)
            ->bind('pagination', $pagination)
            ->bind('sort', $sort)
            ->bind('current_sort', $current_sort);

        $message = message::get_once();

        $groups = Jelly::select('user_group')->execute();
        
        $courses = Jelly::select('course')->execute();

        $builder = Jelly::select('user')
            ->join('user_groups_users', 'LEFT')
            ->on('user_groups_users.user_id', '=', DB::expr('users.id'))
            ->join('roles_users', 'LEFT')
            ->on('users.id', '=', DB::expr('roles_users.user_id'))
            ->join('courses_users', 'LEFT')
            ->on('courses_users.user_id', '=', DB::expr('users.id'))
            ->by_role(2)
            ->filter(input::get('term'))
            ->distinct(true);
        
        $order_how = (input::get('how')) ? input::get('how') : 'DESC';
        
        $order_direction = ($order_how == 'DESC') ? 'ASC' : 'DESC';
        
        $sort = array(
            'firstname'  => URL::query(array('sort' => 'firstname', 'how' => $order_direction)),
            'lastname'   => URL::query(array('sort' => 'lastname', 'how' => $order_direction)),
            'email'      => URL::query(array('sort' => 'email', 'how' => $order_direction)),
            'registered' => URL::query(array('sort' => 'registered', 'how' => $order_direction)),
            'login'      => URL::query(array('sort' => 'login', 'how' => $order_direction)),
            'status'     => URL::query(array('sort' => 'status', 'how' => $order_direction))
        );
        
        switch (input::get('sort')) {
            case 'firstname':
                $builder->order_by('firstname', $order_how);
                $current_sort = array('type' => 'firstname', 'how' => $order_how);
            break;
            case 'lastname':
                $builder->order_by('lastname', $order_how);
                $current_sort = array('type' => 'lastname', 'how' => $order_how);
            break;
            case 'email':
                $builder->order_by('email', $order_how);                    
                $current_sort = array('type' => 'email', 'how' => $order_how);
            break;
            case 'registered':
                $builder->order_by('registered', $order_how);
                $current_sort = array('type' => 'registered', 'how' => $order_how);
            break;
            case 'login':
                $builder->order_by('last_login', $order_how);
                $current_sort = array('type' => 'login', 'how' => $order_how);
            break;
            case 'status':
                $builder->order_by('active', $order_how);
                $current_sort = array('type' => 'status', 'how' => $order_how);
            break;
            default:
            break;
        }
        
        $total = $builder->count();
        
        $limit = input::get('limit') ? input::get('limit') : 10;
        
        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $total,
            'items_per_page' => $limit
        ));
        $items = $builder->offset($pagination->offset)->limit($limit)->execute();
    }
    
    public function action_add()
    {
        parent::$_acl->check('students', 'add');

        $this->template->content = View::factory('admin/students/add.tpl')
            ->bind('errors', $errors)
            ->bind('groups', $groups)
            ->bind('provinces', $provinces);

        $provinces = Kohana::config('devilcms.provinces');
        
        $groups = Jelly::select('user_group')->execute();
        
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('email', 'not_empty', array('email'))
                ->rule('firstname', 'not_empty')
                ->rule('lastname', 'not_empty')
                ->callback('email', 'Model_Auth_User::is_email_uniq');
            
            if ($post->check())
            {
                $validate = Validate::factory($_FILES);
                $validate->rules('icon', array('Upload::valid' => array(), 'Upload::not_empty' => array(), 'Upload::size' => array('400M')));
                
                if ($validate->check())
                {
                    $filename = Upload::save($_FILES['icon'], null, DOCROOT . 'upload/avatars');
                }
                else
                {
                    $filename = '';
                }
                    
                if (input::post('password_own'))
                {
                    $temp_password = input::post('password_own');
                }
                else
                {
   					 $temp_password = Text::random();
                }
                
                $_POST['password'] = $temp_password;
                $_POST['password_confirm'] = $temp_password;
                
                $item = Jelly::factory('user');
                $item->password = Security::xss_clean(input::post('password'));
                $item->password_confirm = Security::xss_clean(input::post('password_confirm'));
                $item->email = Security::xss_clean(input::post('email'));
                $item->username = Security::xss_clean(input::post('email'));
                $item->firstname = Security::xss_clean(input::post('firstname'));
                $item->lastname = Security::xss_clean(input::post('lastname'));
                $item->city = Security::xss_clean(input::post('city'));
                $item->address = Security::xss_clean(input::post('address'));
                $item->home = Security::xss_clean(input::post('home'));
                $item->flat = Security::xss_clean(input::post('flat'));
                $item->postcode = Security::xss_clean(input::post('postcode'));
                $item->province = Security::xss_clean(input::post('province'));
                $item->phone1 = Security::xss_clean(input::post('phone1'));
                $item->phone2 = Security::xss_clean(input::post('phone2'));
                $item->active = 0;
                $item->icon = (($filename) ? basename($filename) : '');
                $item->roles = array(1, 2);
                if (input::post('group'))
                {
                    $item->add('user_groups', input::post('group'));
                }
                $item->save();
                   
                if (input::post('notify') == '1')
                {
                    $replaceData = array();
                    $replaceData['%firstname%'] = Security::xss_clean(input::post('firstname'));
                    $replaceData['%lastname%'] = Security::xss_clean(input::post('lastname'));
                    $replaceData['%login%'] = Security::xss_clean(input::post('email'));
                    $replaceData['%password%'] = Security::xss_clean(input::post('password'));
                    $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;
					$replaceData['%platform_link%'] = URL::site('/', 'http');
                    xwContentTemplateWrapper::parameter_email(2, $replaceData, Security::xss_clean(input::post('email')), CFG_WEBMASTER_EMAIL);
                }
                
                Tracker::track(__('Dodano użytkownika ID: ').$item->id);
                
                message::good(__('Dodanie przebiegło pomyślnie'), 'admin/students');
            }
            else
            {
                $errors = $post->errors('backend/users/form');
            }
        }
    }

    public function action_edit()
    {
        parent::$_acl->check('students', 'edit');

        $this->template->content = View::factory('admin/students/edit.tpl')
            ->bind('errors', $errors)
            ->bind('item', $item)
            ->bind('groups', $groups)
            ->bind('selected_groups', $selected_groups)
            ->bind('provinces', $provinces);

        $item = Jelly::select('user', $this->request->param('id'));

        $provinces = Kohana::config('devilcms.provinces');
        
        $groups = Jelly::select('user_group')->execute();
        
        $selected_groups = array();

        foreach ($item->user_groups as $ug) {
            $selected_groups[] = $ug->id;
        }

        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->filter('id', 'trim')
                ->rule('email', 'not_empty')
                ->rule('firstname', 'not_empty')
                ->rule('lastname', 'not_empty')
                ->callback('email', 'Model_Auth_User::email_change');
            
            if ($post->check())
            {
                if (input::post('image_action') == '3')
                {
                    $validate = Validate::factory($_FILES);
                    $validate->rules('icon', array('Upload::valid' => array(), 'Upload::not_empty' => array(), 'Upload::size' => array('400M')));
                    
                    if ($validate->check())
                    {
                        $filename = Upload::save($_FILES['icon'], null, DOCROOT . 'upload/avatars');
                    }
                    else
                    {
                        $filename = '';
                    }
                }
                elseif (input::post('image_action') == '1')
                {
                    $filename = input::post('tmpIcon');
                }
                elseif (input::post('image_action') == '2')
                {
                    @unlink('upload/avatars/'.input::post('tmpIcon'));
                    
                    $filename = '';
                }
                else
                {
                    $filename = '';
                }

                //wyczysc relacje uzytkownik - grupa
                DB::delete('user_groups_users')
                    ->where('user_id', '=', $item->id)
                    ->execute();

                $item->email = Security::xss_clean(input::post('email'));
                $item->username = Security::xss_clean(input::post('email'));
                $item->firstname = Security::xss_clean(input::post('firstname'));
                $item->lastname = Security::xss_clean(input::post('lastname'));
                $item->city = Security::xss_clean(input::post('city'));
                $item->address = Security::xss_clean(input::post('address'));
                $item->home = Security::xss_clean(input::post('home'));
                $item->flat = Security::xss_clean(input::post('flat'));
                $item->postcode = Security::xss_clean(input::post('postcode'));
                $item->province = Security::xss_clean(input::post('province'));
                $item->phone1 = Security::xss_clean(input::post('phone1'));
                $item->phone2 = Security::xss_clean(input::post('phone2'));
                $item->icon = (($filename) ? basename($filename) : '');
                if (input::post('group'))
                {
                    $item->user_groups = input::post('group');
                }
                $item->save();
                
                Tracker::track(__('Edycja użytkownika ID: ').$item->id);
    
                message::good(__('Edycja przebiegła pomyślnie'), 'admin/students'.URL::query());
            }
            else
            {
                $errors = $post->errors('backend/users/form');
            }
        }
    }
    
    public function action_import()
    {
        parent::$_acl->check('students', 'edit');

        $this->template->content = View::factory('admin/students/import.tpl')
            ->bind('errors', $errors)
            ->bind('message', $message)
            ->bind('provinces', $provinces)
            ->bind('groups', $groups);
            
        $message = message::get_once();
        
        $provinces = Kohana::config('devilcms.provinces');
        
        $groups = Jelly::select('user_group')->execute();
        
        $return = array(
            'error' => array()
        );
        
        if ($_POST)
        {
            $post = Validate::factory($_POST)
                ->rule('hidFileID', 'not_empty');

            $errors = array();

            if ($post->check())
            {
                $return = $this->checkXLS(Security::xss_clean(input::post('hidFileID')));
            }
            else
            {
                $errors = array_merge($return['error'], $post->errors());
            }
        }
    }
    
    public function action_import2()
    {
        $this->importXLS(base64_decode($this->request->param('id')));
        
        message::good('Import przebiegł pomyślnie', 'admin/students/import');
    }
    
    public function action_export()
    {
        $items = Jelly::select('user')
            ->join('user_groups_users', 'LEFT')
            ->on('user_groups_users.user_id', '=', DB::expr('users.id'))
            ->join('roles_users', 'LEFT')
            ->on('users.id', '=', DB::expr('roles_users.user_id'))
            ->join('courses_users', 'LEFT')
            ->on('courses_users.user_id', '=', DB::expr('users.id'))
            ->by_role(2)
            ->filter(input::get('term'))
            ->distinct(true)
            ->execute();
                    
        $headers = array(
            'ID',
            'E-mail',
            'Imię',
            'Nazwisko',
            'Miasto',
            'Ulica',
            'Nr domu',
            'Nr mieszkania',
            'Kod pocztowy',
            'Województwo',
            'Telefon',
            'Telefon komórkowy',
            'Grupa'
        );
        
        $collection = array();
        foreach ($items as $it) {            
            $groups = '';
            foreach($it->user_groups as $ug) {
                $groups .= ','.$ug->name;
            }
        
            $collection[] = array(
                $it->id,
                $it->email,
                $it->firstname,
                $it->lastname,
                $it->city,
                $it->address,
                $it->home,
                $it->flat,
                $it->postcode,
                Kohana::config('devilcms.provinces.'.$it->province),
                $it->phone1,
                $it->phone2,
                trim($groups, ',')
            );
        }
        
        Xwxlsexport::export2xls($collection, $headers, 'studenci_'.date('Y_m_d').'.xls');
    }
    
    public function action_notify()
    {
        parent::$_acl->check('students', 'notify');
        
        $item = Jelly::select('user', $this->request->param('id'));
        
        if ($item->loaded())
        {
            Tracker::track(__('Wysłano powiadomienie dla konta ID: ').$item->id);
            
            $temp_password = Text::random();
            
            $item->password = $temp_password;
            $item->password_confirm = $temp_password;
            $item->save();
            
            $replaceData = array();
            $replaceData['%firstname%'] = $item->firstname;
            $replaceData['%lastname%'] = $item->lastname;
            $replaceData['%login%'] = $item->email;
            $replaceData['%password%'] = $temp_password;
            $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;
			$replaceData['%platform_link%'] = URL::site('/', 'http');
            xwContentTemplateWrapper::parameter_email(2, $replaceData, $item->email, CFG_WEBMASTER_EMAIL);
        
            message::good(__('Powiadomienie zostało wysłane pomyślnie'), 'admin/students'.URL::query());
        }
        else
        {
            message::error(__('Wystąpił błąd podczas wysyłania powiadomienia'), 'admin/students'.URL::query());
        }
    }
    
    public function action_login()
    {
        parent::$_acl->check('students', 'login');

        $item = Jelly::select('user', $this->request->param('id'));

        Auth::instance()->impersonate($item);

        Request::instance()->redirect('/');
    }

    public function action_popup_group()
    {
        parent::$_acl->check('students', 'groups');

        $groups = Jelly::select('user_group')->execute();

        $this->content = View::factory('smarty:admin/students/popup/group')
            ->bind('groups', $groups)
            ->render();
    }

    public function action_popup_message()
    {
        parent::$_acl->check('students', 'private');

        $this->content = View::factory('smarty:admin/students/popup/message')->render();
    }

    public function action_status()
    {
        parent::$_acl->check('students', 'edit');

        $allowed_status = array('0', '1');
        if (in_array($this->request->param('stuff'), $allowed_status))
        {
            $item = Jelly::select('user', $this->request->param('id'));
            if ($item->loaded())
            {
                $item->active = $this->request->param('stuff');
                $item->save();
                
                if (CFG_MANUAL_REGISTER_ACCEPT && $this->request->param('stuff') == '1')
                {
                    $replaceData = array();
                    $replaceData['%firstname%'] = Security::xss_clean(input::post('firstname'));
                    $replaceData['%lastname%'] = Security::xss_clean(input::post('lastname'));
                    $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;
					$replaceData['%platform_link%'] = URL::site('/', 'http');
                    xwContentTemplateWrapper::parameter_email(4, $replaceData, $item->email, CFG_WEBMASTER_EMAIL);
                }

                Tracker::track(__('Zmiana statusu użytkownika ID: ').$item->id);

                message::good(__('Status został zmieniony pomyślnie'), 'admin/students'.URL::query());
            }
            else
            {
                message::error(__('Wystąpił błąd podczas zmiany statusu'), 'admin');
            }
        }
        else
        {
            message::error(__('Wystąpił błąd podczas zmiany statusu'), 'admin');
        }
    }

    public function action_delete()
    {
        parent::$_acl->check('students', 'delete');

        $item = Jelly::select('user', $this->request->param('id'));

        if ($item->loaded())
        {
            Tracker::track(__('Usunięto użytkownika ID: ').$item->id);
            
            $item->delete();

            message::good(__('Usunięcie przebiegło pomyślnie'), 'admin/students'.URL::query());
        }
        else
        {
            message::error(__('Wystąpił błąd podczas usuwania'), 'admin');
        }
    }

    public function action_checkbox()
    {
        if ($_POST)
        {
            switch (input::post('action')) {
                case 'delete':
                    parent::$_acl->check('students', 'delete');

                    if (is_array(input::post('list')))
                    {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('user', $value);
                            if ($item->loaded())
                            {
                                if (!in_array($this->request->param('id'), array('1')))
                                {
                                    Tracker::track(__('Usunięto użytkownika ID: ').$item->id);
                                    
                                    $item->delete();
                                }
                            }
                        }
                    }
                break;
                case 'publish':
                    parent::$_acl->check('students', 'edit');

                    if (is_array(input::post('list')))
                    {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('user', $value);
                            if ($item->loaded())
                            {
                                $item->active = 1;
                                $item->save();
                            }
                        }
                    }
                break;
                case 'unpublish':
                    parent::$_acl->check('students', 'edit');

                    if (is_array(input::post('list')))
                    {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('user', $value);
                            if ($item->loaded())
                            {
                                $item->active = 0;
                                $item->save();
                            }
                        }
                    }
                break;
                case 'group':
                    parent::$_acl->check('students', 'groups');

                    if (is_array(input::post('list')))
                    {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('user', $value);
                            if ($item->loaded())
                            {
                                $item->add('user_groups', input::post('group'));
                                $item->save();
                            }
                        }
                    }
                 break;
                 case 'message':
                    parent::$_acl->check('students', 'private');

                    if (is_array(input::post('list')))
                    {
                        foreach (input::post('list') as $key => $value) {
                            $item = Jelly::select('user', $value);
                            if ($item->loaded())
                            {
                                Jelly::factory('privatemessage')->send(array(
                                    'userid' => $item->id,
                                    'touserid' => $item->id,
                                    'fromuserid' => Auth::instance()->get_user()->id,
                                    'title' => Security::xss_clean(input::post('subject')),
                                    'message' => Security::xss_clean(input::post('message'))
                                ), array(
                                    'userid' => Auth::instance()->get_user()->id,
                                    'touserid' => $item->id,
                                    'fromuserid' => Auth::instance()->get_user()->id,
                                    'title' => Security::xss_clean(input::post('subject')),
                                    'message' => Security::xss_clean(input::post('message'))
                                ));
                                
                                $replaceData = array();
                                $replaceData['%sender_firstname%'] = Auth::instance()->get_user()->firstname;
                                $replaceData['%sender_lastname%'] = Auth::instance()->get_user()->lastname;
                                $replaceData['%recive_firstname%'] = $item->firstname;
                                $replaceData['%recive_lastname%'] = $item->lastname;
                                $replaceData['%title%'] = Security::xss_clean(input::post('subject'));
                                $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;
								$replaceData['%platform_link%'] = URL::site('/', 'http');
                    
                                xwContentTemplateWrapper::parameter_email(7, $replaceData, $item->email, CFG_WEBMASTER_EMAIL);
                            }
                        }
                    }
                 break;
                 case 'notify':
                    parent::$_acl->check('students', 'notify');
                     
                    if (is_array(input::post('list')))
                    {
                        foreach(input::post('list') as $key => $value) {
                            $item = Jelly::select('user', $value);
                            if ($item->loaded())
                            {
                                Tracker::track(__('Wysłano powiadomienie dla konta ID: ').$item->id);
                                
                                $temp_password = Text::random();
            
                                $item->password = $temp_password;
                                $item->password_confirm = $temp_password;
                                $item->save();
                                
                                $replaceData = array();
                                $replaceData['%firstname%'] = $item->firstname;
                                $replaceData['%lastname%'] = $item->lastname;
                                $replaceData['%login%'] = $item->email;
                                $replaceData['%password%'] = $temp_password;
                                $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;
								$replaceData['%platform_link%'] = URL::site('/', 'http');
                                xwContentTemplateWrapper::parameter_email(2, $replaceData, $item->email, CFG_WEBMASTER_EMAIL);
                            }
                            
                        }
                    }
                 break;
            }

            message::good(__('Operacja przeprowadzona pomyślnie'), 'admin/students'.URL::query());
        }
    }
    
    public function checkXLS($file)
    {
        $inputFileType = PHPExcel_IOFactory::identify($file);
        
        $objReader = PHPExcel_IOFactory::createReader($inputFileType);
        
        $objPHPExcel = $objReader->load($file);
        
        $sheetData = $objPHPExcel->getActiveSheet()->toArray(null, false, false, true);
        
        $errors = array(
            'error' => array()
        );
        
        $i = 1;
        
        $first = true;
        foreach($sheetData as $row) {
            if ($first) {
                $first = false;
                
                continue;
            }
            
            //sprawdz e-mail opiekuna
            if (! empty($row['C']) AND ! Validate::email(trim($row['C'])))
            {
                $errors['error']['email'] = 'Błędny e-mail w wierszu '.$i;
            }
            
            
            if (! Validate::not_empty(trim($row['A'])))
            {
                $errors['error']['firstname'] = 'Brak imienia w wierszu '.$i;
            }
            
            if (! Validate::not_empty(trim($row['B'])))
            {
                $errors['error']['firstname'] = 'Brak nazwiska w wierszu '.$i;
            }
            
            if (! empty($row['J']) AND ! in_array(trim($row['J']), Kohana::config('devilcms.provinces')))
            {
                $errors['error']['province'] = 'Błędne województwo w wierszu '.$i;
            }
            
            if (! empty($row['M']))
            {
                $groups = explode(',', $row['M']);
                foreach($groups as $group) {
                    $check = Jelly::select('user_group', $group);
                    if (! $check->loaded())
                    {
                        $errors['error']['group'] = 'Błędne grupy w wierszu '.$i;
                    }
                }
            }
            
            $i++;
        }
        
        return $errors;
    }
    
    public function importXLS($file)
    {
        $inputFileType = PHPExcel_IOFactory::identify($file);
        
        $objReader = PHPExcel_IOFactory::createReader($inputFileType);
        
        $objPHPExcel = $objReader->load($file);
        
        $sheetData = $objPHPExcel->getActiveSheet()->toArray(null, false, false, true);
        
        $first = true;
        foreach($sheetData as $row) {
            if ($first) 
            {
                $first = false;
                continue;
            }
            
            $item = Jelly::select('user')
                ->where('email', '=', trim($row['C']))
                ->limit(1)
                ->execute();
            
            if (! $item->loaded())
            {   
                if (! empty($row['M']))
                {
                    $groups = explode(',', $row['M']);
                }
            
                $temp_password = trim($row['D']) ? trim($row['D']) : Text::random();
                    
                $item = Jelly::factory('user');
                $item->password = $temp_password;
                $item->password_confirm = $temp_password;
                $item->email = trim($row['C']);
                $item->username = $item->email;
                $item->firstname = trim($row['A']);
                $item->lastname = trim($row['B']);
                $item->city = trim($row['E']);
                $item->address = trim($row['F']);
                $item->home = trim($row['G']);
                $item->flat = trim($row['H']);
                $item->postcode = trim($row['I']);
                $item->province = trim($row['J']);
                $item->phone1 = trim($row['K']);
                $item->phone2 = trim($row['L']);
                $item->active = 0;
                $item->roles = array(1, 2);
                if (! empty($row['M']))
                {
                    $item->user_groups = $groups;
                }
                $item->save();
                       
                if (trim($row['N']) == 'tak')
                {
                    $replaceData = array();
                    $replaceData['%firstname%'] = $item->firstname;
                    $replaceData['%lastname%'] = $item->lastname;
                    $replaceData['%login%'] = $item->email;
                    $replaceData['%password%'] = $temp_password;
                    $replaceData['%platform_name%'] = CFG_PLATFORM_NAME;
    				$replaceData['%platform_link%'] = URL::site('/', 'http');
					$replaceData['%uri_activate%'] = URL::site('user/activate/'.sha1($item->email), 'http');
                    xwContentTemplateWrapper::parameter_email(2, $replaceData, $item->email, CFG_WEBMASTER_EMAIL);
                }
            }
        }
    }
}
