<?php defined('SYSPATH') or die('No direct script access.');

// Get the URL to the chat directory:
if (!defined('AJAX_CHAT_URL'))
{
    define('AJAX_CHAT_URL', 'czat/');
}

// Get the real path to the chat directory:
if (!defined('AJAX_CHAT_PATH'))
{
	if (empty($_SERVER['SCRIPT_FILENAME']))
	{
		$_SERVER['SCRIPT_FILENAME'] = $_SERVER['DOCUMENT_ROOT'] . $_SERVER['SCRIPT_URL'];
	}
	define('AJAX_CHAT_PATH', realpath(dirname($_SERVER['SCRIPT_FILENAME']) . '/czat') . '/');
}

// Include Class libraries:
require_once(AJAX_CHAT_PATH.'lib/classes.php');
    
class Controller_Chat extends Relio_Controller_Website {
    public function before()
    {
        parent::before();        
        
        View::set_global('in_page', 'chat');
    }
    
    public function action_index()
    {
        if ( ! Auth::instance()->logged_in())
        {
            message::error(__('Aby uzyskać dostęp do szkoleń musisz się zalogować'), 'user/login', 'frontend');
        }
        
        $this->template->content =  View::factory('site/chat/list.tpl')
            ->bind('breadcrumbs', $breadcrumbs)
            ->bind('message', $message)
            ->bind('items', $items_array)
            ->bind('pagination', $pagination);
        
        $message = message::get_once('frontend');

        
        $items_array = array();

        $builder = Jelly::select('chat')
            ->where('course_id', '=', NULL)
            ->where('active', '=', '1');

        $limit = 12;
        
        $pagination = Pagination::factory();
        $pagination->setup(array(
            'total_items' => $builder->count(),
            'items_per_page' => $limit
        ));
            
        $items = $builder->offset($pagination->offset)->limit($limit)->execute();

        foreach($items as $it) {
            $items_array[] = array(
                'id'            => $it->id,
                'name'          => $it->name
            );
        }

        $breadcrumbs = Breadcrumbs::getInstance()
            ->addItem(__('Strona główna'), URL::site('/'))
            ->addItem(__('Czat'), URL::site('chat'))
            ->render();
    }
    
    public function action_room() 
    {
        if ( ! Auth::instance()->logged_in())
        {
            message::error(__('Aby uzyskać dostęp do szkoleń musisz się zalogować'), 'user/login', 'frontend');
        }
        
        $this->template->content = View::factory('site/chat/talk.tpl')
            ->bind('breadcrumbs', $breadcrumbs)
            ->bind('item', $item)
            ->bind('chat', $ajaxChat);
            
        $ajaxChat = new CustomAJAXChatShoutBox();
        
        $item = Jelly::select('chat')
            ->where('id', '=', $this->request->param('id'))
            ->where('active', '=', '1')
            ->limit(1)
            ->execute(); 
        
        if (! $item->loaded())
        {
            message::error('Nie znaleziono pokoju', 'chat', 'frontend');
        }    
    
        $breadcrumbs = Breadcrumbs::getInstance()
            ->addItem(__('Strona główna'), URL::site('/'))
            ->addItem(__('Czat'), URL::site('chat'))
            ->render();
            
    }
}