<?php defined('SYSPATH') or die('No direct script access.');

/**
 * Zadanie sluzy do wystawienia certyfikatow za zakonczone szkolenia
 *
 * @author Michal Mlodzinski <mm@etendard.pl>
 */
class Minion_Task_Course_Certificate extends Minion_Task {
    /**
     * An array of config options that this task can accept
     */
    protected $_config = array(
        'course',
        'user'
    );
    
    /**
     * Execute
     */
    public function execute(array $config) {
        $builder = Jelly::select('course_user')
            ->where('percent', '=', '100');
            
        $builder = Jelly::select('course_user');
        
        if (isset($config['course']))
        {
            $builder->where('course_id', '=', $config['course']);
        }
        
        if (isset($config['user']))
        {
            $builder->where('user_id', '=', $config['user']);
        }
        
        $items = $builder->execute();

        foreach($items as $it) {
            if ($it->course->certificate->id)
            {
                $check = Jelly::select('certificate_history')
                    ->where('user_id', '=', $it->user->id)
                    ->where('course_id', '=', $it->course->id)
                    ->where('subscribe_id', '=', $it->id)
					->limit(1)
                    ->execute();
     
                if ($check->loaded())
                {
                    Certificate::create($it->course, $it, TRUE);
                }
            }
        }
    }
}