<?php
class Model_Builder_Course extends Jelly_Builder {
    public function is_active($active = null) {
        $query = $this;

        if (!is_null($active) && is_numeric($active)) {
            $query->where('active', '=', $active);
        }

        return $query;
    }

    public function filter($term = null) {
        $query = $this;
        
        if (!is_null($term) && is_array($term)) {
            if (isset($term['status'])) {
                if (!is_null($term['status']) && is_numeric($term['status'])) {
                    $query->and_where('active', '=', $term['status']);
                }
            }
            
            if (isset($term['required'])) {
                if (!is_null($term['required']) && is_numeric($term['required'])) {
                    $query->and_where('is_required', '=', $term['required']);
                }
            }

            if (isset($term['date_start'])) {
                if (!is_null($term['date_start']) && !empty($term['date_start'])) {
                    $query->and_where(DB::expr('DATE(publish_on)'), '=', $term['date_start']);
                }
            }

            if (isset($term['date_end'])) {
                if (!is_null($term['date_end']) && is_numeric($term['date_end'])) {
                    $query->and_where(DB::expr('DATE(archive_on)'), '=', $term['date_end']);
                }
            }

            if (isset($term['q'])) {
                if (!is_null($term['q']) && !empty($term['q'])) {
                    $query->and_where('name', 'LIKE', '%'.$term['q'].'%');
                }
            }
        }
              
        return $query;
    }

    public function in_group($groups = null) {
        $query = $this;

        if (!is_null($groups) && !empty($groups) && is_array($groups) && array_filter($groups)) {
            $query->where('course_group_courses.course_group_id', 'IN', $groups);
        }
        
        return $query;
    }

    public function in_category($categories = null) {
        $query = $this;

        if (!is_null($categories) && !empty($categories) && is_array($categories) && array_filter($categories)) {
            $query->where('course_category_courses.course_category_id', 'IN', $categories);
        }

        return $query;
    }
}