<?php

class Model_School_Class extends Jelly_Model {
    public static function initialize(Jelly_Meta $meta) {
    	$meta->fields(array(
    		'id' => Jelly::field('primary'),
    		'name' => Jelly::field('string'),
            'school' => Jelly::field('belongsto'),
            'user' => Jelly::field('hasmany', array(
                'foreign' => 'user.class_id'
            )),
            'teacher' => Jelly::field('manytomany', array(
                'foreign' => 'user',
                'through' => array(
                    'model'   => 'school_class_teacher',
                    'columns' => array('class_id', 'user_id'),
                )
            ))
        ));
    }
}