<?php defined('SYSPATH') or die('No direct access allowed.');

abstract class Relio_Controller_Admin extends Controller_Template
{
      protected $_ajax = false;

      /**
       * @var  string  page template
       */
      public $template = 'admin/layout.tpl';

      /**
       * @var  string  page content
       */
      public $content;
      
      public static $_acl;

      public function before()
      {
           $lng = Request::instance()->param('lang');
           i18n::$lang = $lng . '-' . $lng;
           
           if (Request::$is_ajax or $this->request !== Request::instance()) {
               $this->_ajax = true;
               
               
           }
           
           if ($this->_ajax === false) {
               // Load the template
               $this->template = View::factory($this->template);
           }
           
           View::bind_global('controller', $this->request->controller);
           View::bind_global('content', $this->content);
           View::set_global('session', Session::instance()->get('auth_user'));
           View::set_global('languages', Kohana::config('devilcms.defaults.languages'));
           
           /**
            * Jezeli osoba byla zalogowana jako student w celach sprawdzenia
            * To nalezy go przy wejsciu do admina przelogowac na jego konto
            */
           if (Auth::instance()->is_impersonating())
           {
               Auth::instance()->abdicate();
           }
           
           if (!Auth::instance()->logged_in('admin') && !Auth::instance()->logged_in('moderator') && !Auth::instance()->logged_in('teacher'))
           {
               if ($this->request->controller !== 'login')
               {
                    Session::instance()->set("requested_url", Request::instance()->uri());
                    
                    $this->request->redirect('admin/login');
               }
           }
           else
           {
                self::$_acl = new MyAcl(Session::instance()->get('auth_user')->id);
                
                $roles = Jelly::select('role')
                    ->where('name', '<>', 'login')
                    ->where('name', '<>', 'student')
                    ->order_by('id', 'DESC')
                    ->execute();
                
                View::set_global('roles', $roles);
           }
      }


      /**
       * Assigns the template as the request response.
       *
       * @param   string   request method
       * @return  void
       */
      public function after()
      {
            if ($this->_ajax === true) {
                  // Assign the template as the request response and render it
                  $this->request->response = $this->content;
            }
            else {
                  parent::after();
                  //$this->request->response = $this->content;
            }
            /*
            $groups = Profiler::groups();
            echo count($groups['database ('.Database::instance().')']);
            echo View::factory('profiler/stats');
            */
      }
}
