<?php defined('SYSPATH') or die('No direct script access.');

class Relio_Menu {
    public static function library_menu($root)
    {
        $menu = null;
        
        $route = Jelly::factory('course_page')->root($root);
        
        $menu = $route->descendants();
        
        return new View('site/modules/course/library/menu', array('menu' => $menu));
    }
    
    public static function library_submenu($id)
    {
        $menu = null;
        
        $route = Jelly::select('course_page', $id);

        $parents = $route->parents();
        
        if ($route->lvl === 1)
        {
            $menu = $route->descendants();
        }
        elseif (count($parents) > 0)
        {
            foreach ($parents as $parent) {
                if ($parent->lvl == 1)
                {
                    $menu = $parent->descendants();
               }
            }
        }
        
        return new View('site/modules/course/library/submenu', array('menu' => $menu));
    }
    
    public static function main($with_root = false) {
        $template = 'site/menu/without_root';

        if ($with_root) {
            $template = 'site/menu/all';
        }
        
        $menu = Jelly::select('page')->execute();
        
        return new View($template, array('menu' => $menu));
    }

    public static function breadcrumbs() {
        $menu = array();
        
        $route = Jelly::factory('page')->permalink(Request::instance()->uri());
        
        foreach ($route->parents() as $parent) {
            $parent->content->load();

            if ($parent->lvl > 0) {
                $menu[] = array('id' => $parent->id, 'link' => $parent->uri(), 'title' => $parent->content->title);
            }
        }

        if ($route->lvl > 0) {
            $menu[] = array('id' => $route->id, 'link' => $route->uri(), 'title' => $route->content->title);
            
        }
        
        return new View('site/menu/breadcrumbs', array('menu' => $menu));
    }

    public static function submenu() {
        $menu = null;
        
        $route = Jelly::factory('page')->permalink(Request::instance()->uri());

        $parents = $route->parents();
        
        if ($route->lvl === 1) {
            $menu = $route->descendants();
        }
        elseif (count($parents) > 0) {
            foreach ($parents as $parent) {
                if ($parent->lvl == 1) {
                    $menu = $parent->descendants();
               }
            }
        }
        
        return new View('site/menu/submenu', array('menu' => $menu));
    }

    public static function first_level() {
        $current_root = Kohana::config('devilcms.defaults.languages.' . Request::instance()->param('lang') . '.id');
        $root = Sprig_Mptt::factory('page')->root($current_root);

        $tree = $root->children(false, 'ASC');

        return new View('site/menu/first_level', array('menu' => $tree));
    }

    public static function bottom_first_level()
    {
        $current_root = Kohana::config('devilcms.defaults.languages.' . Request::instance()->param('lang') . '.id');
        $root = Sprig_Mptt::factory('page')->root($current_root);

        $tree = $root->children(false, 'ASC');

        return new View('site/menu/bottom_first_level', array('menu' => $tree));
    }
    
    public static function top_menu()
    {
        $menu = Jelly::select('page')
            ->join('contents', 'LEFT')
            ->on('contents.page_id', '=', 'page.id')
            ->where('contents.menu', '=', 1)
            ->execute();

        return new View('site/menu/top_menu', array('menu' => $menu));
    }
    
    public static function category_first_level() {
        $route = Sprig::factory('page')->permalink(Request::instance()->uri());
        
        $parents = $route->parents();
        
        if ($route->lvl === 1) {
            $tree = $route->children(false, 'ASC');
        }
        elseif (count($parents) > 0) {
            foreach ($parents as $parent) {
                if ($parent->lvl == 1) {
                    $tree = $parent->children(false, 'ASC');
               }
            }
        }
        
        if (!isset($tree)) {
            $tree = '';
        }
        
        return new View('site/menu/category_first_level', array('menu' => $tree));
    }
    
    public static function category_submenu() {
        $route = Jelly::factory('page')->permalink(Request::instance()->uri());
        $parents = $route->parents();

        if ($route->lvl === 2) {
            $tree = $route->descendants(false, 'ASC');
        }
        elseif (count($parents) > 0) {
            foreach ($parents as $parent) {
                if ($parent->lvl == 2) {
                    $tree = $parent->descendants(false, 'ASC');
               }
            }
        }
        
        if (!isset($tree)) {
            $tree = NULL;
        }
        
        return new View('site/menu/category_submenu', array('menu' => $tree));
    }
}
