<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Articles extends Relio_Controller_Website {
    public function action_list($category) {
		$this->content = View::factory('smarty:site/modules/articles/list')
            ->bind('items', $items)
            ->bind('pagination', $pagination)
            ->bind('page', $page);
            
        $builder = Jelly::select('modules_article')->by_page($category)->filter(1);
        
        $limit = 10;
        $pagination = Pagination::factory();
        $pagination->setup(array(
              'total_items' => $builder->count(),
              'items_per_page' => $limit
        ));
        $items = $builder->offset($pagination->offset)->limit($limit)->execute();
  
        /**
         * Trzeba zaladowac dane o kategorii
         */
        $page = Jelly::select('page', $category);
        
        $this->title = $page->content->title;

	}

	public function action_read($category, $slug) {
		$this->content = View::factory('smarty:site/modules/articles/read')
            ->bind('item', $item)
            ->bind('page', $page)
            ->bind('attachments', $attachments);
            
        $item = Jelly::select('modules_article')->by_slug($slug)->limit(1)->execute();
        
        if ($item->loaded()) {
            $attachments = Jelly::select('attachment')->cached(600)->order_by('posy','ASC')->filter($item->id, 'articles')->execute();
            
            /**
             * Trzeba zaladowac dane o kategorii
             */
            $page = Jelly::select('page', $category);
            
            $this->title = $item->name;
        }
	}
}