<?php
function smarty_modifier_format_config($type, $value, $id) {
	if (x::is_serialized(base64_decode($type))) {
		$unserialized = unserialize(base64_decode($type));

		$type = $unserialized['type'];
	}


    if ($type == 'input') {
		return '<input type="text" name="config['.$id.']" value="'.$value.'" size="60" class="field text medium">';
	}
	elseif ($type == 'yesno') {
		$checked_yes = ($value == 'true' OR $value == '1') ? 'checked="checked"' : '';
		$checked_no = ($value == 'false' OR $value == '0') ? 'checked="checked"' : '';

		$return = '';
		$return .= '<label for="'.$id.'_1" class="labelRadio compact"><input type="radio" name="config['.$id.']" id="'.$id.'_1" value="1" '.$checked_yes.' class="inputRadio" /> Tak</label><br />';
		$return .= '<label for="'.$id.'_0" class="labelRadio compact"><input type="radio" name="config['.$id.']" id="'.$id.'_0" value="0" '.$checked_no.' class="inputRadio" /> Nie</label>';

		return $return;
	}
	elseif ($type == 'textarea') {
		return '<textarea name="config['.$id.']" cols="45" rows="5" class="field textarea medium">'.$value.'</textarea>';
	}
	elseif ($type == 'fck') {
		$return = '<textarea name="config['.$id.']" id="config_'.$id.'" cols="50" rows="5" class="mceEditor">'.$value.'</textarea>';
        
		return $return;
	}
	elseif ($type == 'select') {
		$options = $unserialized['options'];

		$return = '<select name="config['.$id.']" class="select">';

		foreach($options as $option) {
			if ($option['value'] == $value) {
				$return .= '<option value="'.$option['value'].'" selected="selected">'.$option['name'].'</option>';
			}
			else {
				$return .= '<option value="'.$option['value'].'">'.$option['name'].'</option>';
			}
		}

		$return .= '</select>';

		return $return;
	}
}