<?php
function jlms_scorm_add_instance ($material_id, $scorm_package) {
    $package = Jelly::select('scorm_package', $scorm_package);
    
	$row = new stdClass ();
    $row->material_id = $material_id;
    $row->scorm_package = $scorm_package;
        
    $row->reference = $package->package_srv_name;
    $row->reference_folder = DOCROOT.'upload/materials/scorm/'.$package->folder_srv_name;
    
    if ($packagedata = scorm_check_package($row) ) {
    	$row->launch = $packagedata->launch;
    	$row->timemodified = time ();
    	$row->md5hash = md5_file($row->reference);
    	$row->params = '';
    	$row->width = '100';
    	$row->height = intval (str_replace ('px', '', $package->window_height));
    	$row->popup = 1;
        
    	if (!$row->height) {
    		$row->height = '600';
		}
		
		if (!isset ($row->whatgrade)) {
			$row->whatgrade = 0;
		}
		
		$row->grademethod = 4;
		$row->grademethod = $row->whatgrade * 10 + $row->grademethod;
		$row->datadir = '';
		$row->pkgtype = $packagedata->pkgtype;
		$row->parse = 1;
                
        $scorm = Jelly::factory('scorm');
        $scorm->material_id = $material_id;
        $scorm->scorm_package = $row->scorm_package;
        $scorm->launch = $row->launch;
        $scorm->timemodified = $row->timemodified;
        $scorm->md5hash = $row->md5hash;
        $scorm->params = $row->params;
        $scorm->width = $row->width;
        $scorm->height = $row->height;
        $scorm->popup = $row->popup;
        $scorm->grademethod = $row->grademethod;
        $scorm->save();
        
        $row->id = $scorm->id;
        
        $scorm = Jelly::select('scorm', $scorm->id);
        $scorm->launch = scorm_parse($row);
        $scorm->save();
	}
	
	return $scorm;
}

?>