<div id="page-layout">
    <div id="page-content">
        <div id="page-content-wrapper">
            <div class="inner-page-title">
                <h2>{lang}Materiały{/lang}</h2>
                <span>{lang}Edycja{/lang}</span>
            </div>
            {if $message.message}
            <div class="response-msg {$message.message_type} ui-corner-all">
                <span>{lang}{$message.message_type_raw}{/lang}</span>
                {$message.message}
            </div>
            {/if}
            <div class="column-content-box">
                <div class="content-box content-box-header ui-corner-all">
                    {if $errors|default:""}
                    <div class="ui-state-default ui-corner-top ui-box-header">
                        <span class="ui-icon float-left ui-icon-notice"></span>
						{lang}Formularz zawiera błędy{/lang}
					</div>
                    <script type="text/javascript">
                        {foreach $errors as $e}
                        $.jnotify('{$e}', "error");
                        {/foreach}
                    </script>
                    {/if}
					<div class="content-box-wrapper">
                        <div id="tabs">
                            <ul>
                                <li>
                                    <a href="#main">{lang}Podstawowe informacje{/lang}</a>
                                </li>
                                <li>
                                    <a href="#questions">{lang}Pytania{/lang}</a>
                                </li>
                            </ul>
                            <div id="main">
                                <form action="" method="post" enctype="multipart/form-data" class="forms" id="signupForm" name="form" >
                                    <fieldset>
                                        <ul>
                                            <li>
                                                <label class="desc {if $errors.questions|default:""}error{/if}">
                                                    {lang}Ilość pytań{/lang}
                                                </label>
                                                <div>
                                                    <input type="text" value="{$smarty.post.questions|default:$item->questions}" class="field text short" name="questions" />
                                                    <br /><small>{lang}Jest to ilość pytań jaka powinna być wylosowana z dostępnej bazy pytań{/lang}</small>
                                                </div>
                                            </li>
                                            <li>
                                                <label class="desc {if $errors.questions_to_pass|default:""}error{/if}">
                                                    {lang}Zalicza pytań{/lang}
                                                </label>
                                                <div>
                                                    <input type="text" value="{$smarty.post.questions_to_pass|default:$item->questions_to_pass}" class="field text short" name="questions_to_pass" />
                                                </div>
                                            </li>
                                            <li>
                                                <label class="desc {if $errors.total_trials|default:""}error{/if}">
                                                    {lang}Maksymalna ilość podejść{/lang}
                                                </label>
                                                <div>
                                                    <input type="text" value="{$smarty.post.total_trials|default:$item->total_trials}" class="field text short" name="total_trials" />
                                                    <br /><small>{lang}Aby umożliwić dowolną ilość podejść, wpisz "0"{/lang}</small>
                                                </div>
                                            </li>
                                            <li>
                                                <label class="desc {if $errors.start_on|default:""}error{/if}">
                                                    {lang}Data rozpoczęcia{/lang}
                                                </label>
                                                <div>
                                                    <input id="start_on" type="text" value="{$smarty.post.start_on|default:$item->start_on}" class="field text short" name="start_on" />
                                                </div>
                                            </li>
                                            <li>
                                                <label class="desc {if $errors.end_on|default:""}error{/if}">
                                                    {lang}Data zakończenia{/lang}
                                                </label>
                                                <div>
                                                    <input id="end_on" type="text" value="{$smarty.post.end_on|default:$item->end_on}" class="field text short" name="end_on" />
                                                </div>
                                            </li>
                                            <li>
                                                <label class="desc {if $errors.time_on|default:""}error{/if}">
                                                    {lang}Czas{/lang} (min)
                                                </label>
                                                <div>
                                                    <input type="text" value="{$smarty.post.time_on|default:$item->time_on}" class="field text short" name="time_on" />
                                                </div>
                                            </li>
                                            <li>
                                                <label class="desc {if $errors.required_good|default:""}error{/if}">
                                                    {lang}Pokazuj feedback po udzieleniu błędnej lub poprawnej odpowiedzi{/lang}
                                                </label>
                                                <div>
                                                    <input type="radio" id="required_good_1" value="1" class="field radio" name="required_good" {if $smarty.post.required_good|default:$item->required_good == '1'}checked="checked"{/if} />
                                                    <label for="required_good_1" class="choice">{lang}Tak{/lang}</label>
                                                    
                                                    <input type="radio" id="required_good_0" value="0" class="field radio" name="required_good" {if $smarty.post.required_good|default:$item->required_good == '0'}checked="checked"{/if} />
                                                    <label for="required_good_0" class="choice">{lang}Nie{/lang}</label>
                                                </div>
                                            </li>
                                            <li>
                                                <label class="desc {if $errors.random_questions|default:""}error{/if}">
                                                    {lang}Losowa kolejność pytań{/lang}
                                                </label>
                                                <div>
                                                    <input type="radio" id="random_questions_1" value="1" class="field radio" name="random_questions" {if $smarty.post.random_questions|default:$item->random_questions|default:"1" == 1}checked="checked"{/if} />
                                                    <label for="random_questions_1" class="choice">{lang}Tak{/lang}</label>
                                                    
                                                    <input type="radio" id="random_questions_0" value="0" class="field radio" name="random_questions" {if $smarty.post.random_questions|default:$item->random_questions == '0'}checked="checked"{/if} />
                                                    <label for="random_questions_0" class="choice">{lang}Nie{/lang}</label>
                                                </div>
                                            </li>
                                            <li>
                                                <label class="desc {if $errors.block_category|default:""}error{/if}">
                                                    {lang}Blokowanie rozdziałow{/lang}
                                                </label>
                                                <div>
                                                    <input type="radio" id="block_category_1" value="1" class="field radio" name="block_category" {if $smarty.post.block_category|default:$item->block_category == 1}checked="checked"{/if} />
                                                    <label for="block_category_1" class="choice">{lang}Tak{/lang}</label>
                                                    
                                                    <input type="radio" id="block_category_2" value="2" class="field radio" name="block_category" {if $smarty.post.block_category|default:$item->block_category|default:"2" == 2}checked="checked"{/if} />
                                                    <label for="block_category_2" class="choice">{lang}Nie{/lang}</label>
                                                    <br /><small>{lang}Czy rozdziały i materiały występujące po teście mają być zablokowane do czasu przejścia testu?{/lang}</small>
                                                </div>
                                            </li>
                                            <li class="buttons">
                                                <input class="submit" type="submit" value="{lang}Zapisz{/lang}" />
                                            </li>
                                        </ul>
                                    </fieldset>
                                </form>
                            </div>
                            <div id="questions">
                                {if !$item->id}
                                <div class="response-msg notice ui-corner-all">
                                    <span>{lang}Uwaga{/lang}</span>
                                    {lang}Przed dodaniem pytań do testu, musisz uzupełnić oraz zapisać podstawowe informacje o teście{/lang}
                                </div>
                                {else}
                                <form name="questionadd" class="pager-form" method="get" action="{helper function="url::site" param1="admin/material_test/add_question/`$item->id`"}"> 
                                    <a href="javascript:void(0);" onclick="javascript:document.forms['questionadd'].submit();" class="btn ui-state-default ui-corner-all">
                                        <span class="ui-icon ui-icon-circle-plus"></span>{lang}Dodaj pytanie typu{/lang}
                                    </a>
                                    <select name="type" class="select">
                                        <option value="1">Jednokrotnego wyboru</option>
                                        <option value="2">Wielokrotnego wyboru</option>
                                        <option value="3">Dopasuj pary</option>
                                        <option value="4">Zaznacz obszar</option>
                                        <option value="5">Prawda/Fałsz</option>
                                        <option value="6">Pytanie otwarte</option>
                                        <option value="7">Wymień ...</option>
                                        <option value="9">Pytanie z pamięci</option>
                                        <option value="10">Ustaw kolejność</option>
                                    </select>
                                </form>
                                <div class="clear"></div>
                                <div class="hastable">
                                    <form name="myform" class="pager-form" method="post" action="{helper function="url::site" param1="admin/material_test/checkbox/`$material->id`"}">             
                                        <table id="sort-table-3">
                                            <thead>
                                                <tr>
                                                    <th>
                                                        <input type="checkbox" value="check_none" onclick="javascript:check_all_box(this.form)" class="submit"/>
                                                    </th>
                                                    <th>
                                                        {lang}Pytanie{/lang}
                                                    </th>
                                                    <th>
                                                        {lang}Publikuj{/lang}
                                                    </th>
                                                    <th colspan="4">
                                                        {lang}Opcje{/lang}
                                                    </th>
                                                </tr> 
                                            </thead>
                                            <tfoot>
                                                <tr>
                                                    <td colspan="10">
                                                        <img src="public/design/backend/images/arrow_ltr.png" />&nbsp;
                                                        <select class="select" name="action" onchange="this.form.submit();">
                                                            <option value="0">-- {lang}wybierz{/lang} --</option>
                                                            <option value="delete">{lang}Usuń{/lang}</option>
                                                            <option value="publish">{lang}Publikuj{/lang}</option>
                                                            <option value="unpublish">{lang}Nie publikuj{/lang}</option>
                                                        </select>
                                                    </td>
                                                </tr>
                                            </tfoot>
                                            <tbody> 
                                                {foreach from=$questions name=it item=it}
                                                <tr>
                                                    <td class="center">
                                                        <input type="checkbox" value="{$it->id}" name="list[]" class="checkbox"/>
                                                    </td>
                                                    <td>{$it->name}</td>
                                                    <td style="text-align: center;">
                                                        {if $it->active == 1}
                                                        <a href="{helper function="url::site" param1="admin/material_test/status_question/`$it->id`/0"}" title="{lang}Publikuj{/lang}" class="tooltip">
                                                            <img src="public/design/backend/images/tick.png" />
                                                        </a>
                                                        {else}
                                                        <a href="{helper function="url::site" param1="admin/material_test/status_question/`$it->id`/1"}" title="{lang}Nie publikuj{/lang}" class="tooltip">
                                                            <img src="public/design/backend/images/cross.png" />
                                                        </a>
                                                        {/if}
                                                    </td>
                                                    <td style="text-align: center;">
                                                        <a href="{helper function="url::site" param1="admin/material_test/edit_question/`$it->id`"}?type={$it->type}" title="{lang}Edytuj{/lang}" class="tooltip">
                                                            <img src="public/design/backend/images/edit.png" />
                                                        </a>
                                                    </td>
                                                    <td style="text-align: center;">
                                                        <a href="javascript:void(0);" onclick="javascript:confirm_action('{helper function="url::site" param1="admin/material_test/delete_question/`$it->id`"}'); return false" title="{lang}Usuń{/lang}" class="tooltip">
                                                            <img src="public/design/backend/images/delete.png" />
                                                        </a>
                                                    </td>
                                                </tr>
                                                {foreachelse}
                                                <tr>
                                                    <td colspan="10">
                                                        <div style="text-align: center; font-weight: bold;">
                                                            {lang}Brak danych do wyświetlenia{/lang}
                                                        </div>
                                                    </td>
                                                </tr>
                                                {/foreach}
                                            </tbody>
                                        </table>
                                    </form>
                                    {/if}
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="clear"></div>
            <div id="sidebar">
                <div class="sidebar-content">
                    <a id="close_sidebar" class="btn ui-state-default full-link ui-corner-all" href="#drill">
                        <span class="ui-icon ui-icon-circle-arrow-e"></span>
                        {lang}Zamknij{/lang}
                    </a>
                    <a id="open_sidebar" class="btn tooltip ui-state-default full-link icon-only ui-corner-all" title="{lang}Otwórz{/lang}" href="#">
                        <span class="ui-icon ui-icon-circle-arrow-w"></span>
                    </a>
                    <div class="hide_sidebar">
                        <div class="portlet ui-widget ui-widget-content ui-helper-clearfix ui-corner-all">
                            <div class="portlet-header ui-widget-header">{lang}Baza szkoleń{/lang}</div>
                            <div class="portlet-content">
                                <ul class="side-menu layout-options">
                                    <li>
                                        <a href="{helper function="url::site" param1="admin/base/index/`$category_id`"}">{lang}Lista materiałów{/lang}</a>
                                    </li>
                                    <li>
                                        <a href="{helper function="url::site" param1="admin/base"}">{lang}Lista szkoleń{/lang}</a>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="clear"></div>
        </div>
        <div class="clear"></div>
    </div>
</div>

{literal}
<script type="text/javascript">
$(document).ready(function() {
    $('#tabs').tabs();
    $( "#start_on" ).datepicker({ dateFormat: 'yy-mm-dd', onSelect: function() { $(".ui-datepicker a").removeAttr("href"); }});
    $( "#start_on" ).datepicker( "option", "dateFormat", 'yy-mm-dd' );
    $( "#start_on" ).datepicker( "option", "monthNames", ['Styczeń','Luty','Marzec','Kwiecień','Maj','Czerwiec','Lipiec','Sierpień','Wrzesień','Październik','Listopad','Grudzień'] );
    $( "#start_on" ).datepicker( "option", "dayNamesMin", ['Nd', 'Pn', 'Wt', 'Śr', 'Cz', 'Pt', 'So'] );
    
    $( "#end_on" ).datepicker({ dateFormat: 'yy-mm-dd', onSelect: function() { $(".ui-datepicker a").removeAttr("href"); }});
    $( "#end_on" ).datepicker( "option", "dateFormat", 'yy-mm-dd' );
    $( "#end_on" ).datepicker( "option", "monthNames", ['Styczeń','Luty','Marzec','Kwiecień','Maj','Czerwiec','Lipiec','Sierpień','Wrzesień','Październik','Listopad','Grudzień'] );
    $( "#end_on" ).datepicker( "option", "dayNamesMin", ['Nd', 'Pn', 'Wt', 'Śr', 'Cz', 'Pt', 'So'] );
});
</script>
{/literal}