(function($){	
	$.fn.xwslide = function(options) {
		var defaults = {
		  time: 10000,
          autorun: true
		};
        
		var settings = $.extend({}, defaults, options); 
		
        return this.each(function() {            
            var $this = $(this),
                current_page = 0,
                news_pages = $('#topnews', $this).find('.one'),
                intervalID;     
            
            var plugin = {                
			    init: function() {
			        this.pagerCount();
                     
                    if ($('ul#newsPager li a', $this).length == 1) {
                        return;
                    }
                    else {
                        this.flip();                    
                        this.pNext();
                        this.pPrev();
                        
                        if (settings.autorun) {
                            this.pause();

                            intervalID = setInterval(this.autorun, settings.time);
                        }

                        $('ul#newsPager li a', $this).eq(0).addClass('activ');
                    }
				}, 
                flip: function() {
                    $('ul#newsPager li a', $this).each(function(index) {
                        $(this).bind('click', function() {
                            page = $(this).parent().attr('num');
                            
                            current_page = parseInt(page);
                            if (current_page == $('ul#newsPager li a', $this).length) {
                                current_page = 1;
                            }
                            
                            plugin.show(page);

                            if (settings.autorun) {
                                clearInterval(intervalID);

                                intervalID = setInterval(plugin.autorun, settings.time);
                            }

                            return false;
                        });
                    });
                },
                autorun: function() {
                    current_page++;
                    
                    if (current_page >= news_pages.length) {
                        current_page = 0;
                    }
                    
                    plugin.show(current_page); 
                },
                pNext: function() {
                    $('#box_next', $this).bind('click', function(event) {
                        current_page++;
                        
                        if (current_page >= news_pages.length) {
                            current_page = 0;
                        }
                        
                        plugin.show(current_page);
                        
                        return false;
                    });
    			},
                pPrev: function() {
                    $('#box_prev', $this).bind('click', function(event) {
                        current_page--;
                        
                        if (current_page < 0) {
                            current_page = news_pages.length-1;
                        }
                        
                        plugin.show(current_page);   
                        
                        
                        return false;         
                    });
        		},
                show: function(page) {
                    $('ul#newsPager li a', $this).each(function(index){
                        $(this).removeClass('activ');
                    });
                    
                    $('ul#newsPager li a', $this).eq(page).addClass('activ');
                    
                    $('#topnews div.one', $this).each( function(index){
                        $(this).fadeOut('slow').addClass('hide');
                    });
                    
                    $('#topnews div.one', $this).eq(page).removeClass('hide');
                    
                    $('#topnews div.one', $this).eq(page).fadeIn('slow');
                    
                    $('#topnews div.one', $this).eq(page).addClass('show');
                },
                pagerCount: function(){
                    $('ul#newsPager li a', $this).each(function(index, val) {
					   $(this).parent('li').attr('num', index);
                    });
                },
                pause: function() {
                    $this.bind('mouseover', function() {
                        clearInterval(intervalID); 
                    });
                    
                    $this.bind('mouseout', function() {
                        intervalID = setInterval(plugin.autorun, settings.time);
                    });
                }
        	};
			
            plugin.init();
        });
    }
})(jQuery);