function sendEMail(id, part, total) {
    advAJAX.get({
        url: base_uri('admin/newsletter/sendworker'),
        parameters : {
            'part' : part,
            'id': id
        },
        onLoading : function(obj) {
            if (part <= total) {
                if (part == 1) {
                    $("#dialogSendProgress").dialog({
                        bgiframe: true,
                        resizable: false,
                        draggable: false,
                        height:160,
                        width:350,
                        modal: true,
                        overlay: {
                            backgroundColor: '#000',
                            opacity: 0.5
                        }
                    });
                }
                
                putContent('Wysyłanie wiadomości część <b>' + part + '</b> z <b>' + total + '</b>', 'info');
                
                percent = parseInt(part / total * 100);
                
                if (percent > 100) {
                    percent = 100;
                }
                
                $("#progress").progressBar(percent);
                /*
                progress = '';
                for (i=1; i<=part; i++) {
				    progress += 'l';
                }
                
                progress += '<font color="#969696">';
                
                for (i=part+1; i<=total; i++) {
				    progress += 'l';
                }
                
                progress += '</font> ' + percent + '%';
                
                putContent(progress, 'progress');
                */
            }
        },
        onSuccess : function(obj) {
            if (obj.responseText == '1') {
                sendEMail(id, part + 1, total);
            }
            else {
                putContent('', 'loading');
                putContent('', 'progress');
                putContent('Wiadomość zostałą wysłana poprawnie, możesz zamknąć to okno', 'info');
            }
        },
        onError : function(obj) {
            alert('Error: ' + obj.status);
        }
	});
}
 
function putContent(content, div)
{
	document.getElementById(div).innerHTML=content;
}